/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutCoreNetworkPolicyRequest extends NetworkManagerRequest implements
        ToCopyableBuilder<PutCoreNetworkPolicyRequest.Builder, PutCoreNetworkPolicyRequest> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId").getter(getter(PutCoreNetworkPolicyRequest::coreNetworkId))
            .setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("coreNetworkId").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PolicyDocument")
            .getter(getter(PutCoreNetworkPolicyRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PutCoreNetworkPolicyRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> LATEST_VERSION_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LatestVersionId").getter(getter(PutCoreNetworkPolicyRequest::latestVersionId))
            .setter(setter(Builder::latestVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(PutCoreNetworkPolicyRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD,
            POLICY_DOCUMENT_FIELD, DESCRIPTION_FIELD, LATEST_VERSION_ID_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String coreNetworkId;

    private final String policyDocument;

    private final String description;

    private final Integer latestVersionId;

    private final String clientToken;

    private PutCoreNetworkPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.coreNetworkId = builder.coreNetworkId;
        this.policyDocument = builder.policyDocument;
        this.description = builder.description;
        this.latestVersionId = builder.latestVersionId;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of a core network.
     * </p>
     * 
     * @return The ID of a core network.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The policy document.
     * </p>
     * 
     * @return The policy document.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * a core network policy description.
     * </p>
     * 
     * @return a core network policy description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of a core network policy.
     * </p>
     * 
     * @return The ID of a core network policy.
     */
    public final Integer latestVersionId() {
        return latestVersionId;
    }

    /**
     * <p>
     * The client token associated with the request.
     * </p>
     * 
     * @return The client token associated with the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutCoreNetworkPolicyRequest)) {
            return false;
        }
        PutCoreNetworkPolicyRequest other = (PutCoreNetworkPolicyRequest) obj;
        return Objects.equals(coreNetworkId(), other.coreNetworkId()) && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(description(), other.description())
                && Objects.equals(latestVersionId(), other.latestVersionId())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutCoreNetworkPolicyRequest").add("CoreNetworkId", coreNetworkId())
                .add("PolicyDocument", policyDocument()).add("Description", description())
                .add("LatestVersionId", latestVersionId()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LatestVersionId":
            return Optional.ofNullable(clazz.cast(latestVersionId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("coreNetworkId", CORE_NETWORK_ID_FIELD);
        map.put("PolicyDocument", POLICY_DOCUMENT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("LatestVersionId", LATEST_VERSION_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutCoreNetworkPolicyRequest, T> g) {
        return obj -> g.apply((PutCoreNetworkPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutCoreNetworkPolicyRequest> {
        /**
         * <p>
         * The ID of a core network.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The policy document.
         * </p>
         * 
         * @param policyDocument
         *        The policy document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * a core network policy description.
         * </p>
         * 
         * @param description
         *        a core network policy description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of a core network policy.
         * </p>
         * 
         * @param latestVersionId
         *        The ID of a core network policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionId(Integer latestVersionId);

        /**
         * <p>
         * The client token associated with the request.
         * </p>
         * 
         * @param clientToken
         *        The client token associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NetworkManagerRequest.BuilderImpl implements Builder {
        private String coreNetworkId;

        private String policyDocument;

        private String description;

        private Integer latestVersionId;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PutCoreNetworkPolicyRequest model) {
            super(model);
            coreNetworkId(model.coreNetworkId);
            policyDocument(model.policyDocument);
            description(model.description);
            latestVersionId(model.latestVersionId);
            clientToken(model.clientToken);
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getLatestVersionId() {
            return latestVersionId;
        }

        public final void setLatestVersionId(Integer latestVersionId) {
            this.latestVersionId = latestVersionId;
        }

        @Override
        public final Builder latestVersionId(Integer latestVersionId) {
            this.latestVersionId = latestVersionId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutCoreNetworkPolicyRequest build() {
            return new PutCoreNetworkPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
