/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutCoreNetworkPolicyResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<PutCoreNetworkPolicyResponse.Builder, PutCoreNetworkPolicyResponse> {
    private static final SdkField<CoreNetworkPolicy> CORE_NETWORK_POLICY_FIELD = SdkField
            .<CoreNetworkPolicy> builder(MarshallingType.SDK_POJO).memberName("CoreNetworkPolicy")
            .getter(getter(PutCoreNetworkPolicyResponse::coreNetworkPolicy)).setter(setter(Builder::coreNetworkPolicy))
            .constructor(CoreNetworkPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CoreNetworkPolicy coreNetworkPolicy;

    private PutCoreNetworkPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.coreNetworkPolicy = builder.coreNetworkPolicy;
    }

    /**
     * <p>
     * Describes the changed core network policy.
     * </p>
     * 
     * @return Describes the changed core network policy.
     */
    public final CoreNetworkPolicy coreNetworkPolicy() {
        return coreNetworkPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutCoreNetworkPolicyResponse)) {
            return false;
        }
        PutCoreNetworkPolicyResponse other = (PutCoreNetworkPolicyResponse) obj;
        return Objects.equals(coreNetworkPolicy(), other.coreNetworkPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutCoreNetworkPolicyResponse").add("CoreNetworkPolicy", coreNetworkPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoreNetworkPolicy":
            return Optional.ofNullable(clazz.cast(coreNetworkPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CoreNetworkPolicy", CORE_NETWORK_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutCoreNetworkPolicyResponse, T> g) {
        return obj -> g.apply((PutCoreNetworkPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutCoreNetworkPolicyResponse> {
        /**
         * <p>
         * Describes the changed core network policy.
         * </p>
         * 
         * @param coreNetworkPolicy
         *        Describes the changed core network policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkPolicy(CoreNetworkPolicy coreNetworkPolicy);

        /**
         * <p>
         * Describes the changed core network policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoreNetworkPolicy.Builder} avoiding the
         * need to create one manually via {@link CoreNetworkPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoreNetworkPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #coreNetworkPolicy(CoreNetworkPolicy)}.
         * 
         * @param coreNetworkPolicy
         *        a consumer that will call methods on {@link CoreNetworkPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coreNetworkPolicy(CoreNetworkPolicy)
         */
        default Builder coreNetworkPolicy(Consumer<CoreNetworkPolicy.Builder> coreNetworkPolicy) {
            return coreNetworkPolicy(CoreNetworkPolicy.builder().applyMutation(coreNetworkPolicy).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private CoreNetworkPolicy coreNetworkPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutCoreNetworkPolicyResponse model) {
            super(model);
            coreNetworkPolicy(model.coreNetworkPolicy);
        }

        public final CoreNetworkPolicy.Builder getCoreNetworkPolicy() {
            return coreNetworkPolicy != null ? coreNetworkPolicy.toBuilder() : null;
        }

        public final void setCoreNetworkPolicy(CoreNetworkPolicy.BuilderImpl coreNetworkPolicy) {
            this.coreNetworkPolicy = coreNetworkPolicy != null ? coreNetworkPolicy.build() : null;
        }

        @Override
        public final Builder coreNetworkPolicy(CoreNetworkPolicy coreNetworkPolicy) {
            this.coreNetworkPolicy = coreNetworkPolicy;
            return this;
        }

        @Override
        public PutCoreNetworkPolicyResponse build() {
            return new PutCoreNetworkPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
