/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteTableIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteTableIdentifier.Builder, RouteTableIdentifier> {
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayRouteTableArn")
            .getter(getter(RouteTableIdentifier::transitGatewayRouteTableArn))
            .setter(setter(Builder::transitGatewayRouteTableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableArn")
                    .build()).build();

    private static final SdkField<CoreNetworkSegmentEdgeIdentifier> CORE_NETWORK_SEGMENT_EDGE_FIELD = SdkField
            .<CoreNetworkSegmentEdgeIdentifier> builder(MarshallingType.SDK_POJO).memberName("CoreNetworkSegmentEdge")
            .getter(getter(RouteTableIdentifier::coreNetworkSegmentEdge)).setter(setter(Builder::coreNetworkSegmentEdge))
            .constructor(CoreNetworkSegmentEdgeIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkSegmentEdge").build())
            .build();

    private static final SdkField<CoreNetworkNetworkFunctionGroupIdentifier> CORE_NETWORK_NETWORK_FUNCTION_GROUP_FIELD = SdkField
            .<CoreNetworkNetworkFunctionGroupIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("CoreNetworkNetworkFunctionGroup")
            .getter(getter(RouteTableIdentifier::coreNetworkNetworkFunctionGroup))
            .setter(setter(Builder::coreNetworkNetworkFunctionGroup))
            .constructor(CoreNetworkNetworkFunctionGroupIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkNetworkFunctionGroup")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ROUTE_TABLE_ARN_FIELD, CORE_NETWORK_SEGMENT_EDGE_FIELD, CORE_NETWORK_NETWORK_FUNCTION_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transitGatewayRouteTableArn;

    private final CoreNetworkSegmentEdgeIdentifier coreNetworkSegmentEdge;

    private final CoreNetworkNetworkFunctionGroupIdentifier coreNetworkNetworkFunctionGroup;

    private RouteTableIdentifier(BuilderImpl builder) {
        this.transitGatewayRouteTableArn = builder.transitGatewayRouteTableArn;
        this.coreNetworkSegmentEdge = builder.coreNetworkSegmentEdge;
        this.coreNetworkNetworkFunctionGroup = builder.coreNetworkNetworkFunctionGroup;
    }

    /**
     * <p>
     * The ARN of the transit gateway route table for the attachment request. For example,
     * <code>"TransitGatewayRouteTableArn": "arn:aws:ec2:us-west-2:123456789012:transit-gateway-route-table/tgw-rtb-9876543210123456"</code>
     * .
     * </p>
     * 
     * @return The ARN of the transit gateway route table for the attachment request. For example,
     *         <code>"TransitGatewayRouteTableArn": "arn:aws:ec2:us-west-2:123456789012:transit-gateway-route-table/tgw-rtb-9876543210123456"</code>
     *         .
     */
    public final String transitGatewayRouteTableArn() {
        return transitGatewayRouteTableArn;
    }

    /**
     * <p>
     * The segment edge in a core network.
     * </p>
     * 
     * @return The segment edge in a core network.
     */
    public final CoreNetworkSegmentEdgeIdentifier coreNetworkSegmentEdge() {
        return coreNetworkSegmentEdge;
    }

    /**
     * <p>
     * The route table identifier associated with the network function group.
     * </p>
     * 
     * @return The route table identifier associated with the network function group.
     */
    public final CoreNetworkNetworkFunctionGroupIdentifier coreNetworkNetworkFunctionGroup() {
        return coreNetworkNetworkFunctionGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayRouteTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkSegmentEdge());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkNetworkFunctionGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTableIdentifier)) {
            return false;
        }
        RouteTableIdentifier other = (RouteTableIdentifier) obj;
        return Objects.equals(transitGatewayRouteTableArn(), other.transitGatewayRouteTableArn())
                && Objects.equals(coreNetworkSegmentEdge(), other.coreNetworkSegmentEdge())
                && Objects.equals(coreNetworkNetworkFunctionGroup(), other.coreNetworkNetworkFunctionGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteTableIdentifier").add("TransitGatewayRouteTableArn", transitGatewayRouteTableArn())
                .add("CoreNetworkSegmentEdge", coreNetworkSegmentEdge())
                .add("CoreNetworkNetworkFunctionGroup", coreNetworkNetworkFunctionGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayRouteTableArn":
            return Optional.ofNullable(clazz.cast(transitGatewayRouteTableArn()));
        case "CoreNetworkSegmentEdge":
            return Optional.ofNullable(clazz.cast(coreNetworkSegmentEdge()));
        case "CoreNetworkNetworkFunctionGroup":
            return Optional.ofNullable(clazz.cast(coreNetworkNetworkFunctionGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransitGatewayRouteTableArn", TRANSIT_GATEWAY_ROUTE_TABLE_ARN_FIELD);
        map.put("CoreNetworkSegmentEdge", CORE_NETWORK_SEGMENT_EDGE_FIELD);
        map.put("CoreNetworkNetworkFunctionGroup", CORE_NETWORK_NETWORK_FUNCTION_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteTableIdentifier, T> g) {
        return obj -> g.apply((RouteTableIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteTableIdentifier> {
        /**
         * <p>
         * The ARN of the transit gateway route table for the attachment request. For example,
         * <code>"TransitGatewayRouteTableArn": "arn:aws:ec2:us-west-2:123456789012:transit-gateway-route-table/tgw-rtb-9876543210123456"</code>
         * .
         * </p>
         * 
         * @param transitGatewayRouteTableArn
         *        The ARN of the transit gateway route table for the attachment request. For example,
         *        <code>"TransitGatewayRouteTableArn": "arn:aws:ec2:us-west-2:123456789012:transit-gateway-route-table/tgw-rtb-9876543210123456"</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRouteTableArn(String transitGatewayRouteTableArn);

        /**
         * <p>
         * The segment edge in a core network.
         * </p>
         * 
         * @param coreNetworkSegmentEdge
         *        The segment edge in a core network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkSegmentEdge(CoreNetworkSegmentEdgeIdentifier coreNetworkSegmentEdge);

        /**
         * <p>
         * The segment edge in a core network.
         * </p>
         * This is a convenience method that creates an instance of the {@link CoreNetworkSegmentEdgeIdentifier.Builder}
         * avoiding the need to create one manually via {@link CoreNetworkSegmentEdgeIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoreNetworkSegmentEdgeIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #coreNetworkSegmentEdge(CoreNetworkSegmentEdgeIdentifier)}.
         * 
         * @param coreNetworkSegmentEdge
         *        a consumer that will call methods on {@link CoreNetworkSegmentEdgeIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coreNetworkSegmentEdge(CoreNetworkSegmentEdgeIdentifier)
         */
        default Builder coreNetworkSegmentEdge(Consumer<CoreNetworkSegmentEdgeIdentifier.Builder> coreNetworkSegmentEdge) {
            return coreNetworkSegmentEdge(CoreNetworkSegmentEdgeIdentifier.builder().applyMutation(coreNetworkSegmentEdge)
                    .build());
        }

        /**
         * <p>
         * The route table identifier associated with the network function group.
         * </p>
         * 
         * @param coreNetworkNetworkFunctionGroup
         *        The route table identifier associated with the network function group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkNetworkFunctionGroup(CoreNetworkNetworkFunctionGroupIdentifier coreNetworkNetworkFunctionGroup);

        /**
         * <p>
         * The route table identifier associated with the network function group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CoreNetworkNetworkFunctionGroupIdentifier.Builder} avoiding the need to create one manually via
         * {@link CoreNetworkNetworkFunctionGroupIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CoreNetworkNetworkFunctionGroupIdentifier.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #coreNetworkNetworkFunctionGroup(CoreNetworkNetworkFunctionGroupIdentifier)}.
         * 
         * @param coreNetworkNetworkFunctionGroup
         *        a consumer that will call methods on {@link CoreNetworkNetworkFunctionGroupIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coreNetworkNetworkFunctionGroup(CoreNetworkNetworkFunctionGroupIdentifier)
         */
        default Builder coreNetworkNetworkFunctionGroup(
                Consumer<CoreNetworkNetworkFunctionGroupIdentifier.Builder> coreNetworkNetworkFunctionGroup) {
            return coreNetworkNetworkFunctionGroup(CoreNetworkNetworkFunctionGroupIdentifier.builder()
                    .applyMutation(coreNetworkNetworkFunctionGroup).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayRouteTableArn;

        private CoreNetworkSegmentEdgeIdentifier coreNetworkSegmentEdge;

        private CoreNetworkNetworkFunctionGroupIdentifier coreNetworkNetworkFunctionGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTableIdentifier model) {
            transitGatewayRouteTableArn(model.transitGatewayRouteTableArn);
            coreNetworkSegmentEdge(model.coreNetworkSegmentEdge);
            coreNetworkNetworkFunctionGroup(model.coreNetworkNetworkFunctionGroup);
        }

        public final String getTransitGatewayRouteTableArn() {
            return transitGatewayRouteTableArn;
        }

        public final void setTransitGatewayRouteTableArn(String transitGatewayRouteTableArn) {
            this.transitGatewayRouteTableArn = transitGatewayRouteTableArn;
        }

        @Override
        public final Builder transitGatewayRouteTableArn(String transitGatewayRouteTableArn) {
            this.transitGatewayRouteTableArn = transitGatewayRouteTableArn;
            return this;
        }

        public final CoreNetworkSegmentEdgeIdentifier.Builder getCoreNetworkSegmentEdge() {
            return coreNetworkSegmentEdge != null ? coreNetworkSegmentEdge.toBuilder() : null;
        }

        public final void setCoreNetworkSegmentEdge(CoreNetworkSegmentEdgeIdentifier.BuilderImpl coreNetworkSegmentEdge) {
            this.coreNetworkSegmentEdge = coreNetworkSegmentEdge != null ? coreNetworkSegmentEdge.build() : null;
        }

        @Override
        public final Builder coreNetworkSegmentEdge(CoreNetworkSegmentEdgeIdentifier coreNetworkSegmentEdge) {
            this.coreNetworkSegmentEdge = coreNetworkSegmentEdge;
            return this;
        }

        public final CoreNetworkNetworkFunctionGroupIdentifier.Builder getCoreNetworkNetworkFunctionGroup() {
            return coreNetworkNetworkFunctionGroup != null ? coreNetworkNetworkFunctionGroup.toBuilder() : null;
        }

        public final void setCoreNetworkNetworkFunctionGroup(
                CoreNetworkNetworkFunctionGroupIdentifier.BuilderImpl coreNetworkNetworkFunctionGroup) {
            this.coreNetworkNetworkFunctionGroup = coreNetworkNetworkFunctionGroup != null ? coreNetworkNetworkFunctionGroup
                    .build() : null;
        }

        @Override
        public final Builder coreNetworkNetworkFunctionGroup(
                CoreNetworkNetworkFunctionGroupIdentifier coreNetworkNetworkFunctionGroup) {
            this.coreNetworkNetworkFunctionGroup = coreNetworkNetworkFunctionGroup;
            return this;
        }

        @Override
        public RouteTableIdentifier build() {
            return new RouteTableIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
