/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartRouteAnalysisResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<StartRouteAnalysisResponse.Builder, StartRouteAnalysisResponse> {
    private static final SdkField<RouteAnalysis> ROUTE_ANALYSIS_FIELD = SdkField
            .<RouteAnalysis> builder(MarshallingType.SDK_POJO).memberName("RouteAnalysis")
            .getter(getter(StartRouteAnalysisResponse::routeAnalysis)).setter(setter(Builder::routeAnalysis))
            .constructor(RouteAnalysis::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteAnalysis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_ANALYSIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RouteAnalysis routeAnalysis;

    private StartRouteAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.routeAnalysis = builder.routeAnalysis;
    }

    /**
     * <p>
     * The route analysis.
     * </p>
     * 
     * @return The route analysis.
     */
    public final RouteAnalysis routeAnalysis() {
        return routeAnalysis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(routeAnalysis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRouteAnalysisResponse)) {
            return false;
        }
        StartRouteAnalysisResponse other = (StartRouteAnalysisResponse) obj;
        return Objects.equals(routeAnalysis(), other.routeAnalysis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartRouteAnalysisResponse").add("RouteAnalysis", routeAnalysis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteAnalysis":
            return Optional.ofNullable(clazz.cast(routeAnalysis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RouteAnalysis", ROUTE_ANALYSIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartRouteAnalysisResponse, T> g) {
        return obj -> g.apply((StartRouteAnalysisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartRouteAnalysisResponse> {
        /**
         * <p>
         * The route analysis.
         * </p>
         * 
         * @param routeAnalysis
         *        The route analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeAnalysis(RouteAnalysis routeAnalysis);

        /**
         * <p>
         * The route analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteAnalysis.Builder} avoiding the need
         * to create one manually via {@link RouteAnalysis#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteAnalysis.Builder#build()} is called immediately and its
         * result is passed to {@link #routeAnalysis(RouteAnalysis)}.
         * 
         * @param routeAnalysis
         *        a consumer that will call methods on {@link RouteAnalysis.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeAnalysis(RouteAnalysis)
         */
        default Builder routeAnalysis(Consumer<RouteAnalysis.Builder> routeAnalysis) {
            return routeAnalysis(RouteAnalysis.builder().applyMutation(routeAnalysis).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private RouteAnalysis routeAnalysis;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRouteAnalysisResponse model) {
            super(model);
            routeAnalysis(model.routeAnalysis);
        }

        public final RouteAnalysis.Builder getRouteAnalysis() {
            return routeAnalysis != null ? routeAnalysis.toBuilder() : null;
        }

        public final void setRouteAnalysis(RouteAnalysis.BuilderImpl routeAnalysis) {
            this.routeAnalysis = routeAnalysis != null ? routeAnalysis.build() : null;
        }

        @Override
        public final Builder routeAnalysis(RouteAnalysis routeAnalysis) {
            this.routeAnalysis = routeAnalysis;
            return this;
        }

        @Override
        public StartRouteAnalysisResponse build() {
            return new StartRouteAnalysisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
