/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDirectConnectGatewayAttachmentResponse extends NetworkManagerResponse implements
        ToCopyableBuilder<UpdateDirectConnectGatewayAttachmentResponse.Builder, UpdateDirectConnectGatewayAttachmentResponse> {
    private static final SdkField<DirectConnectGatewayAttachment> DIRECT_CONNECT_GATEWAY_ATTACHMENT_FIELD = SdkField
            .<DirectConnectGatewayAttachment> builder(MarshallingType.SDK_POJO)
            .memberName("DirectConnectGatewayAttachment")
            .getter(getter(UpdateDirectConnectGatewayAttachmentResponse::directConnectGatewayAttachment))
            .setter(setter(Builder::directConnectGatewayAttachment))
            .constructor(DirectConnectGatewayAttachment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectConnectGatewayAttachment")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DIRECT_CONNECT_GATEWAY_ATTACHMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DirectConnectGatewayAttachment directConnectGatewayAttachment;

    private UpdateDirectConnectGatewayAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayAttachment = builder.directConnectGatewayAttachment;
    }

    /**
     * <p>
     * Returns details of the Direct Connect gateway attachment with the updated edge locations.
     * </p>
     * 
     * @return Returns details of the Direct Connect gateway attachment with the updated edge locations.
     */
    public final DirectConnectGatewayAttachment directConnectGatewayAttachment() {
        return directConnectGatewayAttachment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGatewayAttachment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDirectConnectGatewayAttachmentResponse)) {
            return false;
        }
        UpdateDirectConnectGatewayAttachmentResponse other = (UpdateDirectConnectGatewayAttachmentResponse) obj;
        return Objects.equals(directConnectGatewayAttachment(), other.directConnectGatewayAttachment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDirectConnectGatewayAttachmentResponse")
                .add("DirectConnectGatewayAttachment", directConnectGatewayAttachment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectConnectGatewayAttachment":
            return Optional.ofNullable(clazz.cast(directConnectGatewayAttachment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectConnectGatewayAttachment", DIRECT_CONNECT_GATEWAY_ATTACHMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDirectConnectGatewayAttachmentResponse, T> g) {
        return obj -> g.apply((UpdateDirectConnectGatewayAttachmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NetworkManagerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDirectConnectGatewayAttachmentResponse> {
        /**
         * <p>
         * Returns details of the Direct Connect gateway attachment with the updated edge locations.
         * </p>
         * 
         * @param directConnectGatewayAttachment
         *        Returns details of the Direct Connect gateway attachment with the updated edge locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayAttachment(DirectConnectGatewayAttachment directConnectGatewayAttachment);

        /**
         * <p>
         * Returns details of the Direct Connect gateway attachment with the updated edge locations.
         * </p>
         * This is a convenience method that creates an instance of the {@link DirectConnectGatewayAttachment.Builder}
         * avoiding the need to create one manually via {@link DirectConnectGatewayAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectConnectGatewayAttachment.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #directConnectGatewayAttachment(DirectConnectGatewayAttachment)}.
         * 
         * @param directConnectGatewayAttachment
         *        a consumer that will call methods on {@link DirectConnectGatewayAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directConnectGatewayAttachment(DirectConnectGatewayAttachment)
         */
        default Builder directConnectGatewayAttachment(
                Consumer<DirectConnectGatewayAttachment.Builder> directConnectGatewayAttachment) {
            return directConnectGatewayAttachment(DirectConnectGatewayAttachment.builder()
                    .applyMutation(directConnectGatewayAttachment).build());
        }
    }

    static final class BuilderImpl extends NetworkManagerResponse.BuilderImpl implements Builder {
        private DirectConnectGatewayAttachment directConnectGatewayAttachment;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDirectConnectGatewayAttachmentResponse model) {
            super(model);
            directConnectGatewayAttachment(model.directConnectGatewayAttachment);
        }

        public final DirectConnectGatewayAttachment.Builder getDirectConnectGatewayAttachment() {
            return directConnectGatewayAttachment != null ? directConnectGatewayAttachment.toBuilder() : null;
        }

        public final void setDirectConnectGatewayAttachment(
                DirectConnectGatewayAttachment.BuilderImpl directConnectGatewayAttachment) {
            this.directConnectGatewayAttachment = directConnectGatewayAttachment != null ? directConnectGatewayAttachment.build()
                    : null;
        }

        @Override
        public final Builder directConnectGatewayAttachment(DirectConnectGatewayAttachment directConnectGatewayAttachment) {
            this.directConnectGatewayAttachment = directConnectGatewayAttachment;
            return this;
        }

        @Override
        public UpdateDirectConnectGatewayAttachmentResponse build() {
            return new UpdateDirectConnectGatewayAttachmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
