/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for IAM Identity Center for an OpenSearch Application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IamIdentityCenterOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<IamIdentityCenterOptions.Builder, IamIdentityCenterOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(IamIdentityCenterOptions::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<String> IAM_IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("iamIdentityCenterInstanceArn")
            .getter(getter(IamIdentityCenterOptions::iamIdentityCenterInstanceArn))
            .setter(setter(Builder::iamIdentityCenterInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityCenterInstanceArn")
                    .build()).build();

    private static final SdkField<String> IAM_ROLE_FOR_IDENTITY_CENTER_APPLICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("iamRoleForIdentityCenterApplicationArn")
            .getter(getter(IamIdentityCenterOptions::iamRoleForIdentityCenterApplicationArn))
            .setter(setter(Builder::iamRoleForIdentityCenterApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("iamRoleForIdentityCenterApplicationArn").build()).build();

    private static final SdkField<String> IAM_IDENTITY_CENTER_APPLICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("iamIdentityCenterApplicationArn")
            .getter(getter(IamIdentityCenterOptions::iamIdentityCenterApplicationArn))
            .setter(setter(Builder::iamIdentityCenterApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityCenterApplicationArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            IAM_IDENTITY_CENTER_INSTANCE_ARN_FIELD, IAM_ROLE_FOR_IDENTITY_CENTER_APPLICATION_ARN_FIELD,
            IAM_IDENTITY_CENTER_APPLICATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String iamIdentityCenterInstanceArn;

    private final String iamRoleForIdentityCenterApplicationArn;

    private final String iamIdentityCenterApplicationArn;

    private IamIdentityCenterOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.iamIdentityCenterInstanceArn = builder.iamIdentityCenterInstanceArn;
        this.iamRoleForIdentityCenterApplicationArn = builder.iamRoleForIdentityCenterApplicationArn;
        this.iamIdentityCenterApplicationArn = builder.iamIdentityCenterApplicationArn;
    }

    /**
     * <p>
     * IAM Identity Center is enabled for the OpenSearch Application.
     * </p>
     * 
     * @return IAM Identity Center is enabled for the OpenSearch Application.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * Returns the value of the IamIdentityCenterInstanceArn property for this object.
     * 
     * @return The value of the IamIdentityCenterInstanceArn property for this object.
     */
    public final String iamIdentityCenterInstanceArn() {
        return iamIdentityCenterInstanceArn;
    }

    /**
     * <p>
     * Amazon Resource Name of the IAM Identity Center's Application created for the OpenSearch Application after
     * enabling IAM Identity Center.
     * </p>
     * 
     * @return Amazon Resource Name of the IAM Identity Center's Application created for the OpenSearch Application
     *         after enabling IAM Identity Center.
     */
    public final String iamRoleForIdentityCenterApplicationArn() {
        return iamRoleForIdentityCenterApplicationArn;
    }

    /**
     * Returns the value of the IamIdentityCenterApplicationArn property for this object.
     * 
     * @return The value of the IamIdentityCenterApplicationArn property for this object.
     */
    public final String iamIdentityCenterApplicationArn() {
        return iamIdentityCenterApplicationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(iamIdentityCenterInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleForIdentityCenterApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamIdentityCenterApplicationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamIdentityCenterOptions)) {
            return false;
        }
        IamIdentityCenterOptions other = (IamIdentityCenterOptions) obj;
        return Objects.equals(enabled(), other.enabled())
                && Objects.equals(iamIdentityCenterInstanceArn(), other.iamIdentityCenterInstanceArn())
                && Objects.equals(iamRoleForIdentityCenterApplicationArn(), other.iamRoleForIdentityCenterApplicationArn())
                && Objects.equals(iamIdentityCenterApplicationArn(), other.iamIdentityCenterApplicationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IamIdentityCenterOptions").add("Enabled", enabled())
                .add("IamIdentityCenterInstanceArn", iamIdentityCenterInstanceArn())
                .add("IamRoleForIdentityCenterApplicationArn", iamRoleForIdentityCenterApplicationArn())
                .add("IamIdentityCenterApplicationArn", iamIdentityCenterApplicationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "iamIdentityCenterInstanceArn":
            return Optional.ofNullable(clazz.cast(iamIdentityCenterInstanceArn()));
        case "iamRoleForIdentityCenterApplicationArn":
            return Optional.ofNullable(clazz.cast(iamRoleForIdentityCenterApplicationArn()));
        case "iamIdentityCenterApplicationArn":
            return Optional.ofNullable(clazz.cast(iamIdentityCenterApplicationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("iamIdentityCenterInstanceArn", IAM_IDENTITY_CENTER_INSTANCE_ARN_FIELD);
        map.put("iamRoleForIdentityCenterApplicationArn", IAM_ROLE_FOR_IDENTITY_CENTER_APPLICATION_ARN_FIELD);
        map.put("iamIdentityCenterApplicationArn", IAM_IDENTITY_CENTER_APPLICATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IamIdentityCenterOptions, T> g) {
        return obj -> g.apply((IamIdentityCenterOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IamIdentityCenterOptions> {
        /**
         * <p>
         * IAM Identity Center is enabled for the OpenSearch Application.
         * </p>
         * 
         * @param enabled
         *        IAM Identity Center is enabled for the OpenSearch Application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * Sets the value of the IamIdentityCenterInstanceArn property for this object.
         *
         * @param iamIdentityCenterInstanceArn
         *        The new value for the IamIdentityCenterInstanceArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamIdentityCenterInstanceArn(String iamIdentityCenterInstanceArn);

        /**
         * <p>
         * Amazon Resource Name of the IAM Identity Center's Application created for the OpenSearch Application after
         * enabling IAM Identity Center.
         * </p>
         * 
         * @param iamRoleForIdentityCenterApplicationArn
         *        Amazon Resource Name of the IAM Identity Center's Application created for the OpenSearch Application
         *        after enabling IAM Identity Center.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleForIdentityCenterApplicationArn(String iamRoleForIdentityCenterApplicationArn);

        /**
         * Sets the value of the IamIdentityCenterApplicationArn property for this object.
         *
         * @param iamIdentityCenterApplicationArn
         *        The new value for the IamIdentityCenterApplicationArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamIdentityCenterApplicationArn(String iamIdentityCenterApplicationArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String iamIdentityCenterInstanceArn;

        private String iamRoleForIdentityCenterApplicationArn;

        private String iamIdentityCenterApplicationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IamIdentityCenterOptions model) {
            enabled(model.enabled);
            iamIdentityCenterInstanceArn(model.iamIdentityCenterInstanceArn);
            iamRoleForIdentityCenterApplicationArn(model.iamRoleForIdentityCenterApplicationArn);
            iamIdentityCenterApplicationArn(model.iamIdentityCenterApplicationArn);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getIamIdentityCenterInstanceArn() {
            return iamIdentityCenterInstanceArn;
        }

        public final void setIamIdentityCenterInstanceArn(String iamIdentityCenterInstanceArn) {
            this.iamIdentityCenterInstanceArn = iamIdentityCenterInstanceArn;
        }

        @Override
        public final Builder iamIdentityCenterInstanceArn(String iamIdentityCenterInstanceArn) {
            this.iamIdentityCenterInstanceArn = iamIdentityCenterInstanceArn;
            return this;
        }

        public final String getIamRoleForIdentityCenterApplicationArn() {
            return iamRoleForIdentityCenterApplicationArn;
        }

        public final void setIamRoleForIdentityCenterApplicationArn(String iamRoleForIdentityCenterApplicationArn) {
            this.iamRoleForIdentityCenterApplicationArn = iamRoleForIdentityCenterApplicationArn;
        }

        @Override
        public final Builder iamRoleForIdentityCenterApplicationArn(String iamRoleForIdentityCenterApplicationArn) {
            this.iamRoleForIdentityCenterApplicationArn = iamRoleForIdentityCenterApplicationArn;
            return this;
        }

        public final String getIamIdentityCenterApplicationArn() {
            return iamIdentityCenterApplicationArn;
        }

        public final void setIamIdentityCenterApplicationArn(String iamIdentityCenterApplicationArn) {
            this.iamIdentityCenterApplicationArn = iamIdentityCenterApplicationArn;
        }

        @Override
        public final Builder iamIdentityCenterApplicationArn(String iamIdentityCenterApplicationArn) {
            this.iamIdentityCenterApplicationArn = iamIdentityCenterApplicationArn;
            return this;
        }

        @Override
        public IamIdentityCenterOptions build() {
            return new IamIdentityCenterOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
