/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom 10-hour, low-traffic window during which OpenSearch Service can perform mandatory configuration changes on
 * the domain. These actions can include scheduled service software updates and blue/green Auto-Tune enhancements.
 * OpenSearch Service will schedule these actions during the window that you specify.
 * </p>
 * <p>
 * If you don't specify a window start time, it defaults to 10:00 P.M. local time.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html">Defining off-peak
 * maintenance windows for Amazon OpenSearch Service</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OffPeakWindow implements SdkPojo, Serializable, ToCopyableBuilder<OffPeakWindow.Builder, OffPeakWindow> {
    private static final SdkField<WindowStartTime> WINDOW_START_TIME_FIELD = SdkField
            .<WindowStartTime> builder(MarshallingType.SDK_POJO).memberName("WindowStartTime")
            .getter(getter(OffPeakWindow::windowStartTime)).setter(setter(Builder::windowStartTime))
            .constructor(WindowStartTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowStartTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final WindowStartTime windowStartTime;

    private OffPeakWindow(BuilderImpl builder) {
        this.windowStartTime = builder.windowStartTime;
    }

    /**
     * <p>
     * A custom start time for the off-peak window, in Coordinated Universal Time (UTC). The window length will always
     * be 10 hours, so you can't specify an end time. For example, if you specify 11:00 P.M. UTC as a start time, the
     * end time will automatically be set to 9:00 A.M.
     * </p>
     * 
     * @return A custom start time for the off-peak window, in Coordinated Universal Time (UTC). The window length will
     *         always be 10 hours, so you can't specify an end time. For example, if you specify 11:00 P.M. UTC as a
     *         start time, the end time will automatically be set to 9:00 A.M.
     */
    public final WindowStartTime windowStartTime() {
        return windowStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OffPeakWindow)) {
            return false;
        }
        OffPeakWindow other = (OffPeakWindow) obj;
        return Objects.equals(windowStartTime(), other.windowStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OffPeakWindow").add("WindowStartTime", windowStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowStartTime":
            return Optional.ofNullable(clazz.cast(windowStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WindowStartTime", WINDOW_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OffPeakWindow, T> g) {
        return obj -> g.apply((OffPeakWindow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OffPeakWindow> {
        /**
         * <p>
         * A custom start time for the off-peak window, in Coordinated Universal Time (UTC). The window length will
         * always be 10 hours, so you can't specify an end time. For example, if you specify 11:00 P.M. UTC as a start
         * time, the end time will automatically be set to 9:00 A.M.
         * </p>
         * 
         * @param windowStartTime
         *        A custom start time for the off-peak window, in Coordinated Universal Time (UTC). The window length
         *        will always be 10 hours, so you can't specify an end time. For example, if you specify 11:00 P.M. UTC
         *        as a start time, the end time will automatically be set to 9:00 A.M.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowStartTime(WindowStartTime windowStartTime);

        /**
         * <p>
         * A custom start time for the off-peak window, in Coordinated Universal Time (UTC). The window length will
         * always be 10 hours, so you can't specify an end time. For example, if you specify 11:00 P.M. UTC as a start
         * time, the end time will automatically be set to 9:00 A.M.
         * </p>
         * This is a convenience method that creates an instance of the {@link WindowStartTime.Builder} avoiding the
         * need to create one manually via {@link WindowStartTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WindowStartTime.Builder#build()} is called immediately and its
         * result is passed to {@link #windowStartTime(WindowStartTime)}.
         * 
         * @param windowStartTime
         *        a consumer that will call methods on {@link WindowStartTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowStartTime(WindowStartTime)
         */
        default Builder windowStartTime(Consumer<WindowStartTime.Builder> windowStartTime) {
            return windowStartTime(WindowStartTime.builder().applyMutation(windowStartTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private WindowStartTime windowStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OffPeakWindow model) {
            windowStartTime(model.windowStartTime);
        }

        public final WindowStartTime.Builder getWindowStartTime() {
            return windowStartTime != null ? windowStartTime.toBuilder() : null;
        }

        public final void setWindowStartTime(WindowStartTime.BuilderImpl windowStartTime) {
            this.windowStartTime = windowStartTime != null ? windowStartTime.build() : null;
        }

        @Override
        public final Builder windowStartTime(WindowStartTime windowStartTime) {
            this.windowStartTime = windowStartTime;
            return this;
        }

        @Override
        public OffPeakWindow build() {
            return new OffPeakWindow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
