/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration parameters for a package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageConfiguration.Builder, PackageConfiguration> {
    private static final SdkField<String> LICENSE_REQUIREMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseRequirement").getter(getter(PackageConfiguration::licenseRequirementAsString))
            .setter(setter(Builder::licenseRequirement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseRequirement").build())
            .build();

    private static final SdkField<String> LICENSE_FILEPATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseFilepath").getter(getter(PackageConfiguration::licenseFilepath))
            .setter(setter(Builder::licenseFilepath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseFilepath").build()).build();

    private static final SdkField<String> CONFIGURATION_REQUIREMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationRequirement").getter(getter(PackageConfiguration::configurationRequirementAsString))
            .setter(setter(Builder::configurationRequirement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationRequirement").build())
            .build();

    private static final SdkField<Boolean> REQUIRES_RESTART_FOR_CONFIGURATION_UPDATE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequiresRestartForConfigurationUpdate")
            .getter(getter(PackageConfiguration::requiresRestartForConfigurationUpdate))
            .setter(setter(Builder::requiresRestartForConfigurationUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RequiresRestartForConfigurationUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_REQUIREMENT_FIELD,
            LICENSE_FILEPATH_FIELD, CONFIGURATION_REQUIREMENT_FIELD, REQUIRES_RESTART_FOR_CONFIGURATION_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String licenseRequirement;

    private final String licenseFilepath;

    private final String configurationRequirement;

    private final Boolean requiresRestartForConfigurationUpdate;

    private PackageConfiguration(BuilderImpl builder) {
        this.licenseRequirement = builder.licenseRequirement;
        this.licenseFilepath = builder.licenseFilepath;
        this.configurationRequirement = builder.configurationRequirement;
        this.requiresRestartForConfigurationUpdate = builder.requiresRestartForConfigurationUpdate;
    }

    /**
     * <p>
     * The license requirements for the package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #licenseRequirement} will return {@link RequirementLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #licenseRequirementAsString}.
     * </p>
     * 
     * @return The license requirements for the package.
     * @see RequirementLevel
     */
    public final RequirementLevel licenseRequirement() {
        return RequirementLevel.fromValue(licenseRequirement);
    }

    /**
     * <p>
     * The license requirements for the package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #licenseRequirement} will return {@link RequirementLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #licenseRequirementAsString}.
     * </p>
     * 
     * @return The license requirements for the package.
     * @see RequirementLevel
     */
    public final String licenseRequirementAsString() {
        return licenseRequirement;
    }

    /**
     * <p>
     * The relative file path for the license associated with the package.
     * </p>
     * 
     * @return The relative file path for the license associated with the package.
     */
    public final String licenseFilepath() {
        return licenseFilepath;
    }

    /**
     * <p>
     * The configuration requirements for the package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationRequirement} will return {@link RequirementLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationRequirementAsString}.
     * </p>
     * 
     * @return The configuration requirements for the package.
     * @see RequirementLevel
     */
    public final RequirementLevel configurationRequirement() {
        return RequirementLevel.fromValue(configurationRequirement);
    }

    /**
     * <p>
     * The configuration requirements for the package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationRequirement} will return {@link RequirementLevel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationRequirementAsString}.
     * </p>
     * 
     * @return The configuration requirements for the package.
     * @see RequirementLevel
     */
    public final String configurationRequirementAsString() {
        return configurationRequirement;
    }

    /**
     * <p>
     * This indicates whether a B/G deployment is required for updating the configuration that the plugin is
     * prerequisite for.
     * </p>
     * 
     * @return This indicates whether a B/G deployment is required for updating the configuration that the plugin is
     *         prerequisite for.
     */
    public final Boolean requiresRestartForConfigurationUpdate() {
        return requiresRestartForConfigurationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(licenseRequirementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(licenseFilepath());
        hashCode = 31 * hashCode + Objects.hashCode(configurationRequirementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(requiresRestartForConfigurationUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageConfiguration)) {
            return false;
        }
        PackageConfiguration other = (PackageConfiguration) obj;
        return Objects.equals(licenseRequirementAsString(), other.licenseRequirementAsString())
                && Objects.equals(licenseFilepath(), other.licenseFilepath())
                && Objects.equals(configurationRequirementAsString(), other.configurationRequirementAsString())
                && Objects.equals(requiresRestartForConfigurationUpdate(), other.requiresRestartForConfigurationUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageConfiguration").add("LicenseRequirement", licenseRequirementAsString())
                .add("LicenseFilepath", licenseFilepath()).add("ConfigurationRequirement", configurationRequirementAsString())
                .add("RequiresRestartForConfigurationUpdate", requiresRestartForConfigurationUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LicenseRequirement":
            return Optional.ofNullable(clazz.cast(licenseRequirementAsString()));
        case "LicenseFilepath":
            return Optional.ofNullable(clazz.cast(licenseFilepath()));
        case "ConfigurationRequirement":
            return Optional.ofNullable(clazz.cast(configurationRequirementAsString()));
        case "RequiresRestartForConfigurationUpdate":
            return Optional.ofNullable(clazz.cast(requiresRestartForConfigurationUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LicenseRequirement", LICENSE_REQUIREMENT_FIELD);
        map.put("LicenseFilepath", LICENSE_FILEPATH_FIELD);
        map.put("ConfigurationRequirement", CONFIGURATION_REQUIREMENT_FIELD);
        map.put("RequiresRestartForConfigurationUpdate", REQUIRES_RESTART_FOR_CONFIGURATION_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageConfiguration, T> g) {
        return obj -> g.apply((PackageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageConfiguration> {
        /**
         * <p>
         * The license requirements for the package.
         * </p>
         * 
         * @param licenseRequirement
         *        The license requirements for the package.
         * @see RequirementLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequirementLevel
         */
        Builder licenseRequirement(String licenseRequirement);

        /**
         * <p>
         * The license requirements for the package.
         * </p>
         * 
         * @param licenseRequirement
         *        The license requirements for the package.
         * @see RequirementLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequirementLevel
         */
        Builder licenseRequirement(RequirementLevel licenseRequirement);

        /**
         * <p>
         * The relative file path for the license associated with the package.
         * </p>
         * 
         * @param licenseFilepath
         *        The relative file path for the license associated with the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseFilepath(String licenseFilepath);

        /**
         * <p>
         * The configuration requirements for the package.
         * </p>
         * 
         * @param configurationRequirement
         *        The configuration requirements for the package.
         * @see RequirementLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequirementLevel
         */
        Builder configurationRequirement(String configurationRequirement);

        /**
         * <p>
         * The configuration requirements for the package.
         * </p>
         * 
         * @param configurationRequirement
         *        The configuration requirements for the package.
         * @see RequirementLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequirementLevel
         */
        Builder configurationRequirement(RequirementLevel configurationRequirement);

        /**
         * <p>
         * This indicates whether a B/G deployment is required for updating the configuration that the plugin is
         * prerequisite for.
         * </p>
         * 
         * @param requiresRestartForConfigurationUpdate
         *        This indicates whether a B/G deployment is required for updating the configuration that the plugin is
         *        prerequisite for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requiresRestartForConfigurationUpdate(Boolean requiresRestartForConfigurationUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String licenseRequirement;

        private String licenseFilepath;

        private String configurationRequirement;

        private Boolean requiresRestartForConfigurationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageConfiguration model) {
            licenseRequirement(model.licenseRequirement);
            licenseFilepath(model.licenseFilepath);
            configurationRequirement(model.configurationRequirement);
            requiresRestartForConfigurationUpdate(model.requiresRestartForConfigurationUpdate);
        }

        public final String getLicenseRequirement() {
            return licenseRequirement;
        }

        public final void setLicenseRequirement(String licenseRequirement) {
            this.licenseRequirement = licenseRequirement;
        }

        @Override
        public final Builder licenseRequirement(String licenseRequirement) {
            this.licenseRequirement = licenseRequirement;
            return this;
        }

        @Override
        public final Builder licenseRequirement(RequirementLevel licenseRequirement) {
            this.licenseRequirement(licenseRequirement == null ? null : licenseRequirement.toString());
            return this;
        }

        public final String getLicenseFilepath() {
            return licenseFilepath;
        }

        public final void setLicenseFilepath(String licenseFilepath) {
            this.licenseFilepath = licenseFilepath;
        }

        @Override
        public final Builder licenseFilepath(String licenseFilepath) {
            this.licenseFilepath = licenseFilepath;
            return this;
        }

        public final String getConfigurationRequirement() {
            return configurationRequirement;
        }

        public final void setConfigurationRequirement(String configurationRequirement) {
            this.configurationRequirement = configurationRequirement;
        }

        @Override
        public final Builder configurationRequirement(String configurationRequirement) {
            this.configurationRequirement = configurationRequirement;
            return this;
        }

        @Override
        public final Builder configurationRequirement(RequirementLevel configurationRequirement) {
            this.configurationRequirement(configurationRequirement == null ? null : configurationRequirement.toString());
            return this;
        }

        public final Boolean getRequiresRestartForConfigurationUpdate() {
            return requiresRestartForConfigurationUpdate;
        }

        public final void setRequiresRestartForConfigurationUpdate(Boolean requiresRestartForConfigurationUpdate) {
            this.requiresRestartForConfigurationUpdate = requiresRestartForConfigurationUpdate;
        }

        @Override
        public final Builder requiresRestartForConfigurationUpdate(Boolean requiresRestartForConfigurationUpdate) {
            this.requiresRestartForConfigurationUpdate = requiresRestartForConfigurationUpdate;
            return this;
        }

        @Override
        public PackageConfiguration build() {
            return new PackageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
