/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Encryption options for a package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageEncryptionOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageEncryptionOptions.Builder, PackageEncryptionOptions> {
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyIdentifier").getter(getter(PackageEncryptionOptions::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()).build();

    private static final SdkField<Boolean> ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EncryptionEnabled").getter(getter(PackageEncryptionOptions::encryptionEnabled))
            .setter(setter(Builder::encryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_IDENTIFIER_FIELD,
            ENCRYPTION_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String kmsKeyIdentifier;

    private final Boolean encryptionEnabled;

    private PackageEncryptionOptions(BuilderImpl builder) {
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.encryptionEnabled = builder.encryptionEnabled;
    }

    /**
     * <p>
     * KMS key ID for encrypting the package.
     * </p>
     * 
     * @return KMS key ID for encrypting the package.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    /**
     * <p>
     * This indicates whether encryption is enabled for the package.
     * </p>
     * 
     * @return This indicates whether encryption is enabled for the package.
     */
    public final Boolean encryptionEnabled() {
        return encryptionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageEncryptionOptions)) {
            return false;
        }
        PackageEncryptionOptions other = (PackageEncryptionOptions) obj;
        return Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier())
                && Objects.equals(encryptionEnabled(), other.encryptionEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageEncryptionOptions").add("KmsKeyIdentifier", kmsKeyIdentifier())
                .add("EncryptionEnabled", encryptionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        case "EncryptionEnabled":
            return Optional.ofNullable(clazz.cast(encryptionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("EncryptionEnabled", ENCRYPTION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageEncryptionOptions, T> g) {
        return obj -> g.apply((PackageEncryptionOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageEncryptionOptions> {
        /**
         * <p>
         * KMS key ID for encrypting the package.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        KMS key ID for encrypting the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        /**
         * <p>
         * This indicates whether encryption is enabled for the package.
         * </p>
         * 
         * @param encryptionEnabled
         *        This indicates whether encryption is enabled for the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionEnabled(Boolean encryptionEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String kmsKeyIdentifier;

        private Boolean encryptionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageEncryptionOptions model) {
            kmsKeyIdentifier(model.kmsKeyIdentifier);
            encryptionEnabled(model.encryptionEnabled);
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final Boolean getEncryptionEnabled() {
            return encryptionEnabled;
        }

        public final void setEncryptionEnabled(Boolean encryptionEnabled) {
            this.encryptionEnabled = encryptionEnabled;
        }

        @Override
        public final Builder encryptionEnabled(Boolean encryptionEnabled) {
            this.encryptionEnabled = encryptionEnabled;
            return this;
        }

        @Override
        public PackageEncryptionOptions build() {
            return new PackageEncryptionOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
