/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. It's only used if
 * there is no state persisted for that log stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum CloudWatchLogsInitialPosition {
    START_OF_FILE("start_of_file"),

    END_OF_FILE("end_of_file"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CloudWatchLogsInitialPosition> VALUE_MAP = EnumUtils.uniqueIndex(
            CloudWatchLogsInitialPosition.class, CloudWatchLogsInitialPosition::toString);

    private final String value;

    private CloudWatchLogsInitialPosition(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CloudWatchLogsInitialPosition corresponding to the value
     */
    public static CloudWatchLogsInitialPosition fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CloudWatchLogsInitialPosition}s
     */
    public static Set<CloudWatchLogsInitialPosition> knownValues() {
        Set<CloudWatchLogsInitialPosition> knownValues = EnumSet.allOf(CloudWatchLogsInitialPosition.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
