/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeMyUserProfile</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMyUserProfileResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeMyUserProfileResponse.Builder, DescribeMyUserProfileResponse> {
    private static final SdkField<SelfUserProfile> USER_PROFILE_FIELD = SdkField
            .<SelfUserProfile> builder(MarshallingType.SDK_POJO).memberName("UserProfile")
            .getter(getter(DescribeMyUserProfileResponse::userProfile)).setter(setter(Builder::userProfile))
            .constructor(SelfUserProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_PROFILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SelfUserProfile userProfile;

    private DescribeMyUserProfileResponse(BuilderImpl builder) {
        super(builder);
        this.userProfile = builder.userProfile;
    }

    /**
     * <p>
     * A <code>UserProfile</code> object that describes the user's SSH information.
     * </p>
     * 
     * @return A <code>UserProfile</code> object that describes the user's SSH information.
     */
    public final SelfUserProfile userProfile() {
        return userProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userProfile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMyUserProfileResponse)) {
            return false;
        }
        DescribeMyUserProfileResponse other = (DescribeMyUserProfileResponse) obj;
        return Objects.equals(userProfile(), other.userProfile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMyUserProfileResponse").add("UserProfile", userProfile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserProfile":
            return Optional.ofNullable(clazz.cast(userProfile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserProfile", USER_PROFILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMyUserProfileResponse, T> g) {
        return obj -> g.apply((DescribeMyUserProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMyUserProfileResponse> {
        /**
         * <p>
         * A <code>UserProfile</code> object that describes the user's SSH information.
         * </p>
         * 
         * @param userProfile
         *        A <code>UserProfile</code> object that describes the user's SSH information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfile(SelfUserProfile userProfile);

        /**
         * <p>
         * A <code>UserProfile</code> object that describes the user's SSH information.
         * </p>
         * This is a convenience method that creates an instance of the {@link SelfUserProfile.Builder} avoiding the
         * need to create one manually via {@link SelfUserProfile#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelfUserProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #userProfile(SelfUserProfile)}.
         * 
         * @param userProfile
         *        a consumer that will call methods on {@link SelfUserProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userProfile(SelfUserProfile)
         */
        default Builder userProfile(Consumer<SelfUserProfile.Builder> userProfile) {
            return userProfile(SelfUserProfile.builder().applyMutation(userProfile).build());
        }
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private SelfUserProfile userProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMyUserProfileResponse model) {
            super(model);
            userProfile(model.userProfile);
        }

        public final SelfUserProfile.Builder getUserProfile() {
            return userProfile != null ? userProfile.toBuilder() : null;
        }

        public final void setUserProfile(SelfUserProfile.BuilderImpl userProfile) {
            this.userProfile = userProfile != null ? userProfile.build() : null;
        }

        @Override
        public final Builder userProfile(SelfUserProfile userProfile) {
            this.userProfile = userProfile;
            return this;
        }

        @Override
        public DescribeMyUserProfileResponse build() {
            return new DescribeMyUserProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
