/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStacksRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeStacksRequest.Builder, DescribeStacksRequest> {
    private static final SdkField<List<String>> STACK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StackIds")
            .getter(getter(DescribeStacksRequest::stackIds))
            .setter(setter(Builder::stackIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> stackIds;

    private DescribeStacksRequest(BuilderImpl builder) {
        super(builder);
        this.stackIds = builder.stackIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the StackIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStackIds() {
        return stackIds != null && !(stackIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of stack IDs that specify the stacks to be described. If you omit this parameter, and have permissions
     * to get information about all stacks, <code>DescribeStacks</code> returns a description of every stack. If the IAM
     * policy that is attached to an IAM user limits the <code>DescribeStacks</code> action to specific stack ARNs, this
     * parameter is required, and the user must specify a stack ARN that is allowed by the policy. Otherwise,
     * <code>DescribeStacks</code> returns an <code>AccessDenied</code> error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStackIds} method.
     * </p>
     * 
     * @return An array of stack IDs that specify the stacks to be described. If you omit this parameter, and have
     *         permissions to get information about all stacks, <code>DescribeStacks</code> returns a description of
     *         every stack. If the IAM policy that is attached to an IAM user limits the <code>DescribeStacks</code>
     *         action to specific stack ARNs, this parameter is required, and the user must specify a stack ARN that is
     *         allowed by the policy. Otherwise, <code>DescribeStacks</code> returns an <code>AccessDenied</code> error.
     */
    public final List<String> stackIds() {
        return stackIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStackIds() ? stackIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStacksRequest)) {
            return false;
        }
        DescribeStacksRequest other = (DescribeStacksRequest) obj;
        return hasStackIds() == other.hasStackIds() && Objects.equals(stackIds(), other.stackIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStacksRequest").add("StackIds", hasStackIds() ? stackIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackIds":
            return Optional.ofNullable(clazz.cast(stackIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackIds", STACK_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStacksRequest, T> g) {
        return obj -> g.apply((DescribeStacksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStacksRequest> {
        /**
         * <p>
         * An array of stack IDs that specify the stacks to be described. If you omit this parameter, and have
         * permissions to get information about all stacks, <code>DescribeStacks</code> returns a description of every
         * stack. If the IAM policy that is attached to an IAM user limits the <code>DescribeStacks</code> action to
         * specific stack ARNs, this parameter is required, and the user must specify a stack ARN that is allowed by the
         * policy. Otherwise, <code>DescribeStacks</code> returns an <code>AccessDenied</code> error.
         * </p>
         * 
         * @param stackIds
         *        An array of stack IDs that specify the stacks to be described. If you omit this parameter, and have
         *        permissions to get information about all stacks, <code>DescribeStacks</code> returns a description of
         *        every stack. If the IAM policy that is attached to an IAM user limits the <code>DescribeStacks</code>
         *        action to specific stack ARNs, this parameter is required, and the user must specify a stack ARN that
         *        is allowed by the policy. Otherwise, <code>DescribeStacks</code> returns an <code>AccessDenied</code>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackIds(Collection<String> stackIds);

        /**
         * <p>
         * An array of stack IDs that specify the stacks to be described. If you omit this parameter, and have
         * permissions to get information about all stacks, <code>DescribeStacks</code> returns a description of every
         * stack. If the IAM policy that is attached to an IAM user limits the <code>DescribeStacks</code> action to
         * specific stack ARNs, this parameter is required, and the user must specify a stack ARN that is allowed by the
         * policy. Otherwise, <code>DescribeStacks</code> returns an <code>AccessDenied</code> error.
         * </p>
         * 
         * @param stackIds
         *        An array of stack IDs that specify the stacks to be described. If you omit this parameter, and have
         *        permissions to get information about all stacks, <code>DescribeStacks</code> returns a description of
         *        every stack. If the IAM policy that is attached to an IAM user limits the <code>DescribeStacks</code>
         *        action to specific stack ARNs, this parameter is required, and the user must specify a stack ARN that
         *        is allowed by the policy. Otherwise, <code>DescribeStacks</code> returns an <code>AccessDenied</code>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackIds(String... stackIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private List<String> stackIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStacksRequest model) {
            super(model);
            stackIds(model.stackIds);
        }

        public final Collection<String> getStackIds() {
            if (stackIds instanceof SdkAutoConstructList) {
                return null;
            }
            return stackIds;
        }

        public final void setStackIds(Collection<String> stackIds) {
            this.stackIds = StringsCopier.copy(stackIds);
        }

        @Override
        public final Builder stackIds(Collection<String> stackIds) {
            this.stackIds = StringsCopier.copy(stackIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackIds(String... stackIds) {
            stackIds(Arrays.asList(stackIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStacksRequest build() {
            return new DescribeStacksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
