/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.CatalogItemClass;
import software.amazon.awssdk.services.outposts.model.CatalogItemClassListCopier;
import software.amazon.awssdk.services.outposts.model.EC2FamilyListCopier;
import software.amazon.awssdk.services.outposts.model.OutpostsRequest;
import software.amazon.awssdk.services.outposts.model.SupportedStorageEnum;
import software.amazon.awssdk.services.outposts.model.SupportedStorageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCatalogItemsRequest
extends OutpostsRequest
implements ToCopyableBuilder<Builder, ListCatalogItemsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCatalogItemsRequest.getter(ListCatalogItemsRequest::nextToken)).setter(ListCatalogItemsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListCatalogItemsRequest.getter(ListCatalogItemsRequest::maxResults)).setter(ListCatalogItemsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<List<String>> ITEM_CLASS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ItemClassFilter").getter(ListCatalogItemsRequest.getter(ListCatalogItemsRequest::itemClassFilterAsStrings)).setter(ListCatalogItemsRequest.setter(Builder::itemClassFilterWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ItemClassFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_STORAGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedStorageFilter").getter(ListCatalogItemsRequest.getter(ListCatalogItemsRequest::supportedStorageFilterAsStrings)).setter(ListCatalogItemsRequest.setter(Builder::supportedStorageFilterWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SupportedStorageFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EC2_FAMILY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EC2FamilyFilter").getter(ListCatalogItemsRequest.getter(ListCatalogItemsRequest::ec2FamilyFilter)).setter(ListCatalogItemsRequest.setter(Builder::ec2FamilyFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EC2FamilyFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, ITEM_CLASS_FILTER_FIELD, SUPPORTED_STORAGE_FILTER_FIELD, EC2_FAMILY_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("ItemClassFilter", ITEM_CLASS_FILTER_FIELD);
            this.put("SupportedStorageFilter", SUPPORTED_STORAGE_FILTER_FIELD);
            this.put("EC2FamilyFilter", EC2_FAMILY_FILTER_FIELD);
        }
    });
    private final String nextToken;
    private final Integer maxResults;
    private final List<String> itemClassFilter;
    private final List<String> supportedStorageFilter;
    private final List<String> ec2FamilyFilter;

    private ListCatalogItemsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.itemClassFilter = builder.itemClassFilter;
        this.supportedStorageFilter = builder.supportedStorageFilter;
        this.ec2FamilyFilter = builder.ec2FamilyFilter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final List<CatalogItemClass> itemClassFilter() {
        return CatalogItemClassListCopier.copyStringToEnum(this.itemClassFilter);
    }

    public final boolean hasItemClassFilter() {
        return this.itemClassFilter != null && !(this.itemClassFilter instanceof SdkAutoConstructList);
    }

    public final List<String> itemClassFilterAsStrings() {
        return this.itemClassFilter;
    }

    public final List<SupportedStorageEnum> supportedStorageFilter() {
        return SupportedStorageListCopier.copyStringToEnum(this.supportedStorageFilter);
    }

    public final boolean hasSupportedStorageFilter() {
        return this.supportedStorageFilter != null && !(this.supportedStorageFilter instanceof SdkAutoConstructList);
    }

    public final List<String> supportedStorageFilterAsStrings() {
        return this.supportedStorageFilter;
    }

    public final boolean hasEc2FamilyFilter() {
        return this.ec2FamilyFilter != null && !(this.ec2FamilyFilter instanceof SdkAutoConstructList);
    }

    public final List<String> ec2FamilyFilter() {
        return this.ec2FamilyFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItemClassFilter() ? this.itemClassFilterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedStorageFilter() ? this.supportedStorageFilterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2FamilyFilter() ? this.ec2FamilyFilter() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCatalogItemsRequest)) {
            return false;
        }
        ListCatalogItemsRequest other = (ListCatalogItemsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasItemClassFilter() == other.hasItemClassFilter() && Objects.equals(this.itemClassFilterAsStrings(), other.itemClassFilterAsStrings()) && this.hasSupportedStorageFilter() == other.hasSupportedStorageFilter() && Objects.equals(this.supportedStorageFilterAsStrings(), other.supportedStorageFilterAsStrings()) && this.hasEc2FamilyFilter() == other.hasEc2FamilyFilter() && Objects.equals(this.ec2FamilyFilter(), other.ec2FamilyFilter());
    }

    public final String toString() {
        return ToString.builder((String)"ListCatalogItemsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ItemClassFilter", this.hasItemClassFilter() ? this.itemClassFilterAsStrings() : null).add("SupportedStorageFilter", this.hasSupportedStorageFilter() ? this.supportedStorageFilterAsStrings() : null).add("EC2FamilyFilter", this.hasEc2FamilyFilter() ? this.ec2FamilyFilter() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ItemClassFilter": {
                return Optional.ofNullable(clazz.cast(this.itemClassFilterAsStrings()));
            }
            case "SupportedStorageFilter": {
                return Optional.ofNullable(clazz.cast(this.supportedStorageFilterAsStrings()));
            }
            case "EC2FamilyFilter": {
                return Optional.ofNullable(clazz.cast(this.ec2FamilyFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCatalogItemsRequest, T> g) {
        return obj -> g.apply((ListCatalogItemsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private List<String> itemClassFilter = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedStorageFilter = DefaultSdkAutoConstructList.getInstance();
        private List<String> ec2FamilyFilter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCatalogItemsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.itemClassFilterWithStrings(model.itemClassFilter);
            this.supportedStorageFilterWithStrings(model.supportedStorageFilter);
            this.ec2FamilyFilter(model.ec2FamilyFilter);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getItemClassFilter() {
            if (this.itemClassFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.itemClassFilter;
        }

        public final void setItemClassFilter(Collection<String> itemClassFilter) {
            this.itemClassFilter = CatalogItemClassListCopier.copy(itemClassFilter);
        }

        @Override
        public final Builder itemClassFilterWithStrings(Collection<String> itemClassFilter) {
            this.itemClassFilter = CatalogItemClassListCopier.copy(itemClassFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemClassFilterWithStrings(String ... itemClassFilter) {
            this.itemClassFilterWithStrings(Arrays.asList(itemClassFilter));
            return this;
        }

        @Override
        public final Builder itemClassFilter(Collection<CatalogItemClass> itemClassFilter) {
            this.itemClassFilter = CatalogItemClassListCopier.copyEnumToString(itemClassFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemClassFilter(CatalogItemClass ... itemClassFilter) {
            this.itemClassFilter(Arrays.asList(itemClassFilter));
            return this;
        }

        public final Collection<String> getSupportedStorageFilter() {
            if (this.supportedStorageFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedStorageFilter;
        }

        public final void setSupportedStorageFilter(Collection<String> supportedStorageFilter) {
            this.supportedStorageFilter = SupportedStorageListCopier.copy(supportedStorageFilter);
        }

        @Override
        public final Builder supportedStorageFilterWithStrings(Collection<String> supportedStorageFilter) {
            this.supportedStorageFilter = SupportedStorageListCopier.copy(supportedStorageFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedStorageFilterWithStrings(String ... supportedStorageFilter) {
            this.supportedStorageFilterWithStrings(Arrays.asList(supportedStorageFilter));
            return this;
        }

        @Override
        public final Builder supportedStorageFilter(Collection<SupportedStorageEnum> supportedStorageFilter) {
            this.supportedStorageFilter = SupportedStorageListCopier.copyEnumToString(supportedStorageFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedStorageFilter(SupportedStorageEnum ... supportedStorageFilter) {
            this.supportedStorageFilter(Arrays.asList(supportedStorageFilter));
            return this;
        }

        public final Collection<String> getEc2FamilyFilter() {
            if (this.ec2FamilyFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ec2FamilyFilter;
        }

        public final void setEc2FamilyFilter(Collection<String> ec2FamilyFilter) {
            this.ec2FamilyFilter = EC2FamilyListCopier.copy(ec2FamilyFilter);
        }

        @Override
        public final Builder ec2FamilyFilter(Collection<String> ec2FamilyFilter) {
            this.ec2FamilyFilter = EC2FamilyListCopier.copy(ec2FamilyFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2FamilyFilter(String ... ec2FamilyFilter) {
            this.ec2FamilyFilter(Arrays.asList(ec2FamilyFilter));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCatalogItemsRequest build() {
            return new ListCatalogItemsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OutpostsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCatalogItemsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder itemClassFilterWithStrings(Collection<String> var1);

        public Builder itemClassFilterWithStrings(String ... var1);

        public Builder itemClassFilter(Collection<CatalogItemClass> var1);

        public Builder itemClassFilter(CatalogItemClass ... var1);

        public Builder supportedStorageFilterWithStrings(Collection<String> var1);

        public Builder supportedStorageFilterWithStrings(String ... var1);

        public Builder supportedStorageFilter(Collection<SupportedStorageEnum> var1);

        public Builder supportedStorageFilter(SupportedStorageEnum ... var1);

        public Builder ec2FamilyFilter(Collection<String> var1);

        public Builder ec2FamilyFilter(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

