/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.outposts.OutpostsAsyncClient;
import software.amazon.awssdk.services.outposts.internal.UserAgentUtils;
import software.amazon.awssdk.services.outposts.model.ListOrdersRequest;
import software.amazon.awssdk.services.outposts.model.ListOrdersResponse;
import software.amazon.awssdk.services.outposts.model.OrderSummary;

public class ListOrdersPublisher
implements SdkPublisher<ListOrdersResponse> {
    private final OutpostsAsyncClient client;
    private final ListOrdersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOrdersPublisher(OutpostsAsyncClient client, ListOrdersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOrdersPublisher(OutpostsAsyncClient client, ListOrdersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOrdersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOrdersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OrderSummary> orders() {
        Function<ListOrdersResponse, Iterator> getIterator = response -> {
            if (response != null && response.orders() != null) {
                return response.orders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOrdersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOrdersResponseFetcher
    implements AsyncPageFetcher<ListOrdersResponse> {
        private ListOrdersResponseFetcher() {
        }

        public boolean hasNextPage(ListOrdersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOrdersResponse> nextPage(ListOrdersResponse previousPage) {
            if (previousPage == null) {
                return ListOrdersPublisher.this.client.listOrders(ListOrdersPublisher.this.firstRequest);
            }
            return ListOrdersPublisher.this.client.listOrders((ListOrdersRequest)((Object)ListOrdersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

