/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.outposts.model.AccessDeniedException;
import software.amazon.awssdk.services.outposts.model.CancelCapacityTaskRequest;
import software.amazon.awssdk.services.outposts.model.CancelCapacityTaskResponse;
import software.amazon.awssdk.services.outposts.model.CancelOrderRequest;
import software.amazon.awssdk.services.outposts.model.CancelOrderResponse;
import software.amazon.awssdk.services.outposts.model.ConflictException;
import software.amazon.awssdk.services.outposts.model.CreateOrderRequest;
import software.amazon.awssdk.services.outposts.model.CreateOrderResponse;
import software.amazon.awssdk.services.outposts.model.CreateOutpostRequest;
import software.amazon.awssdk.services.outposts.model.CreateOutpostResponse;
import software.amazon.awssdk.services.outposts.model.CreateSiteRequest;
import software.amazon.awssdk.services.outposts.model.CreateSiteResponse;
import software.amazon.awssdk.services.outposts.model.DeleteOutpostRequest;
import software.amazon.awssdk.services.outposts.model.DeleteOutpostResponse;
import software.amazon.awssdk.services.outposts.model.DeleteSiteRequest;
import software.amazon.awssdk.services.outposts.model.DeleteSiteResponse;
import software.amazon.awssdk.services.outposts.model.GetCapacityTaskRequest;
import software.amazon.awssdk.services.outposts.model.GetCapacityTaskResponse;
import software.amazon.awssdk.services.outposts.model.GetCatalogItemRequest;
import software.amazon.awssdk.services.outposts.model.GetCatalogItemResponse;
import software.amazon.awssdk.services.outposts.model.GetConnectionRequest;
import software.amazon.awssdk.services.outposts.model.GetConnectionResponse;
import software.amazon.awssdk.services.outposts.model.GetOrderRequest;
import software.amazon.awssdk.services.outposts.model.GetOrderResponse;
import software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest;
import software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesResponse;
import software.amazon.awssdk.services.outposts.model.GetOutpostRequest;
import software.amazon.awssdk.services.outposts.model.GetOutpostResponse;
import software.amazon.awssdk.services.outposts.model.GetOutpostSupportedInstanceTypesRequest;
import software.amazon.awssdk.services.outposts.model.GetOutpostSupportedInstanceTypesResponse;
import software.amazon.awssdk.services.outposts.model.GetSiteAddressRequest;
import software.amazon.awssdk.services.outposts.model.GetSiteAddressResponse;
import software.amazon.awssdk.services.outposts.model.GetSiteRequest;
import software.amazon.awssdk.services.outposts.model.GetSiteResponse;
import software.amazon.awssdk.services.outposts.model.InternalServerException;
import software.amazon.awssdk.services.outposts.model.ListAssetInstancesRequest;
import software.amazon.awssdk.services.outposts.model.ListAssetInstancesResponse;
import software.amazon.awssdk.services.outposts.model.ListAssetsRequest;
import software.amazon.awssdk.services.outposts.model.ListAssetsResponse;
import software.amazon.awssdk.services.outposts.model.ListBlockingInstancesForCapacityTaskRequest;
import software.amazon.awssdk.services.outposts.model.ListBlockingInstancesForCapacityTaskResponse;
import software.amazon.awssdk.services.outposts.model.ListCapacityTasksRequest;
import software.amazon.awssdk.services.outposts.model.ListCapacityTasksResponse;
import software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest;
import software.amazon.awssdk.services.outposts.model.ListCatalogItemsResponse;
import software.amazon.awssdk.services.outposts.model.ListOrdersRequest;
import software.amazon.awssdk.services.outposts.model.ListOrdersResponse;
import software.amazon.awssdk.services.outposts.model.ListOutpostsRequest;
import software.amazon.awssdk.services.outposts.model.ListOutpostsResponse;
import software.amazon.awssdk.services.outposts.model.ListSitesRequest;
import software.amazon.awssdk.services.outposts.model.ListSitesResponse;
import software.amazon.awssdk.services.outposts.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.outposts.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.outposts.model.NotFoundException;
import software.amazon.awssdk.services.outposts.model.OutpostsException;
import software.amazon.awssdk.services.outposts.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.outposts.model.StartCapacityTaskRequest;
import software.amazon.awssdk.services.outposts.model.StartCapacityTaskResponse;
import software.amazon.awssdk.services.outposts.model.StartConnectionRequest;
import software.amazon.awssdk.services.outposts.model.StartConnectionResponse;
import software.amazon.awssdk.services.outposts.model.TagResourceRequest;
import software.amazon.awssdk.services.outposts.model.TagResourceResponse;
import software.amazon.awssdk.services.outposts.model.UntagResourceRequest;
import software.amazon.awssdk.services.outposts.model.UntagResourceResponse;
import software.amazon.awssdk.services.outposts.model.UpdateOutpostRequest;
import software.amazon.awssdk.services.outposts.model.UpdateOutpostResponse;
import software.amazon.awssdk.services.outposts.model.UpdateSiteAddressRequest;
import software.amazon.awssdk.services.outposts.model.UpdateSiteAddressResponse;
import software.amazon.awssdk.services.outposts.model.UpdateSiteRackPhysicalPropertiesRequest;
import software.amazon.awssdk.services.outposts.model.UpdateSiteRackPhysicalPropertiesResponse;
import software.amazon.awssdk.services.outposts.model.UpdateSiteRequest;
import software.amazon.awssdk.services.outposts.model.UpdateSiteResponse;
import software.amazon.awssdk.services.outposts.model.ValidationException;
import software.amazon.awssdk.services.outposts.paginators.GetOutpostInstanceTypesIterable;
import software.amazon.awssdk.services.outposts.paginators.GetOutpostSupportedInstanceTypesIterable;
import software.amazon.awssdk.services.outposts.paginators.ListAssetInstancesIterable;
import software.amazon.awssdk.services.outposts.paginators.ListAssetsIterable;
import software.amazon.awssdk.services.outposts.paginators.ListBlockingInstancesForCapacityTaskIterable;
import software.amazon.awssdk.services.outposts.paginators.ListCapacityTasksIterable;
import software.amazon.awssdk.services.outposts.paginators.ListCatalogItemsIterable;
import software.amazon.awssdk.services.outposts.paginators.ListOrdersIterable;
import software.amazon.awssdk.services.outposts.paginators.ListOutpostsIterable;
import software.amazon.awssdk.services.outposts.paginators.ListSitesIterable;

/**
 * Service client for accessing Outposts. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services Outposts is a fully managed service that extends Amazon Web Services infrastructure, APIs, and
 * tools to customer premises. By providing local access to Amazon Web Services managed infrastructure, Amazon Web
 * Services Outposts enables customers to build and run applications on premises using the same programming interfaces
 * as in Amazon Web Services Regions, while using local compute and storage resources for lower latency and local data
 * processing needs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface OutpostsClient extends AwsClient {
    String SERVICE_NAME = "outposts";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "outposts";

    /**
     * <p>
     * Cancels the capacity task.
     * </p>
     *
     * @param cancelCapacityTaskRequest
     * @return Result of the CancelCapacityTask operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.CancelCapacityTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CancelCapacityTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelCapacityTaskResponse cancelCapacityTask(CancelCapacityTaskRequest cancelCapacityTaskRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the capacity task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelCapacityTaskRequest.Builder} avoiding the
     * need to create one manually via {@link CancelCapacityTaskRequest#builder()}
     * </p>
     *
     * @param cancelCapacityTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.CancelCapacityTaskRequest.Builder} to create a
     *        request.
     * @return Result of the CancelCapacityTask operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.CancelCapacityTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CancelCapacityTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelCapacityTaskResponse cancelCapacityTask(Consumer<CancelCapacityTaskRequest.Builder> cancelCapacityTaskRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, OutpostsException {
        return cancelCapacityTask(CancelCapacityTaskRequest.builder().applyMutation(cancelCapacityTaskRequest).build());
    }

    /**
     * <p>
     * Cancels the specified order for an Outpost.
     * </p>
     *
     * @param cancelOrderRequest
     * @return Result of the CancelOrder operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.CancelOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CancelOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelOrderResponse cancelOrder(CancelOrderRequest cancelOrderRequest) throws ValidationException, ConflictException,
            AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified order for an Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelOrderRequest.Builder} avoiding the need to
     * create one manually via {@link CancelOrderRequest#builder()}
     * </p>
     *
     * @param cancelOrderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.CancelOrderRequest.Builder} to create a request.
     * @return Result of the CancelOrder operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.CancelOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CancelOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelOrderResponse cancelOrder(Consumer<CancelOrderRequest.Builder> cancelOrderRequest) throws ValidationException,
            ConflictException, AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return cancelOrder(CancelOrderRequest.builder().applyMutation(cancelOrderRequest).build());
    }

    /**
     * <p>
     * Creates an order for an Outpost.
     * </p>
     *
     * @param createOrderRequest
     * @return Result of the CreateOrder operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ServiceQuotaExceededException
     *         You have exceeded a service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.CreateOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateOrderResponse createOrder(CreateOrderRequest createOrderRequest) throws ValidationException, ConflictException,
            AccessDeniedException, NotFoundException, InternalServerException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an order for an Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOrderRequest.Builder} avoiding the need to
     * create one manually via {@link CreateOrderRequest#builder()}
     * </p>
     *
     * @param createOrderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.CreateOrderRequest.Builder} to create a request.
     * @return Result of the CreateOrder operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ServiceQuotaExceededException
     *         You have exceeded a service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.CreateOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateOrderResponse createOrder(Consumer<CreateOrderRequest.Builder> createOrderRequest) throws ValidationException,
            ConflictException, AccessDeniedException, NotFoundException, InternalServerException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, OutpostsException {
        return createOrder(CreateOrderRequest.builder().applyMutation(createOrderRequest).build());
    }

    /**
     * <p>
     * Creates an Outpost.
     * </p>
     * <p>
     * You can specify either an Availability one or an AZ ID.
     * </p>
     *
     * @param createOutpostRequest
     * @return Result of the CreateOutpost operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ServiceQuotaExceededException
     *         You have exceeded a service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.CreateOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateOutpostResponse createOutpost(CreateOutpostRequest createOutpostRequest) throws ValidationException,
            ConflictException, NotFoundException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Outpost.
     * </p>
     * <p>
     * You can specify either an Availability one or an AZ ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOutpostRequest.Builder} avoiding the need to
     * create one manually via {@link CreateOutpostRequest#builder()}
     * </p>
     *
     * @param createOutpostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.CreateOutpostRequest.Builder} to create a request.
     * @return Result of the CreateOutpost operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ServiceQuotaExceededException
     *         You have exceeded a service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.CreateOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateOutpostResponse createOutpost(Consumer<CreateOutpostRequest.Builder> createOutpostRequest)
            throws ValidationException, ConflictException, NotFoundException, AccessDeniedException, InternalServerException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, OutpostsException {
        return createOutpost(CreateOutpostRequest.builder().applyMutation(createOutpostRequest).build());
    }

    /**
     * <p>
     * Creates a site for an Outpost.
     * </p>
     *
     * @param createSiteRequest
     * @return Result of the CreateSite operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ServiceQuotaExceededException
     *         You have exceeded a service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.CreateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSiteResponse createSite(CreateSiteRequest createSiteRequest) throws ValidationException, ConflictException,
            AccessDeniedException, InternalServerException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a site for an Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSiteRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSiteRequest#builder()}
     * </p>
     *
     * @param createSiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.CreateSiteRequest.Builder} to create a request.
     * @return Result of the CreateSite operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ServiceQuotaExceededException
     *         You have exceeded a service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.CreateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSiteResponse createSite(Consumer<CreateSiteRequest.Builder> createSiteRequest) throws ValidationException,
            ConflictException, AccessDeniedException, InternalServerException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, OutpostsException {
        return createSite(CreateSiteRequest.builder().applyMutation(createSiteRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Outpost.
     * </p>
     *
     * @param deleteOutpostRequest
     * @return Result of the DeleteOutpost operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.DeleteOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/DeleteOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteOutpostResponse deleteOutpost(DeleteOutpostRequest deleteOutpostRequest) throws ValidationException,
            ConflictException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOutpostRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteOutpostRequest#builder()}
     * </p>
     *
     * @param deleteOutpostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.DeleteOutpostRequest.Builder} to create a request.
     * @return Result of the DeleteOutpost operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.DeleteOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/DeleteOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteOutpostResponse deleteOutpost(Consumer<DeleteOutpostRequest.Builder> deleteOutpostRequest)
            throws ValidationException, ConflictException, NotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, OutpostsException {
        return deleteOutpost(DeleteOutpostRequest.builder().applyMutation(deleteOutpostRequest).build());
    }

    /**
     * <p>
     * Deletes the specified site.
     * </p>
     *
     * @param deleteSiteRequest
     * @return Result of the DeleteSite operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.DeleteSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/DeleteSite" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSiteResponse deleteSite(DeleteSiteRequest deleteSiteRequest) throws ValidationException, ConflictException,
            NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSiteRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSiteRequest#builder()}
     * </p>
     *
     * @param deleteSiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.DeleteSiteRequest.Builder} to create a request.
     * @return Result of the DeleteSite operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.DeleteSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/DeleteSite" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSiteResponse deleteSite(Consumer<DeleteSiteRequest.Builder> deleteSiteRequest) throws ValidationException,
            ConflictException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return deleteSite(DeleteSiteRequest.builder().applyMutation(deleteSiteRequest).build());
    }

    /**
     * <p>
     * Gets details of the specified capacity task.
     * </p>
     *
     * @param getCapacityTaskRequest
     * @return Result of the GetCapacityTask operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetCapacityTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetCapacityTask" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCapacityTaskResponse getCapacityTask(GetCapacityTaskRequest getCapacityTaskRequest) throws ValidationException,
            AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details of the specified capacity task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCapacityTaskRequest.Builder} avoiding the need
     * to create one manually via {@link GetCapacityTaskRequest#builder()}
     * </p>
     *
     * @param getCapacityTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetCapacityTaskRequest.Builder} to create a request.
     * @return Result of the GetCapacityTask operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetCapacityTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetCapacityTask" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCapacityTaskResponse getCapacityTask(Consumer<GetCapacityTaskRequest.Builder> getCapacityTaskRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return getCapacityTask(GetCapacityTaskRequest.builder().applyMutation(getCapacityTaskRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified catalog item.
     * </p>
     *
     * @param getCatalogItemRequest
     * @return Result of the GetCatalogItem operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetCatalogItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetCatalogItem" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCatalogItemResponse getCatalogItem(GetCatalogItemRequest getCatalogItemRequest) throws ValidationException,
            NotFoundException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified catalog item.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCatalogItemRequest.Builder} avoiding the need to
     * create one manually via {@link GetCatalogItemRequest#builder()}
     * </p>
     *
     * @param getCatalogItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetCatalogItemRequest.Builder} to create a request.
     * @return Result of the GetCatalogItem operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetCatalogItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetCatalogItem" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCatalogItemResponse getCatalogItem(Consumer<GetCatalogItemRequest.Builder> getCatalogItemRequest)
            throws ValidationException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return getCatalogItem(GetCatalogItemRequest.builder().applyMutation(getCatalogItemRequest).build());
    }

    /**
     * <note>
     * <p>
     * Amazon Web Services uses this action to install Outpost servers.
     * </p>
     * </note>
     * <p>
     * Gets information about the specified connection.
     * </p>
     * <p>
     * Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to
     * secure it. For more information, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html"> Amazon Web Services
     * managed policies for Amazon Web Services Outposts</a> and <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html"> Logging Amazon Web
     * Services Outposts API calls with Amazon Web Services CloudTrail</a> in the <i>Amazon Web Services Outposts User
     * Guide</i>.
     * </p>
     *
     * @param getConnectionRequest
     * @return Result of the GetConnection operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectionResponse getConnection(GetConnectionRequest getConnectionRequest) throws AccessDeniedException,
            ValidationException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * Amazon Web Services uses this action to install Outpost servers.
     * </p>
     * </note>
     * <p>
     * Gets information about the specified connection.
     * </p>
     * <p>
     * Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to
     * secure it. For more information, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html"> Amazon Web Services
     * managed policies for Amazon Web Services Outposts</a> and <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html"> Logging Amazon Web
     * Services Outposts API calls with Amazon Web Services CloudTrail</a> in the <i>Amazon Web Services Outposts User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionRequest.Builder} avoiding the need to
     * create one manually via {@link GetConnectionRequest#builder()}
     * </p>
     *
     * @param getConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetConnectionRequest.Builder} to create a request.
     * @return Result of the GetConnection operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectionResponse getConnection(Consumer<GetConnectionRequest.Builder> getConnectionRequest)
            throws AccessDeniedException, ValidationException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return getConnection(GetConnectionRequest.builder().applyMutation(getConnectionRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified order.
     * </p>
     *
     * @param getOrderRequest
     * @return Result of the GetOrder operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOrderResponse getOrder(GetOrderRequest getOrderRequest) throws ValidationException, NotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified order.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOrderRequest.Builder} avoiding the need to
     * create one manually via {@link GetOrderRequest#builder()}
     * </p>
     *
     * @param getOrderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetOrderRequest.Builder} to create a request.
     * @return Result of the GetOrder operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetOrder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOrder" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOrderResponse getOrder(Consumer<GetOrderRequest.Builder> getOrderRequest) throws ValidationException,
            NotFoundException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return getOrder(GetOrderRequest.builder().applyMutation(getOrderRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified Outpost.
     * </p>
     *
     * @param getOutpostRequest
     * @return Result of the GetOutpost operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOutpostResponse getOutpost(GetOutpostRequest getOutpostRequest) throws ValidationException, NotFoundException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutpostRequest.Builder} avoiding the need to
     * create one manually via {@link GetOutpostRequest#builder()}
     * </p>
     *
     * @param getOutpostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetOutpostRequest.Builder} to create a request.
     * @return Result of the GetOutpost operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOutpostResponse getOutpost(Consumer<GetOutpostRequest.Builder> getOutpostRequest) throws ValidationException,
            NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return getOutpost(GetOutpostRequest.builder().applyMutation(getOutpostRequest).build());
    }

    /**
     * <p>
     * Gets the instance types for the specified Outpost.
     * </p>
     *
     * @param getOutpostInstanceTypesRequest
     * @return Result of the GetOutpostInstanceTypes operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetOutpostInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOutpostInstanceTypesResponse getOutpostInstanceTypes(GetOutpostInstanceTypesRequest getOutpostInstanceTypesRequest)
            throws ValidationException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the instance types for the specified Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutpostInstanceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link GetOutpostInstanceTypesRequest#builder()}
     * </p>
     *
     * @param getOutpostInstanceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest.Builder} to create a
     *        request.
     * @return Result of the GetOutpostInstanceTypes operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetOutpostInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOutpostInstanceTypesResponse getOutpostInstanceTypes(
            Consumer<GetOutpostInstanceTypesRequest.Builder> getOutpostInstanceTypesRequest) throws ValidationException,
            NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return getOutpostInstanceTypes(GetOutpostInstanceTypesRequest.builder().applyMutation(getOutpostInstanceTypesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getOutpostInstanceTypes(software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.GetOutpostInstanceTypesIterable responses = client.getOutpostInstanceTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.GetOutpostInstanceTypesIterable responses = client
     *             .getOutpostInstanceTypesPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.GetOutpostInstanceTypesIterable responses = client.getOutpostInstanceTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOutpostInstanceTypes(software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getOutpostInstanceTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetOutpostInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOutpostInstanceTypesIterable getOutpostInstanceTypesPaginator(
            GetOutpostInstanceTypesRequest getOutpostInstanceTypesRequest) throws ValidationException, NotFoundException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return new GetOutpostInstanceTypesIterable(this, getOutpostInstanceTypesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getOutpostInstanceTypes(software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.GetOutpostInstanceTypesIterable responses = client.getOutpostInstanceTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.GetOutpostInstanceTypesIterable responses = client
     *             .getOutpostInstanceTypesPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.GetOutpostInstanceTypesIterable responses = client.getOutpostInstanceTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOutpostInstanceTypes(software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutpostInstanceTypesRequest.Builder} avoiding
     * the need to create one manually via {@link GetOutpostInstanceTypesRequest#builder()}
     * </p>
     *
     * @param getOutpostInstanceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetOutpostInstanceTypesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetOutpostInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOutpostInstanceTypesIterable getOutpostInstanceTypesPaginator(
            Consumer<GetOutpostInstanceTypesRequest.Builder> getOutpostInstanceTypesRequest) throws ValidationException,
            NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return getOutpostInstanceTypesPaginator(GetOutpostInstanceTypesRequest.builder()
                .applyMutation(getOutpostInstanceTypesRequest).build());
    }

    /**
     * <p>
     * Gets the instance types that an Outpost can support in <code>InstanceTypeCapacity</code>. This will generally
     * include instance types that are not currently configured and therefore cannot be launched with the current
     * Outpost capacity configuration.
     * </p>
     *
     * @param getOutpostSupportedInstanceTypesRequest
     * @return Result of the GetOutpostSupportedInstanceTypes operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetOutpostSupportedInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostSupportedInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOutpostSupportedInstanceTypesResponse getOutpostSupportedInstanceTypes(
            GetOutpostSupportedInstanceTypesRequest getOutpostSupportedInstanceTypesRequest) throws ValidationException,
            AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the instance types that an Outpost can support in <code>InstanceTypeCapacity</code>. This will generally
     * include instance types that are not currently configured and therefore cannot be launched with the current
     * Outpost capacity configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutpostSupportedInstanceTypesRequest.Builder}
     * avoiding the need to create one manually via {@link GetOutpostSupportedInstanceTypesRequest#builder()}
     * </p>
     *
     * @param getOutpostSupportedInstanceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetOutpostSupportedInstanceTypesRequest.Builder} to
     *        create a request.
     * @return Result of the GetOutpostSupportedInstanceTypes operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetOutpostSupportedInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostSupportedInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOutpostSupportedInstanceTypesResponse getOutpostSupportedInstanceTypes(
            Consumer<GetOutpostSupportedInstanceTypesRequest.Builder> getOutpostSupportedInstanceTypesRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return getOutpostSupportedInstanceTypes(GetOutpostSupportedInstanceTypesRequest.builder()
                .applyMutation(getOutpostSupportedInstanceTypesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getOutpostSupportedInstanceTypes(software.amazon.awssdk.services.outposts.model.GetOutpostSupportedInstanceTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.GetOutpostSupportedInstanceTypesIterable responses = client.getOutpostSupportedInstanceTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.GetOutpostSupportedInstanceTypesIterable responses = client
     *             .getOutpostSupportedInstanceTypesPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.GetOutpostSupportedInstanceTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.GetOutpostSupportedInstanceTypesIterable responses = client.getOutpostSupportedInstanceTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOutpostSupportedInstanceTypes(software.amazon.awssdk.services.outposts.model.GetOutpostSupportedInstanceTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getOutpostSupportedInstanceTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetOutpostSupportedInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostSupportedInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOutpostSupportedInstanceTypesIterable getOutpostSupportedInstanceTypesPaginator(
            GetOutpostSupportedInstanceTypesRequest getOutpostSupportedInstanceTypesRequest) throws ValidationException,
            AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return new GetOutpostSupportedInstanceTypesIterable(this, getOutpostSupportedInstanceTypesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getOutpostSupportedInstanceTypes(software.amazon.awssdk.services.outposts.model.GetOutpostSupportedInstanceTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.GetOutpostSupportedInstanceTypesIterable responses = client.getOutpostSupportedInstanceTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.GetOutpostSupportedInstanceTypesIterable responses = client
     *             .getOutpostSupportedInstanceTypesPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.GetOutpostSupportedInstanceTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.GetOutpostSupportedInstanceTypesIterable responses = client.getOutpostSupportedInstanceTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOutpostSupportedInstanceTypes(software.amazon.awssdk.services.outposts.model.GetOutpostSupportedInstanceTypesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutpostSupportedInstanceTypesRequest.Builder}
     * avoiding the need to create one manually via {@link GetOutpostSupportedInstanceTypesRequest#builder()}
     * </p>
     *
     * @param getOutpostSupportedInstanceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetOutpostSupportedInstanceTypesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetOutpostSupportedInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostSupportedInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOutpostSupportedInstanceTypesIterable getOutpostSupportedInstanceTypesPaginator(
            Consumer<GetOutpostSupportedInstanceTypesRequest.Builder> getOutpostSupportedInstanceTypesRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return getOutpostSupportedInstanceTypesPaginator(GetOutpostSupportedInstanceTypesRequest.builder()
                .applyMutation(getOutpostSupportedInstanceTypesRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified Outpost site.
     * </p>
     *
     * @param getSiteRequest
     * @return Result of the GetSite operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetSite" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSiteResponse getSite(GetSiteRequest getSiteRequest) throws ValidationException, NotFoundException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified Outpost site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSiteRequest.Builder} avoiding the need to create
     * one manually via {@link GetSiteRequest#builder()}
     * </p>
     *
     * @param getSiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetSiteRequest.Builder} to create a request.
     * @return Result of the GetSite operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetSite" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSiteResponse getSite(Consumer<GetSiteRequest.Builder> getSiteRequest) throws ValidationException,
            NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return getSite(GetSiteRequest.builder().applyMutation(getSiteRequest).build());
    }

    /**
     * <p>
     * Gets the site address of the specified site.
     * </p>
     *
     * @param getSiteAddressRequest
     * @return Result of the GetSiteAddress operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetSiteAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetSiteAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSiteAddressResponse getSiteAddress(GetSiteAddressRequest getSiteAddressRequest) throws ValidationException,
            AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the site address of the specified site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSiteAddressRequest.Builder} avoiding the need to
     * create one manually via {@link GetSiteAddressRequest#builder()}
     * </p>
     *
     * @param getSiteAddressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.GetSiteAddressRequest.Builder} to create a request.
     * @return Result of the GetSiteAddress operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.GetSiteAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetSiteAddress" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSiteAddressResponse getSiteAddress(Consumer<GetSiteAddressRequest.Builder> getSiteAddressRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return getSiteAddress(GetSiteAddressRequest.builder().applyMutation(getSiteAddressRequest).build());
    }

    /**
     * <p>
     * A list of Amazon EC2 instances, belonging to all accounts, running on the specified Outpost. Does not include
     * Amazon EBS or Amazon S3 instances.
     * </p>
     *
     * @param listAssetInstancesRequest
     * @return Result of the ListAssetInstances operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListAssetInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListAssetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetInstancesResponse listAssetInstances(ListAssetInstancesRequest listAssetInstancesRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of Amazon EC2 instances, belonging to all accounts, running on the specified Outpost. Does not include
     * Amazon EBS or Amazon S3 instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetInstancesRequest#builder()}
     * </p>
     *
     * @param listAssetInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListAssetInstancesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssetInstances operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListAssetInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListAssetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetInstancesResponse listAssetInstances(Consumer<ListAssetInstancesRequest.Builder> listAssetInstancesRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return listAssetInstances(ListAssetInstancesRequest.builder().applyMutation(listAssetInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetInstances(software.amazon.awssdk.services.outposts.model.ListAssetInstancesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListAssetInstancesIterable responses = client.listAssetInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListAssetInstancesIterable responses = client
     *             .listAssetInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListAssetInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListAssetInstancesIterable responses = client.listAssetInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetInstances(software.amazon.awssdk.services.outposts.model.ListAssetInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssetInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListAssetInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListAssetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetInstancesIterable listAssetInstancesPaginator(ListAssetInstancesRequest listAssetInstancesRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return new ListAssetInstancesIterable(this, listAssetInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetInstances(software.amazon.awssdk.services.outposts.model.ListAssetInstancesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListAssetInstancesIterable responses = client.listAssetInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListAssetInstancesIterable responses = client
     *             .listAssetInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListAssetInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListAssetInstancesIterable responses = client.listAssetInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetInstances(software.amazon.awssdk.services.outposts.model.ListAssetInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetInstancesRequest#builder()}
     * </p>
     *
     * @param listAssetInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListAssetInstancesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListAssetInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListAssetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssetInstancesIterable listAssetInstancesPaginator(
            Consumer<ListAssetInstancesRequest.Builder> listAssetInstancesRequest) throws ValidationException,
            AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return listAssetInstancesPaginator(ListAssetInstancesRequest.builder().applyMutation(listAssetInstancesRequest).build());
    }

    /**
     * <p>
     * Lists the hardware assets for the specified Outpost.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     *
     * @param listAssetsRequest
     * @return Result of the ListAssets operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetsResponse listAssets(ListAssetsRequest listAssetsRequest) throws ValidationException, AccessDeniedException,
            NotFoundException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the hardware assets for the specified Outpost.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAssetsRequest#builder()}
     * </p>
     *
     * @param listAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListAssetsRequest.Builder} to create a request.
     * @return Result of the ListAssets operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetsResponse listAssets(Consumer<ListAssetsRequest.Builder> listAssetsRequest) throws ValidationException,
            AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return listAssets(ListAssetsRequest.builder().applyMutation(listAssetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAssets(software.amazon.awssdk.services.outposts.model.ListAssetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListAssetsIterable responses = client.listAssetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListAssetsIterable responses = client.listAssetsPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListAssetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListAssetsIterable responses = client.listAssetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssets(software.amazon.awssdk.services.outposts.model.ListAssetsRequest)} operation.</b>
     * </p>
     *
     * @param listAssetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetsIterable listAssetsPaginator(ListAssetsRequest listAssetsRequest) throws ValidationException,
            AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return new ListAssetsIterable(this, listAssetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAssets(software.amazon.awssdk.services.outposts.model.ListAssetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListAssetsIterable responses = client.listAssetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListAssetsIterable responses = client.listAssetsPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListAssetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListAssetsIterable responses = client.listAssetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssets(software.amazon.awssdk.services.outposts.model.ListAssetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListAssetsRequest#builder()}
     * </p>
     *
     * @param listAssetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListAssetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListAssets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssetsIterable listAssetsPaginator(Consumer<ListAssetsRequest.Builder> listAssetsRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return listAssetsPaginator(ListAssetsRequest.builder().applyMutation(listAssetsRequest).build());
    }

    /**
     * <p>
     * A list of Amazon EC2 instances running on the Outpost and belonging to the account that initiated the capacity
     * task. Use this list to specify the instances you cannot stop to free up capacity to run the capacity task.
     * </p>
     *
     * @param listBlockingInstancesForCapacityTaskRequest
     * @return Result of the ListBlockingInstancesForCapacityTask operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListBlockingInstancesForCapacityTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListBlockingInstancesForCapacityTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBlockingInstancesForCapacityTaskResponse listBlockingInstancesForCapacityTask(
            ListBlockingInstancesForCapacityTaskRequest listBlockingInstancesForCapacityTaskRequest) throws ValidationException,
            AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of Amazon EC2 instances running on the Outpost and belonging to the account that initiated the capacity
     * task. Use this list to specify the instances you cannot stop to free up capacity to run the capacity task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBlockingInstancesForCapacityTaskRequest.Builder} avoiding the need to create one manually via
     * {@link ListBlockingInstancesForCapacityTaskRequest#builder()}
     * </p>
     *
     * @param listBlockingInstancesForCapacityTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListBlockingInstancesForCapacityTaskRequest.Builder}
     *        to create a request.
     * @return Result of the ListBlockingInstancesForCapacityTask operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListBlockingInstancesForCapacityTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListBlockingInstancesForCapacityTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBlockingInstancesForCapacityTaskResponse listBlockingInstancesForCapacityTask(
            Consumer<ListBlockingInstancesForCapacityTaskRequest.Builder> listBlockingInstancesForCapacityTaskRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return listBlockingInstancesForCapacityTask(ListBlockingInstancesForCapacityTaskRequest.builder()
                .applyMutation(listBlockingInstancesForCapacityTaskRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBlockingInstancesForCapacityTask(software.amazon.awssdk.services.outposts.model.ListBlockingInstancesForCapacityTaskRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListBlockingInstancesForCapacityTaskIterable responses = client.listBlockingInstancesForCapacityTaskPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListBlockingInstancesForCapacityTaskIterable responses = client
     *             .listBlockingInstancesForCapacityTaskPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListBlockingInstancesForCapacityTaskResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListBlockingInstancesForCapacityTaskIterable responses = client.listBlockingInstancesForCapacityTaskPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBlockingInstancesForCapacityTask(software.amazon.awssdk.services.outposts.model.ListBlockingInstancesForCapacityTaskRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBlockingInstancesForCapacityTaskRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListBlockingInstancesForCapacityTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListBlockingInstancesForCapacityTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBlockingInstancesForCapacityTaskIterable listBlockingInstancesForCapacityTaskPaginator(
            ListBlockingInstancesForCapacityTaskRequest listBlockingInstancesForCapacityTaskRequest) throws ValidationException,
            AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return new ListBlockingInstancesForCapacityTaskIterable(this, listBlockingInstancesForCapacityTaskRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBlockingInstancesForCapacityTask(software.amazon.awssdk.services.outposts.model.ListBlockingInstancesForCapacityTaskRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListBlockingInstancesForCapacityTaskIterable responses = client.listBlockingInstancesForCapacityTaskPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListBlockingInstancesForCapacityTaskIterable responses = client
     *             .listBlockingInstancesForCapacityTaskPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListBlockingInstancesForCapacityTaskResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListBlockingInstancesForCapacityTaskIterable responses = client.listBlockingInstancesForCapacityTaskPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBlockingInstancesForCapacityTask(software.amazon.awssdk.services.outposts.model.ListBlockingInstancesForCapacityTaskRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListBlockingInstancesForCapacityTaskRequest.Builder} avoiding the need to create one manually via
     * {@link ListBlockingInstancesForCapacityTaskRequest#builder()}
     * </p>
     *
     * @param listBlockingInstancesForCapacityTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListBlockingInstancesForCapacityTaskRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListBlockingInstancesForCapacityTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListBlockingInstancesForCapacityTask"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBlockingInstancesForCapacityTaskIterable listBlockingInstancesForCapacityTaskPaginator(
            Consumer<ListBlockingInstancesForCapacityTaskRequest.Builder> listBlockingInstancesForCapacityTaskRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return listBlockingInstancesForCapacityTaskPaginator(ListBlockingInstancesForCapacityTaskRequest.builder()
                .applyMutation(listBlockingInstancesForCapacityTaskRequest).build());
    }

    /**
     * <p>
     * Lists the capacity tasks for your Amazon Web Services account.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     *
     * @param listCapacityTasksRequest
     * @return Result of the ListCapacityTasks operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListCapacityTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListCapacityTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCapacityTasksResponse listCapacityTasks(ListCapacityTasksRequest listCapacityTasksRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the capacity tasks for your Amazon Web Services account.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCapacityTasksRequest.Builder} avoiding the need
     * to create one manually via {@link ListCapacityTasksRequest#builder()}
     * </p>
     *
     * @param listCapacityTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListCapacityTasksRequest.Builder} to create a
     *        request.
     * @return Result of the ListCapacityTasks operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListCapacityTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListCapacityTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCapacityTasksResponse listCapacityTasks(Consumer<ListCapacityTasksRequest.Builder> listCapacityTasksRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return listCapacityTasks(ListCapacityTasksRequest.builder().applyMutation(listCapacityTasksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCapacityTasks(software.amazon.awssdk.services.outposts.model.ListCapacityTasksRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListCapacityTasksIterable responses = client.listCapacityTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListCapacityTasksIterable responses = client
     *             .listCapacityTasksPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListCapacityTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListCapacityTasksIterable responses = client.listCapacityTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCapacityTasks(software.amazon.awssdk.services.outposts.model.ListCapacityTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCapacityTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListCapacityTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListCapacityTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCapacityTasksIterable listCapacityTasksPaginator(ListCapacityTasksRequest listCapacityTasksRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return new ListCapacityTasksIterable(this, listCapacityTasksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCapacityTasks(software.amazon.awssdk.services.outposts.model.ListCapacityTasksRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListCapacityTasksIterable responses = client.listCapacityTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListCapacityTasksIterable responses = client
     *             .listCapacityTasksPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListCapacityTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListCapacityTasksIterable responses = client.listCapacityTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCapacityTasks(software.amazon.awssdk.services.outposts.model.ListCapacityTasksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCapacityTasksRequest.Builder} avoiding the need
     * to create one manually via {@link ListCapacityTasksRequest#builder()}
     * </p>
     *
     * @param listCapacityTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListCapacityTasksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListCapacityTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListCapacityTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCapacityTasksIterable listCapacityTasksPaginator(
            Consumer<ListCapacityTasksRequest.Builder> listCapacityTasksRequest) throws ValidationException,
            AccessDeniedException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return listCapacityTasksPaginator(ListCapacityTasksRequest.builder().applyMutation(listCapacityTasksRequest).build());
    }

    /**
     * <p>
     * Lists the items in the catalog.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     *
     * @param listCatalogItemsRequest
     * @return Result of the ListCatalogItems operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListCatalogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListCatalogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCatalogItemsResponse listCatalogItems(ListCatalogItemsRequest listCatalogItemsRequest)
            throws ValidationException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the items in the catalog.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCatalogItemsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCatalogItemsRequest#builder()}
     * </p>
     *
     * @param listCatalogItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest.Builder} to create a
     *        request.
     * @return Result of the ListCatalogItems operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListCatalogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListCatalogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCatalogItemsResponse listCatalogItems(Consumer<ListCatalogItemsRequest.Builder> listCatalogItemsRequest)
            throws ValidationException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return listCatalogItems(ListCatalogItemsRequest.builder().applyMutation(listCatalogItemsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCatalogItems(software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListCatalogItemsIterable responses = client.listCatalogItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListCatalogItemsIterable responses = client
     *             .listCatalogItemsPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListCatalogItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListCatalogItemsIterable responses = client.listCatalogItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCatalogItems(software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest)} operation.</b>
     * </p>
     *
     * @param listCatalogItemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListCatalogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListCatalogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCatalogItemsIterable listCatalogItemsPaginator(ListCatalogItemsRequest listCatalogItemsRequest)
            throws ValidationException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return new ListCatalogItemsIterable(this, listCatalogItemsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCatalogItems(software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListCatalogItemsIterable responses = client.listCatalogItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListCatalogItemsIterable responses = client
     *             .listCatalogItemsPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListCatalogItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListCatalogItemsIterable responses = client.listCatalogItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCatalogItems(software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCatalogItemsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCatalogItemsRequest#builder()}
     * </p>
     *
     * @param listCatalogItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListCatalogItemsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListCatalogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListCatalogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCatalogItemsIterable listCatalogItemsPaginator(Consumer<ListCatalogItemsRequest.Builder> listCatalogItemsRequest)
            throws ValidationException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return listCatalogItemsPaginator(ListCatalogItemsRequest.builder().applyMutation(listCatalogItemsRequest).build());
    }

    /**
     * <p>
     * Lists the Outpost orders for your Amazon Web Services account.
     * </p>
     *
     * @param listOrdersRequest
     * @return Result of the ListOrders operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOrders" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOrdersResponse listOrders(ListOrdersRequest listOrdersRequest) throws ValidationException, NotFoundException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Outpost orders for your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrdersRequest.Builder} avoiding the need to
     * create one manually via {@link ListOrdersRequest#builder()}
     * </p>
     *
     * @param listOrdersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListOrdersRequest.Builder} to create a request.
     * @return Result of the ListOrders operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOrders" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOrdersResponse listOrders(Consumer<ListOrdersRequest.Builder> listOrdersRequest) throws ValidationException,
            NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return listOrders(ListOrdersRequest.builder().applyMutation(listOrdersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listOrders(software.amazon.awssdk.services.outposts.model.ListOrdersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOrdersIterable responses = client.listOrdersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListOrdersIterable responses = client.listOrdersPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListOrdersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOrdersIterable responses = client.listOrdersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrders(software.amazon.awssdk.services.outposts.model.ListOrdersRequest)} operation.</b>
     * </p>
     *
     * @param listOrdersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOrders" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOrdersIterable listOrdersPaginator(ListOrdersRequest listOrdersRequest) throws ValidationException,
            NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return new ListOrdersIterable(this, listOrdersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listOrders(software.amazon.awssdk.services.outposts.model.ListOrdersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOrdersIterable responses = client.listOrdersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListOrdersIterable responses = client.listOrdersPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListOrdersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOrdersIterable responses = client.listOrdersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrders(software.amazon.awssdk.services.outposts.model.ListOrdersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrdersRequest.Builder} avoiding the need to
     * create one manually via {@link ListOrdersRequest#builder()}
     * </p>
     *
     * @param listOrdersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListOrdersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListOrders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOrders" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOrdersIterable listOrdersPaginator(Consumer<ListOrdersRequest.Builder> listOrdersRequest)
            throws ValidationException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return listOrdersPaginator(ListOrdersRequest.builder().applyMutation(listOrdersRequest).build());
    }

    /**
     * <p>
     * Lists the Outposts for your Amazon Web Services account.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     *
     * @param listOutpostsRequest
     * @return Result of the ListOutposts operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListOutposts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOutposts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOutpostsResponse listOutposts(ListOutpostsRequest listOutpostsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Outposts for your Amazon Web Services account.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOutpostsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOutpostsRequest#builder()}
     * </p>
     *
     * @param listOutpostsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListOutpostsRequest.Builder} to create a request.
     * @return Result of the ListOutposts operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListOutposts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOutposts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOutpostsResponse listOutposts(Consumer<ListOutpostsRequest.Builder> listOutpostsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return listOutposts(ListOutpostsRequest.builder().applyMutation(listOutpostsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listOutposts(software.amazon.awssdk.services.outposts.model.ListOutpostsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOutpostsIterable responses = client.listOutpostsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListOutpostsIterable responses = client.listOutpostsPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListOutpostsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOutpostsIterable responses = client.listOutpostsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOutposts(software.amazon.awssdk.services.outposts.model.ListOutpostsRequest)} operation.</b>
     * </p>
     *
     * @param listOutpostsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListOutposts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOutposts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOutpostsIterable listOutpostsPaginator(ListOutpostsRequest listOutpostsRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return new ListOutpostsIterable(this, listOutpostsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listOutposts(software.amazon.awssdk.services.outposts.model.ListOutpostsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOutpostsIterable responses = client.listOutpostsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListOutpostsIterable responses = client.listOutpostsPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListOutpostsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListOutpostsIterable responses = client.listOutpostsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOutposts(software.amazon.awssdk.services.outposts.model.ListOutpostsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOutpostsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOutpostsRequest#builder()}
     * </p>
     *
     * @param listOutpostsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListOutpostsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListOutposts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOutposts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOutpostsIterable listOutpostsPaginator(Consumer<ListOutpostsRequest.Builder> listOutpostsRequest)
            throws ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        return listOutpostsPaginator(ListOutpostsRequest.builder().applyMutation(listOutpostsRequest).build());
    }

    /**
     * <p>
     * Lists the Outpost sites for your Amazon Web Services account. Use filters to return specific results.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     *
     * @param listSitesRequest
     * @return Result of the ListSites operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListSites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSitesResponse listSites(ListSitesRequest listSitesRequest) throws ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Outpost sites for your Amazon Web Services account. Use filters to return specific results.
     * </p>
     * <p>
     * Use filters to return specific results. If you specify multiple filters, the results include only the resources
     * that match all of the specified filters. For a filter where you can specify multiple values, the results include
     * items that match any of the values that you specify for the filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSitesRequest#builder()}
     * </p>
     *
     * @param listSitesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListSitesRequest.Builder} to create a request.
     * @return Result of the ListSites operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListSites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSitesResponse listSites(Consumer<ListSitesRequest.Builder> listSitesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return listSites(ListSitesRequest.builder().applyMutation(listSitesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSites(software.amazon.awssdk.services.outposts.model.ListSitesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListSitesIterable responses = client.listSitesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListSitesIterable responses = client.listSitesPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListSitesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListSitesIterable responses = client.listSitesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSites(software.amazon.awssdk.services.outposts.model.ListSitesRequest)} operation.</b>
     * </p>
     *
     * @param listSitesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListSites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSitesIterable listSitesPaginator(ListSitesRequest listSitesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return new ListSitesIterable(this, listSitesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSites(software.amazon.awssdk.services.outposts.model.ListSitesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListSitesIterable responses = client.listSitesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.outposts.paginators.ListSitesIterable responses = client.listSitesPaginator(request);
     *     for (software.amazon.awssdk.services.outposts.model.ListSitesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.outposts.paginators.ListSitesIterable responses = client.listSitesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSites(software.amazon.awssdk.services.outposts.model.ListSitesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSitesRequest#builder()}
     * </p>
     *
     * @param listSitesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListSitesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListSites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListSites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSitesIterable listSitesPaginator(Consumer<ListSitesRequest.Builder> listSitesRequest) throws ValidationException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OutpostsException {
        return listSitesPaginator(ListSitesRequest.builder().applyMutation(listSitesRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ValidationException, NotFoundException, AwsServiceException, SdkClientException,
            OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ValidationException, NotFoundException, AwsServiceException, SdkClientException, OutpostsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts the specified capacity task. You can have one active capacity task for each order and each Outpost.
     * </p>
     *
     * @param startCapacityTaskRequest
     * @return Result of the StartCapacityTask operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.StartCapacityTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/StartCapacityTask" target="_top">AWS
     *      API Documentation</a>
     */
    default StartCapacityTaskResponse startCapacityTask(StartCapacityTaskRequest startCapacityTaskRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified capacity task. You can have one active capacity task for each order and each Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCapacityTaskRequest.Builder} avoiding the need
     * to create one manually via {@link StartCapacityTaskRequest#builder()}
     * </p>
     *
     * @param startCapacityTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.StartCapacityTaskRequest.Builder} to create a
     *        request.
     * @return Result of the StartCapacityTask operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.StartCapacityTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/StartCapacityTask" target="_top">AWS
     *      API Documentation</a>
     */
    default StartCapacityTaskResponse startCapacityTask(Consumer<StartCapacityTaskRequest.Builder> startCapacityTaskRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, OutpostsException {
        return startCapacityTask(StartCapacityTaskRequest.builder().applyMutation(startCapacityTaskRequest).build());
    }

    /**
     * <note>
     * <p>
     * Amazon Web Services uses this action to install Outpost servers.
     * </p>
     * </note>
     * <p>
     * Starts the connection required for Outpost server installation.
     * </p>
     * <p>
     * Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to
     * secure it. For more information, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html"> Amazon Web Services
     * managed policies for Amazon Web Services Outposts</a> and <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html"> Logging Amazon Web
     * Services Outposts API calls with Amazon Web Services CloudTrail</a> in the <i>Amazon Web Services Outposts User
     * Guide</i>.
     * </p>
     *
     * @param startConnectionRequest
     * @return Result of the StartConnection operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.StartConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/StartConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default StartConnectionResponse startConnection(StartConnectionRequest startConnectionRequest) throws AccessDeniedException,
            ValidationException, NotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * Amazon Web Services uses this action to install Outpost servers.
     * </p>
     * </note>
     * <p>
     * Starts the connection required for Outpost server installation.
     * </p>
     * <p>
     * Use CloudTrail to monitor this action or Amazon Web Services managed policy for Amazon Web Services Outposts to
     * secure it. For more information, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/security-iam-awsmanpol.html"> Amazon Web Services
     * managed policies for Amazon Web Services Outposts</a> and <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/logging-using-cloudtrail.html"> Logging Amazon Web
     * Services Outposts API calls with Amazon Web Services CloudTrail</a> in the <i>Amazon Web Services Outposts User
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link StartConnectionRequest#builder()}
     * </p>
     *
     * @param startConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.StartConnectionRequest.Builder} to create a request.
     * @return Result of the StartConnection operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.StartConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/StartConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default StartConnectionResponse startConnection(Consumer<StartConnectionRequest.Builder> startConnectionRequest)
            throws AccessDeniedException, ValidationException, NotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return startConnection(StartConnectionRequest.builder().applyMutation(startConnectionRequest).build());
    }

    /**
     * <p>
     * Adds tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ValidationException, NotFoundException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ValidationException, NotFoundException, AwsServiceException, SdkClientException,
            OutpostsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ValidationException, NotFoundException, AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ValidationException, NotFoundException, AwsServiceException, SdkClientException,
            OutpostsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an Outpost.
     * </p>
     *
     * @param updateOutpostRequest
     * @return Result of the UpdateOutpost operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.UpdateOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateOutpostResponse updateOutpost(UpdateOutpostRequest updateOutpostRequest) throws ValidationException,
            ConflictException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an Outpost.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOutpostRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateOutpostRequest#builder()}
     * </p>
     *
     * @param updateOutpostRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.UpdateOutpostRequest.Builder} to create a request.
     * @return Result of the UpdateOutpost operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.UpdateOutpost
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateOutpost" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateOutpostResponse updateOutpost(Consumer<UpdateOutpostRequest.Builder> updateOutpostRequest)
            throws ValidationException, ConflictException, NotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, OutpostsException {
        return updateOutpost(UpdateOutpostRequest.builder().applyMutation(updateOutpostRequest).build());
    }

    /**
     * <p>
     * Updates the specified site.
     * </p>
     *
     * @param updateSiteRequest
     * @return Result of the UpdateSite operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.UpdateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSiteResponse updateSite(UpdateSiteRequest updateSiteRequest) throws ValidationException, ConflictException,
            NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified site.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSiteRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSiteRequest#builder()}
     * </p>
     *
     * @param updateSiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.UpdateSiteRequest.Builder} to create a request.
     * @return Result of the UpdateSite operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.UpdateSite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateSite" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSiteResponse updateSite(Consumer<UpdateSiteRequest.Builder> updateSiteRequest) throws ValidationException,
            ConflictException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        return updateSite(UpdateSiteRequest.builder().applyMutation(updateSiteRequest).build());
    }

    /**
     * <p>
     * Updates the address of the specified site.
     * </p>
     * <p>
     * You can't update a site address if there is an order in progress. You must wait for the order to complete or
     * cancel the order.
     * </p>
     * <p>
     * You can update the operating address before you place an order at the site, or after all Outposts that belong to
     * the site have been deactivated.
     * </p>
     *
     * @param updateSiteAddressRequest
     * @return Result of the UpdateSiteAddress operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.UpdateSiteAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateSiteAddress" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSiteAddressResponse updateSiteAddress(UpdateSiteAddressRequest updateSiteAddressRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the address of the specified site.
     * </p>
     * <p>
     * You can't update a site address if there is an order in progress. You must wait for the order to complete or
     * cancel the order.
     * </p>
     * <p>
     * You can update the operating address before you place an order at the site, or after all Outposts that belong to
     * the site have been deactivated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSiteAddressRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateSiteAddressRequest#builder()}
     * </p>
     *
     * @param updateSiteAddressRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.UpdateSiteAddressRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSiteAddress operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.UpdateSiteAddress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateSiteAddress" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateSiteAddressResponse updateSiteAddress(Consumer<UpdateSiteAddressRequest.Builder> updateSiteAddressRequest)
            throws ValidationException, AccessDeniedException, NotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, OutpostsException {
        return updateSiteAddress(UpdateSiteAddressRequest.builder().applyMutation(updateSiteAddressRequest).build());
    }

    /**
     * <p>
     * Update the physical and logistical details for a rack at a site. For more information about hardware requirements
     * for racks, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network
     * readiness checklist</a> in the Amazon Web Services Outposts User Guide.
     * </p>
     * <p>
     * To update a rack at a site with an order of <code>IN_PROGRESS</code>, you must wait for the order to complete or
     * cancel the order.
     * </p>
     *
     * @param updateSiteRackPhysicalPropertiesRequest
     * @return Result of the UpdateSiteRackPhysicalProperties operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.UpdateSiteRackPhysicalProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateSiteRackPhysicalProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSiteRackPhysicalPropertiesResponse updateSiteRackPhysicalProperties(
            UpdateSiteRackPhysicalPropertiesRequest updateSiteRackPhysicalPropertiesRequest) throws ValidationException,
            ConflictException, NotFoundException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OutpostsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the physical and logistical details for a rack at a site. For more information about hardware requirements
     * for racks, see <a
     * href="https://docs.aws.amazon.com/outposts/latest/userguide/outposts-requirements.html#checklist">Network
     * readiness checklist</a> in the Amazon Web Services Outposts User Guide.
     * </p>
     * <p>
     * To update a rack at a site with an order of <code>IN_PROGRESS</code>, you must wait for the order to complete or
     * cancel the order.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSiteRackPhysicalPropertiesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSiteRackPhysicalPropertiesRequest#builder()}
     * </p>
     *
     * @param updateSiteRackPhysicalPropertiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.outposts.model.UpdateSiteRackPhysicalPropertiesRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateSiteRackPhysicalProperties operation returned by the service.
     * @throws ValidationException
     *         A parameter is not valid.
     * @throws ConflictException
     *         Updating or deleting this resource can cause an inconsistent state.
     * @throws NotFoundException
     *         The specified request is not valid.
     * @throws AccessDeniedException
     *         You do not have permission to perform this operation.
     * @throws InternalServerException
     *         An internal error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OutpostsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OutpostsClient.UpdateSiteRackPhysicalProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/UpdateSiteRackPhysicalProperties"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSiteRackPhysicalPropertiesResponse updateSiteRackPhysicalProperties(
            Consumer<UpdateSiteRackPhysicalPropertiesRequest.Builder> updateSiteRackPhysicalPropertiesRequest)
            throws ValidationException, ConflictException, NotFoundException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, OutpostsException {
        return updateSiteRackPhysicalProperties(UpdateSiteRackPhysicalPropertiesRequest.builder()
                .applyMutation(updateSiteRackPhysicalPropertiesRequest).build());
    }

    /**
     * Create a {@link OutpostsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static OutpostsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link OutpostsClient}.
     */
    static OutpostsClientBuilder builder() {
        return new DefaultOutpostsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default OutpostsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
