/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A running Amazon EC2 instance that can be stopped to free up capacity needed to run the capacity task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockingInstance implements SdkPojo, Serializable,
        ToCopyableBuilder<BlockingInstance.Builder, BlockingInstance> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(BlockingInstance::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(BlockingInstance::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> AWS_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsServiceName").getter(getter(BlockingInstance::awsServiceNameAsString))
            .setter(setter(Builder::awsServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsServiceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            ACCOUNT_ID_FIELD, AWS_SERVICE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String accountId;

    private final String awsServiceName;

    private BlockingInstance(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.accountId = builder.accountId;
        this.awsServiceName = builder.awsServiceName;
    }

    /**
     * <p>
     * The ID of the blocking instance.
     * </p>
     * 
     * @return The ID of the blocking instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * Returns the value of the AccountId property for this object.
     * 
     * @return The value of the AccountId property for this object.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Amazon Web Services service name that owns the specified blocking instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #awsServiceName}
     * will return {@link AWSServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #awsServiceNameAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service name that owns the specified blocking instance.
     * @see AWSServiceName
     */
    public final AWSServiceName awsServiceName() {
        return AWSServiceName.fromValue(awsServiceName);
    }

    /**
     * <p>
     * The Amazon Web Services service name that owns the specified blocking instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #awsServiceName}
     * will return {@link AWSServiceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #awsServiceNameAsString}.
     * </p>
     * 
     * @return The Amazon Web Services service name that owns the specified blocking instance.
     * @see AWSServiceName
     */
    public final String awsServiceNameAsString() {
        return awsServiceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsServiceNameAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockingInstance)) {
            return false;
        }
        BlockingInstance other = (BlockingInstance) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(awsServiceNameAsString(), other.awsServiceNameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlockingInstance").add("InstanceId", instanceId()).add("AccountId", accountId())
                .add("AwsServiceName", awsServiceNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "AwsServiceName":
            return Optional.ofNullable(clazz.cast(awsServiceNameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("AwsServiceName", AWS_SERVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlockingInstance, T> g) {
        return obj -> g.apply((BlockingInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockingInstance> {
        /**
         * <p>
         * The ID of the blocking instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the blocking instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * Sets the value of the AccountId property for this object.
         *
         * @param accountId
         *        The new value for the AccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Amazon Web Services service name that owns the specified blocking instance.
         * </p>
         * 
         * @param awsServiceName
         *        The Amazon Web Services service name that owns the specified blocking instance.
         * @see AWSServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AWSServiceName
         */
        Builder awsServiceName(String awsServiceName);

        /**
         * <p>
         * The Amazon Web Services service name that owns the specified blocking instance.
         * </p>
         * 
         * @param awsServiceName
         *        The Amazon Web Services service name that owns the specified blocking instance.
         * @see AWSServiceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AWSServiceName
         */
        Builder awsServiceName(AWSServiceName awsServiceName);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String accountId;

        private String awsServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockingInstance model) {
            instanceId(model.instanceId);
            accountId(model.accountId);
            awsServiceName(model.awsServiceName);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAwsServiceName() {
            return awsServiceName;
        }

        public final void setAwsServiceName(String awsServiceName) {
            this.awsServiceName = awsServiceName;
        }

        @Override
        public final Builder awsServiceName(String awsServiceName) {
            this.awsServiceName = awsServiceName;
            return this;
        }

        @Override
        public final Builder awsServiceName(AWSServiceName awsServiceName) {
            this.awsServiceName(awsServiceName == null ? null : awsServiceName.toString());
            return this;
        }

        @Override
        public BlockingInstance build() {
            return new BlockingInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
