/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a catalog item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CatalogItem implements SdkPojo, Serializable, ToCopyableBuilder<CatalogItem.Builder, CatalogItem> {
    private static final SdkField<String> CATALOG_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogItemId").getter(getter(CatalogItem::catalogItemId)).setter(setter(Builder::catalogItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogItemId").build()).build();

    private static final SdkField<String> ITEM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ItemStatus").getter(getter(CatalogItem::itemStatusAsString)).setter(setter(Builder::itemStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemStatus").build()).build();

    private static final SdkField<List<EC2Capacity>> EC2_CAPACITIES_FIELD = SdkField
            .<List<EC2Capacity>> builder(MarshallingType.LIST)
            .memberName("EC2Capacities")
            .getter(getter(CatalogItem::ec2Capacities))
            .setter(setter(Builder::ec2Capacities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2Capacities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EC2Capacity> builder(MarshallingType.SDK_POJO)
                                            .constructor(EC2Capacity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Float> POWER_KVA_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("PowerKva")
            .getter(getter(CatalogItem::powerKva)).setter(setter(Builder::powerKva))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PowerKva").build()).build();

    private static final SdkField<Integer> WEIGHT_LBS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WeightLbs").getter(getter(CatalogItem::weightLbs)).setter(setter(Builder::weightLbs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightLbs").build()).build();

    private static final SdkField<List<Integer>> SUPPORTED_UPLINK_GBPS_FIELD = SdkField
            .<List<Integer>> builder(MarshallingType.LIST)
            .memberName("SupportedUplinkGbps")
            .getter(getter(CatalogItem::supportedUplinkGbps))
            .setter(setter(Builder::supportedUplinkGbps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedUplinkGbps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_STORAGE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedStorage")
            .getter(getter(CatalogItem::supportedStorageAsStrings))
            .setter(setter(Builder::supportedStorageWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedStorage").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ITEM_ID_FIELD,
            ITEM_STATUS_FIELD, EC2_CAPACITIES_FIELD, POWER_KVA_FIELD, WEIGHT_LBS_FIELD, SUPPORTED_UPLINK_GBPS_FIELD,
            SUPPORTED_STORAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String catalogItemId;

    private final String itemStatus;

    private final List<EC2Capacity> ec2Capacities;

    private final Float powerKva;

    private final Integer weightLbs;

    private final List<Integer> supportedUplinkGbps;

    private final List<String> supportedStorage;

    private CatalogItem(BuilderImpl builder) {
        this.catalogItemId = builder.catalogItemId;
        this.itemStatus = builder.itemStatus;
        this.ec2Capacities = builder.ec2Capacities;
        this.powerKva = builder.powerKva;
        this.weightLbs = builder.weightLbs;
        this.supportedUplinkGbps = builder.supportedUplinkGbps;
        this.supportedStorage = builder.supportedStorage;
    }

    /**
     * <p>
     * The ID of the catalog item.
     * </p>
     * 
     * @return The ID of the catalog item.
     */
    public final String catalogItemId() {
        return catalogItemId;
    }

    /**
     * <p>
     * The status of a catalog item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #itemStatus} will
     * return {@link CatalogItemStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #itemStatusAsString}.
     * </p>
     * 
     * @return The status of a catalog item.
     * @see CatalogItemStatus
     */
    public final CatalogItemStatus itemStatus() {
        return CatalogItemStatus.fromValue(itemStatus);
    }

    /**
     * <p>
     * The status of a catalog item.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #itemStatus} will
     * return {@link CatalogItemStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #itemStatusAsString}.
     * </p>
     * 
     * @return The status of a catalog item.
     * @see CatalogItemStatus
     */
    public final String itemStatusAsString() {
        return itemStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the EC2Capacities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2Capacities() {
        return ec2Capacities != null && !(ec2Capacities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the EC2 capacity of an item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2Capacities} method.
     * </p>
     * 
     * @return Information about the EC2 capacity of an item.
     */
    public final List<EC2Capacity> ec2Capacities() {
        return ec2Capacities;
    }

    /**
     * <p>
     * Information about the power draw of an item.
     * </p>
     * 
     * @return Information about the power draw of an item.
     */
    public final Float powerKva() {
        return powerKva;
    }

    /**
     * <p>
     * The weight of the item in pounds.
     * </p>
     * 
     * @return The weight of the item in pounds.
     */
    public final Integer weightLbs() {
        return weightLbs;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedUplinkGbps property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedUplinkGbps() {
        return supportedUplinkGbps != null && !(supportedUplinkGbps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The uplink speed this catalog item requires for the connection to the Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedUplinkGbps} method.
     * </p>
     * 
     * @return The uplink speed this catalog item requires for the connection to the Region.
     */
    public final List<Integer> supportedUplinkGbps() {
        return supportedUplinkGbps;
    }

    /**
     * <p>
     * The supported storage options for the catalog item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedStorage} method.
     * </p>
     * 
     * @return The supported storage options for the catalog item.
     */
    public final List<SupportedStorageEnum> supportedStorage() {
        return SupportedStorageListCopier.copyStringToEnum(supportedStorage);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedStorage property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedStorage() {
        return supportedStorage != null && !(supportedStorage instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported storage options for the catalog item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedStorage} method.
     * </p>
     * 
     * @return The supported storage options for the catalog item.
     */
    public final List<String> supportedStorageAsStrings() {
        return supportedStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogItemId());
        hashCode = 31 * hashCode + Objects.hashCode(itemStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2Capacities() ? ec2Capacities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(powerKva());
        hashCode = 31 * hashCode + Objects.hashCode(weightLbs());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedUplinkGbps() ? supportedUplinkGbps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedStorage() ? supportedStorageAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogItem)) {
            return false;
        }
        CatalogItem other = (CatalogItem) obj;
        return Objects.equals(catalogItemId(), other.catalogItemId())
                && Objects.equals(itemStatusAsString(), other.itemStatusAsString())
                && hasEc2Capacities() == other.hasEc2Capacities() && Objects.equals(ec2Capacities(), other.ec2Capacities())
                && Objects.equals(powerKva(), other.powerKva()) && Objects.equals(weightLbs(), other.weightLbs())
                && hasSupportedUplinkGbps() == other.hasSupportedUplinkGbps()
                && Objects.equals(supportedUplinkGbps(), other.supportedUplinkGbps())
                && hasSupportedStorage() == other.hasSupportedStorage()
                && Objects.equals(supportedStorageAsStrings(), other.supportedStorageAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CatalogItem").add("CatalogItemId", catalogItemId()).add("ItemStatus", itemStatusAsString())
                .add("EC2Capacities", hasEc2Capacities() ? ec2Capacities() : null).add("PowerKva", powerKva())
                .add("WeightLbs", weightLbs())
                .add("SupportedUplinkGbps", hasSupportedUplinkGbps() ? supportedUplinkGbps() : null)
                .add("SupportedStorage", hasSupportedStorage() ? supportedStorageAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogItemId":
            return Optional.ofNullable(clazz.cast(catalogItemId()));
        case "ItemStatus":
            return Optional.ofNullable(clazz.cast(itemStatusAsString()));
        case "EC2Capacities":
            return Optional.ofNullable(clazz.cast(ec2Capacities()));
        case "PowerKva":
            return Optional.ofNullable(clazz.cast(powerKva()));
        case "WeightLbs":
            return Optional.ofNullable(clazz.cast(weightLbs()));
        case "SupportedUplinkGbps":
            return Optional.ofNullable(clazz.cast(supportedUplinkGbps()));
        case "SupportedStorage":
            return Optional.ofNullable(clazz.cast(supportedStorageAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CatalogItemId", CATALOG_ITEM_ID_FIELD);
        map.put("ItemStatus", ITEM_STATUS_FIELD);
        map.put("EC2Capacities", EC2_CAPACITIES_FIELD);
        map.put("PowerKva", POWER_KVA_FIELD);
        map.put("WeightLbs", WEIGHT_LBS_FIELD);
        map.put("SupportedUplinkGbps", SUPPORTED_UPLINK_GBPS_FIELD);
        map.put("SupportedStorage", SUPPORTED_STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CatalogItem, T> g) {
        return obj -> g.apply((CatalogItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CatalogItem> {
        /**
         * <p>
         * The ID of the catalog item.
         * </p>
         * 
         * @param catalogItemId
         *        The ID of the catalog item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogItemId(String catalogItemId);

        /**
         * <p>
         * The status of a catalog item.
         * </p>
         * 
         * @param itemStatus
         *        The status of a catalog item.
         * @see CatalogItemStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CatalogItemStatus
         */
        Builder itemStatus(String itemStatus);

        /**
         * <p>
         * The status of a catalog item.
         * </p>
         * 
         * @param itemStatus
         *        The status of a catalog item.
         * @see CatalogItemStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CatalogItemStatus
         */
        Builder itemStatus(CatalogItemStatus itemStatus);

        /**
         * <p>
         * Information about the EC2 capacity of an item.
         * </p>
         * 
         * @param ec2Capacities
         *        Information about the EC2 capacity of an item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2Capacities(Collection<EC2Capacity> ec2Capacities);

        /**
         * <p>
         * Information about the EC2 capacity of an item.
         * </p>
         * 
         * @param ec2Capacities
         *        Information about the EC2 capacity of an item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2Capacities(EC2Capacity... ec2Capacities);

        /**
         * <p>
         * Information about the EC2 capacity of an item.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.outposts.model.EC2Capacity.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.outposts.model.EC2Capacity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.outposts.model.EC2Capacity.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2Capacities(List<EC2Capacity>)}.
         * 
         * @param ec2Capacities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.outposts.model.EC2Capacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2Capacities(java.util.Collection<EC2Capacity>)
         */
        Builder ec2Capacities(Consumer<EC2Capacity.Builder>... ec2Capacities);

        /**
         * <p>
         * Information about the power draw of an item.
         * </p>
         * 
         * @param powerKva
         *        Information about the power draw of an item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder powerKva(Float powerKva);

        /**
         * <p>
         * The weight of the item in pounds.
         * </p>
         * 
         * @param weightLbs
         *        The weight of the item in pounds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightLbs(Integer weightLbs);

        /**
         * <p>
         * The uplink speed this catalog item requires for the connection to the Region.
         * </p>
         * 
         * @param supportedUplinkGbps
         *        The uplink speed this catalog item requires for the connection to the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedUplinkGbps(Collection<Integer> supportedUplinkGbps);

        /**
         * <p>
         * The uplink speed this catalog item requires for the connection to the Region.
         * </p>
         * 
         * @param supportedUplinkGbps
         *        The uplink speed this catalog item requires for the connection to the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedUplinkGbps(Integer... supportedUplinkGbps);

        /**
         * <p>
         * The supported storage options for the catalog item.
         * </p>
         * 
         * @param supportedStorage
         *        The supported storage options for the catalog item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedStorageWithStrings(Collection<String> supportedStorage);

        /**
         * <p>
         * The supported storage options for the catalog item.
         * </p>
         * 
         * @param supportedStorage
         *        The supported storage options for the catalog item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedStorageWithStrings(String... supportedStorage);

        /**
         * <p>
         * The supported storage options for the catalog item.
         * </p>
         * 
         * @param supportedStorage
         *        The supported storage options for the catalog item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedStorage(Collection<SupportedStorageEnum> supportedStorage);

        /**
         * <p>
         * The supported storage options for the catalog item.
         * </p>
         * 
         * @param supportedStorage
         *        The supported storage options for the catalog item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedStorage(SupportedStorageEnum... supportedStorage);
    }

    static final class BuilderImpl implements Builder {
        private String catalogItemId;

        private String itemStatus;

        private List<EC2Capacity> ec2Capacities = DefaultSdkAutoConstructList.getInstance();

        private Float powerKva;

        private Integer weightLbs;

        private List<Integer> supportedUplinkGbps = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedStorage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogItem model) {
            catalogItemId(model.catalogItemId);
            itemStatus(model.itemStatus);
            ec2Capacities(model.ec2Capacities);
            powerKva(model.powerKva);
            weightLbs(model.weightLbs);
            supportedUplinkGbps(model.supportedUplinkGbps);
            supportedStorageWithStrings(model.supportedStorage);
        }

        public final String getCatalogItemId() {
            return catalogItemId;
        }

        public final void setCatalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
        }

        @Override
        public final Builder catalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
            return this;
        }

        public final String getItemStatus() {
            return itemStatus;
        }

        public final void setItemStatus(String itemStatus) {
            this.itemStatus = itemStatus;
        }

        @Override
        public final Builder itemStatus(String itemStatus) {
            this.itemStatus = itemStatus;
            return this;
        }

        @Override
        public final Builder itemStatus(CatalogItemStatus itemStatus) {
            this.itemStatus(itemStatus == null ? null : itemStatus.toString());
            return this;
        }

        public final List<EC2Capacity.Builder> getEc2Capacities() {
            List<EC2Capacity.Builder> result = EC2CapacityListDefinitionCopier.copyToBuilder(this.ec2Capacities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2Capacities(Collection<EC2Capacity.BuilderImpl> ec2Capacities) {
            this.ec2Capacities = EC2CapacityListDefinitionCopier.copyFromBuilder(ec2Capacities);
        }

        @Override
        public final Builder ec2Capacities(Collection<EC2Capacity> ec2Capacities) {
            this.ec2Capacities = EC2CapacityListDefinitionCopier.copy(ec2Capacities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2Capacities(EC2Capacity... ec2Capacities) {
            ec2Capacities(Arrays.asList(ec2Capacities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2Capacities(Consumer<EC2Capacity.Builder>... ec2Capacities) {
            ec2Capacities(Stream.of(ec2Capacities).map(c -> EC2Capacity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Float getPowerKva() {
            return powerKva;
        }

        public final void setPowerKva(Float powerKva) {
            this.powerKva = powerKva;
        }

        @Override
        public final Builder powerKva(Float powerKva) {
            this.powerKva = powerKva;
            return this;
        }

        public final Integer getWeightLbs() {
            return weightLbs;
        }

        public final void setWeightLbs(Integer weightLbs) {
            this.weightLbs = weightLbs;
        }

        @Override
        public final Builder weightLbs(Integer weightLbs) {
            this.weightLbs = weightLbs;
            return this;
        }

        public final Collection<Integer> getSupportedUplinkGbps() {
            if (supportedUplinkGbps instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedUplinkGbps;
        }

        public final void setSupportedUplinkGbps(Collection<Integer> supportedUplinkGbps) {
            this.supportedUplinkGbps = SupportedUplinkGbpsListDefinitionCopier.copy(supportedUplinkGbps);
        }

        @Override
        public final Builder supportedUplinkGbps(Collection<Integer> supportedUplinkGbps) {
            this.supportedUplinkGbps = SupportedUplinkGbpsListDefinitionCopier.copy(supportedUplinkGbps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedUplinkGbps(Integer... supportedUplinkGbps) {
            supportedUplinkGbps(Arrays.asList(supportedUplinkGbps));
            return this;
        }

        public final Collection<String> getSupportedStorage() {
            if (supportedStorage instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedStorage;
        }

        public final void setSupportedStorage(Collection<String> supportedStorage) {
            this.supportedStorage = SupportedStorageListCopier.copy(supportedStorage);
        }

        @Override
        public final Builder supportedStorageWithStrings(Collection<String> supportedStorage) {
            this.supportedStorage = SupportedStorageListCopier.copy(supportedStorage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedStorageWithStrings(String... supportedStorage) {
            supportedStorageWithStrings(Arrays.asList(supportedStorage));
            return this;
        }

        @Override
        public final Builder supportedStorage(Collection<SupportedStorageEnum> supportedStorage) {
            this.supportedStorage = SupportedStorageListCopier.copyEnumToString(supportedStorage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedStorage(SupportedStorageEnum... supportedStorage) {
            supportedStorage(Arrays.asList(supportedStorage));
            return this;
        }

        @Override
        public CatalogItem build() {
            return new CatalogItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
