/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectionResponse extends OutpostsResponse implements
        ToCopyableBuilder<GetConnectionResponse.Builder, GetConnectionResponse> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionId").getter(getter(GetConnectionResponse::connectionId)).setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionId").build()).build();

    private static final SdkField<ConnectionDetails> CONNECTION_DETAILS_FIELD = SdkField
            .<ConnectionDetails> builder(MarshallingType.SDK_POJO).memberName("ConnectionDetails")
            .getter(getter(GetConnectionResponse::connectionDetails)).setter(setter(Builder::connectionDetails))
            .constructor(ConnectionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD,
            CONNECTION_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectionId;

    private final ConnectionDetails connectionDetails;

    private GetConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.connectionDetails = builder.connectionDetails;
    }

    /**
     * <p>
     * The ID of the connection.
     * </p>
     * 
     * @return The ID of the connection.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * Information about the connection.
     * </p>
     * 
     * @return Information about the connection.
     */
    public final ConnectionDetails connectionDetails() {
        return connectionDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionResponse)) {
            return false;
        }
        GetConnectionResponse other = (GetConnectionResponse) obj;
        return Objects.equals(connectionId(), other.connectionId())
                && Objects.equals(connectionDetails(), other.connectionDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConnectionResponse").add("ConnectionId", connectionId())
                .add("ConnectionDetails", connectionDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "ConnectionDetails":
            return Optional.ofNullable(clazz.cast(connectionDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionId", CONNECTION_ID_FIELD);
        map.put("ConnectionDetails", CONNECTION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionResponse, T> g) {
        return obj -> g.apply((GetConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetConnectionResponse> {
        /**
         * <p>
         * The ID of the connection.
         * </p>
         * 
         * @param connectionId
         *        The ID of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * Information about the connection.
         * </p>
         * 
         * @param connectionDetails
         *        Information about the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionDetails(ConnectionDetails connectionDetails);

        /**
         * <p>
         * Information about the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionDetails.Builder} avoiding the
         * need to create one manually via {@link ConnectionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #connectionDetails(ConnectionDetails)}.
         * 
         * @param connectionDetails
         *        a consumer that will call methods on {@link ConnectionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionDetails(ConnectionDetails)
         */
        default Builder connectionDetails(Consumer<ConnectionDetails.Builder> connectionDetails) {
            return connectionDetails(ConnectionDetails.builder().applyMutation(connectionDetails).build());
        }
    }

    static final class BuilderImpl extends OutpostsResponse.BuilderImpl implements Builder {
        private String connectionId;

        private ConnectionDetails connectionDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionResponse model) {
            super(model);
            connectionId(model.connectionId);
            connectionDetails(model.connectionDetails);
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final ConnectionDetails.Builder getConnectionDetails() {
            return connectionDetails != null ? connectionDetails.toBuilder() : null;
        }

        public final void setConnectionDetails(ConnectionDetails.BuilderImpl connectionDetails) {
            this.connectionDetails = connectionDetails != null ? connectionDetails.build() : null;
        }

        @Override
        public final Builder connectionDetails(ConnectionDetails connectionDetails) {
            this.connectionDetails = connectionDetails;
            return this;
        }

        @Override
        public GetConnectionResponse build() {
            return new GetConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
