/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOutpostSupportedInstanceTypesResponse extends OutpostsResponse implements
        ToCopyableBuilder<GetOutpostSupportedInstanceTypesResponse.Builder, GetOutpostSupportedInstanceTypesResponse> {
    private static final SdkField<List<InstanceTypeItem>> INSTANCE_TYPES_FIELD = SdkField
            .<List<InstanceTypeItem>> builder(MarshallingType.LIST)
            .memberName("InstanceTypes")
            .getter(getter(GetOutpostSupportedInstanceTypesResponse::instanceTypes))
            .setter(setter(Builder::instanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceTypeItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceTypeItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetOutpostSupportedInstanceTypesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InstanceTypeItem> instanceTypes;

    private final String nextToken;

    private GetOutpostSupportedInstanceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceTypes = builder.instanceTypes;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceTypes() {
        return instanceTypes != null && !(instanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the InstanceTypes property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceTypes} method.
     * </p>
     * 
     * @return The value of the InstanceTypes property for this object.
     */
    public final List<InstanceTypeItem> instanceTypes() {
        return instanceTypes;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceTypes() ? instanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOutpostSupportedInstanceTypesResponse)) {
            return false;
        }
        GetOutpostSupportedInstanceTypesResponse other = (GetOutpostSupportedInstanceTypesResponse) obj;
        return hasInstanceTypes() == other.hasInstanceTypes() && Objects.equals(instanceTypes(), other.instanceTypes())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOutpostSupportedInstanceTypesResponse")
                .add("InstanceTypes", hasInstanceTypes() ? instanceTypes() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceTypes":
            return Optional.ofNullable(clazz.cast(instanceTypes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceTypes", INSTANCE_TYPES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOutpostSupportedInstanceTypesResponse, T> g) {
        return obj -> g.apply((GetOutpostSupportedInstanceTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOutpostSupportedInstanceTypesResponse> {
        /**
         * Sets the value of the InstanceTypes property for this object.
         *
         * @param instanceTypes
         *        The new value for the InstanceTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(Collection<InstanceTypeItem> instanceTypes);

        /**
         * Sets the value of the InstanceTypes property for this object.
         *
         * @param instanceTypes
         *        The new value for the InstanceTypes property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypes(InstanceTypeItem... instanceTypes);

        /**
         * Sets the value of the InstanceTypes property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.outposts.model.InstanceTypeItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.outposts.model.InstanceTypeItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.outposts.model.InstanceTypeItem.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceTypes(List<InstanceTypeItem>)}.
         * 
         * @param instanceTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.outposts.model.InstanceTypeItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceTypes(java.util.Collection<InstanceTypeItem>)
         */
        Builder instanceTypes(Consumer<InstanceTypeItem.Builder>... instanceTypes);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OutpostsResponse.BuilderImpl implements Builder {
        private List<InstanceTypeItem> instanceTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOutpostSupportedInstanceTypesResponse model) {
            super(model);
            instanceTypes(model.instanceTypes);
            nextToken(model.nextToken);
        }

        public final List<InstanceTypeItem.Builder> getInstanceTypes() {
            List<InstanceTypeItem.Builder> result = InstanceTypeListDefinitionCopier.copyToBuilder(this.instanceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceTypes(Collection<InstanceTypeItem.BuilderImpl> instanceTypes) {
            this.instanceTypes = InstanceTypeListDefinitionCopier.copyFromBuilder(instanceTypes);
        }

        @Override
        public final Builder instanceTypes(Collection<InstanceTypeItem> instanceTypes) {
            this.instanceTypes = InstanceTypeListDefinitionCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(InstanceTypeItem... instanceTypes) {
            instanceTypes(Arrays.asList(instanceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(Consumer<InstanceTypeItem.Builder>... instanceTypes) {
            instanceTypes(Stream.of(instanceTypes).map(c -> InstanceTypeItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetOutpostSupportedInstanceTypesResponse build() {
            return new GetOutpostSupportedInstanceTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
