/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * User-specified instances that must not be stopped. These instances will not appear in the list of instances that
 * Amazon Web Services recommends to stop in order to free up capacity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstancesToExclude implements SdkPojo, Serializable,
        ToCopyableBuilder<InstancesToExclude.Builder, InstancesToExclude> {
    private static final SdkField<List<String>> INSTANCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Instances")
            .getter(getter(InstancesToExclude::instances))
            .setter(setter(Builder::instances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AccountIds")
            .getter(getter(InstancesToExclude::accountIds))
            .setter(setter(Builder::accountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Services")
            .getter(getter(InstancesToExclude::servicesAsStrings))
            .setter(setter(Builder::servicesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD,
            ACCOUNT_IDS_FIELD, SERVICES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> instances;

    private final List<String> accountIds;

    private final List<String> services;

    private InstancesToExclude(BuilderImpl builder) {
        this.instances = builder.instances;
        this.accountIds = builder.accountIds;
        this.services = builder.services;
    }

    /**
     * For responses, this returns true if the service returned a value for the Instances property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInstances() {
        return instances != null && !(instances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of user-specified instances that must not be stopped.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstances} method.
     * </p>
     * 
     * @return List of user-specified instances that must not be stopped.
     */
    public final List<String> instances() {
        return instances;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAccountIds() {
        return accountIds != null && !(accountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * IDs of the accounts that own each instance that must not be stopped.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIds} method.
     * </p>
     * 
     * @return IDs of the accounts that own each instance that must not be stopped.
     */
    public final List<String> accountIds() {
        return accountIds;
    }

    /**
     * <p>
     * Names of the services that own each instance that must not be stopped in order to free up the capacity needed to
     * run the capacity task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServices} method.
     * </p>
     * 
     * @return Names of the services that own each instance that must not be stopped in order to free up the capacity
     *         needed to run the capacity task.
     */
    public final List<AWSServiceName> services() {
        return AWSServiceNameListCopier.copyStringToEnum(services);
    }

    /**
     * For responses, this returns true if the service returned a value for the Services property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Names of the services that own each instance that must not be stopped in order to free up the capacity needed to
     * run the capacity task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServices} method.
     * </p>
     * 
     * @return Names of the services that own each instance that must not be stopped in order to free up the capacity
     *         needed to run the capacity task.
     */
    public final List<String> servicesAsStrings() {
        return services;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInstances() ? instances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIds() ? accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasServices() ? servicesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancesToExclude)) {
            return false;
        }
        InstancesToExclude other = (InstancesToExclude) obj;
        return hasInstances() == other.hasInstances() && Objects.equals(instances(), other.instances())
                && hasAccountIds() == other.hasAccountIds() && Objects.equals(accountIds(), other.accountIds())
                && hasServices() == other.hasServices() && Objects.equals(servicesAsStrings(), other.servicesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstancesToExclude").add("Instances", hasInstances() ? instances() : null)
                .add("AccountIds", hasAccountIds() ? accountIds() : null)
                .add("Services", hasServices() ? servicesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Instances":
            return Optional.ofNullable(clazz.cast(instances()));
        case "AccountIds":
            return Optional.ofNullable(clazz.cast(accountIds()));
        case "Services":
            return Optional.ofNullable(clazz.cast(servicesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Instances", INSTANCES_FIELD);
        map.put("AccountIds", ACCOUNT_IDS_FIELD);
        map.put("Services", SERVICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstancesToExclude, T> g) {
        return obj -> g.apply((InstancesToExclude) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstancesToExclude> {
        /**
         * <p>
         * List of user-specified instances that must not be stopped.
         * </p>
         * 
         * @param instances
         *        List of user-specified instances that must not be stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<String> instances);

        /**
         * <p>
         * List of user-specified instances that must not be stopped.
         * </p>
         * 
         * @param instances
         *        List of user-specified instances that must not be stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(String... instances);

        /**
         * <p>
         * IDs of the accounts that own each instance that must not be stopped.
         * </p>
         * 
         * @param accountIds
         *        IDs of the accounts that own each instance that must not be stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(Collection<String> accountIds);

        /**
         * <p>
         * IDs of the accounts that own each instance that must not be stopped.
         * </p>
         * 
         * @param accountIds
         *        IDs of the accounts that own each instance that must not be stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIds(String... accountIds);

        /**
         * <p>
         * Names of the services that own each instance that must not be stopped in order to free up the capacity needed
         * to run the capacity task.
         * </p>
         * 
         * @param services
         *        Names of the services that own each instance that must not be stopped in order to free up the capacity
         *        needed to run the capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicesWithStrings(Collection<String> services);

        /**
         * <p>
         * Names of the services that own each instance that must not be stopped in order to free up the capacity needed
         * to run the capacity task.
         * </p>
         * 
         * @param services
         *        Names of the services that own each instance that must not be stopped in order to free up the capacity
         *        needed to run the capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicesWithStrings(String... services);

        /**
         * <p>
         * Names of the services that own each instance that must not be stopped in order to free up the capacity needed
         * to run the capacity task.
         * </p>
         * 
         * @param services
         *        Names of the services that own each instance that must not be stopped in order to free up the capacity
         *        needed to run the capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<AWSServiceName> services);

        /**
         * <p>
         * Names of the services that own each instance that must not be stopped in order to free up the capacity needed
         * to run the capacity task.
         * </p>
         * 
         * @param services
         *        Names of the services that own each instance that must not be stopped in order to free up the capacity
         *        needed to run the capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(AWSServiceName... services);
    }

    static final class BuilderImpl implements Builder {
        private List<String> instances = DefaultSdkAutoConstructList.getInstance();

        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> services = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstancesToExclude model) {
            instances(model.instances);
            accountIds(model.accountIds);
            servicesWithStrings(model.services);
        }

        public final Collection<String> getInstances() {
            if (instances instanceof SdkAutoConstructList) {
                return null;
            }
            return instances;
        }

        public final void setInstances(Collection<String> instances) {
            this.instances = InstanceIdListCopier.copy(instances);
        }

        @Override
        public final Builder instances(Collection<String> instances) {
            this.instances = InstanceIdListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(String... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String... accountIds) {
            accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getServices() {
            if (services instanceof SdkAutoConstructList) {
                return null;
            }
            return services;
        }

        public final void setServices(Collection<String> services) {
            this.services = AWSServiceNameListCopier.copy(services);
        }

        @Override
        public final Builder servicesWithStrings(Collection<String> services) {
            this.services = AWSServiceNameListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servicesWithStrings(String... services) {
            servicesWithStrings(Arrays.asList(services));
            return this;
        }

        @Override
        public final Builder services(Collection<AWSServiceName> services) {
            this.services = AWSServiceNameListCopier.copyEnumToString(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(AWSServiceName... services) {
            services(Arrays.asList(services));
            return this;
        }

        @Override
        public InstancesToExclude build() {
            return new InstancesToExclude(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
