/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a line item request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineItemRequest implements SdkPojo, Serializable, ToCopyableBuilder<LineItemRequest.Builder, LineItemRequest> {
    private static final SdkField<String> CATALOG_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogItemId").getter(getter(LineItemRequest::catalogItemId)).setter(setter(Builder::catalogItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogItemId").build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity").getter(getter(LineItemRequest::quantity)).setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ITEM_ID_FIELD,
            QUANTITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String catalogItemId;

    private final Integer quantity;

    private LineItemRequest(BuilderImpl builder) {
        this.catalogItemId = builder.catalogItemId;
        this.quantity = builder.quantity;
    }

    /**
     * <p>
     * The ID of the catalog item.
     * </p>
     * 
     * @return The ID of the catalog item.
     */
    public final String catalogItemId() {
        return catalogItemId;
    }

    /**
     * <p>
     * The quantity of a line item request.
     * </p>
     * 
     * @return The quantity of a line item request.
     */
    public final Integer quantity() {
        return quantity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogItemId());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItemRequest)) {
            return false;
        }
        LineItemRequest other = (LineItemRequest) obj;
        return Objects.equals(catalogItemId(), other.catalogItemId()) && Objects.equals(quantity(), other.quantity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineItemRequest").add("CatalogItemId", catalogItemId()).add("Quantity", quantity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogItemId":
            return Optional.ofNullable(clazz.cast(catalogItemId()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CatalogItemId", CATALOG_ITEM_ID_FIELD);
        map.put("Quantity", QUANTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineItemRequest, T> g) {
        return obj -> g.apply((LineItemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineItemRequest> {
        /**
         * <p>
         * The ID of the catalog item.
         * </p>
         * 
         * @param catalogItemId
         *        The ID of the catalog item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogItemId(String catalogItemId);

        /**
         * <p>
         * The quantity of a line item request.
         * </p>
         * 
         * @param quantity
         *        The quantity of a line item request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);
    }

    static final class BuilderImpl implements Builder {
        private String catalogItemId;

        private Integer quantity;

        private BuilderImpl() {
        }

        private BuilderImpl(LineItemRequest model) {
            catalogItemId(model.catalogItemId);
            quantity(model.quantity);
        }

        public final String getCatalogItemId() {
            return catalogItemId;
        }

        public final void setCatalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
        }

        @Override
        public final Builder catalogItemId(String catalogItemId) {
            this.catalogItemId = catalogItemId;
            return this;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public LineItemRequest build() {
            return new LineItemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
