/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAssetInstancesRequest extends OutpostsRequest implements
        ToCopyableBuilder<ListAssetInstancesRequest.Builder, ListAssetInstancesRequest> {
    private static final SdkField<String> OUTPOST_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostIdentifier").getter(getter(ListAssetInstancesRequest::outpostIdentifier))
            .setter(setter(Builder::outpostIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("OutpostId").build()).build();

    private static final SdkField<List<String>> ASSET_ID_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssetIdFilter")
            .getter(getter(ListAssetInstancesRequest::assetIdFilter))
            .setter(setter(Builder::assetIdFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AssetIdFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INSTANCE_TYPE_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceTypeFilter")
            .getter(getter(ListAssetInstancesRequest::instanceTypeFilter))
            .setter(setter(Builder::instanceTypeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("InstanceTypeFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACCOUNT_ID_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AccountIdFilter")
            .getter(getter(ListAssetInstancesRequest::accountIdFilter))
            .setter(setter(Builder::accountIdFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AccountIdFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AWS_SERVICE_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AwsServiceFilter")
            .getter(getter(ListAssetInstancesRequest::awsServiceFilterAsStrings))
            .setter(setter(Builder::awsServiceFilterWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AwsServiceFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAssetInstancesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAssetInstancesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_IDENTIFIER_FIELD,
            ASSET_ID_FILTER_FIELD, INSTANCE_TYPE_FILTER_FIELD, ACCOUNT_ID_FILTER_FIELD, AWS_SERVICE_FILTER_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String outpostIdentifier;

    private final List<String> assetIdFilter;

    private final List<String> instanceTypeFilter;

    private final List<String> accountIdFilter;

    private final List<String> awsServiceFilter;

    private final Integer maxResults;

    private final String nextToken;

    private ListAssetInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.outpostIdentifier = builder.outpostIdentifier;
        this.assetIdFilter = builder.assetIdFilter;
        this.instanceTypeFilter = builder.instanceTypeFilter;
        this.accountIdFilter = builder.accountIdFilter;
        this.awsServiceFilter = builder.awsServiceFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID of the Outpost.
     * </p>
     * 
     * @return The ID of the Outpost.
     */
    public final String outpostIdentifier() {
        return outpostIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetIdFilter property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetIdFilter() {
        return assetIdFilter != null && !(assetIdFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the results by asset ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetIdFilter} method.
     * </p>
     * 
     * @return Filters the results by asset ID.
     */
    public final List<String> assetIdFilter() {
        return assetIdFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceTypeFilter property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceTypeFilter() {
        return instanceTypeFilter != null && !(instanceTypeFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the results by instance ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceTypeFilter} method.
     * </p>
     * 
     * @return Filters the results by instance ID.
     */
    public final List<String> instanceTypeFilter() {
        return instanceTypeFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountIdFilter property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountIdFilter() {
        return accountIdFilter != null && !(accountIdFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the results by account ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountIdFilter} method.
     * </p>
     * 
     * @return Filters the results by account ID.
     */
    public final List<String> accountIdFilter() {
        return accountIdFilter;
    }

    /**
     * <p>
     * Filters the results by Amazon Web Services service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsServiceFilter} method.
     * </p>
     * 
     * @return Filters the results by Amazon Web Services service.
     */
    public final List<AWSServiceName> awsServiceFilter() {
        return AWSServiceNameListCopier.copyStringToEnum(awsServiceFilter);
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsServiceFilter property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAwsServiceFilter() {
        return awsServiceFilter != null && !(awsServiceFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the results by Amazon Web Services service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsServiceFilter} method.
     * </p>
     * 
     * @return Filters the results by Amazon Web Services service.
     */
    public final List<String> awsServiceFilterAsStrings() {
        return awsServiceFilter;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(outpostIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetIdFilter() ? assetIdFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceTypeFilter() ? instanceTypeFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIdFilter() ? accountIdFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsServiceFilter() ? awsServiceFilterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssetInstancesRequest)) {
            return false;
        }
        ListAssetInstancesRequest other = (ListAssetInstancesRequest) obj;
        return Objects.equals(outpostIdentifier(), other.outpostIdentifier()) && hasAssetIdFilter() == other.hasAssetIdFilter()
                && Objects.equals(assetIdFilter(), other.assetIdFilter())
                && hasInstanceTypeFilter() == other.hasInstanceTypeFilter()
                && Objects.equals(instanceTypeFilter(), other.instanceTypeFilter())
                && hasAccountIdFilter() == other.hasAccountIdFilter()
                && Objects.equals(accountIdFilter(), other.accountIdFilter())
                && hasAwsServiceFilter() == other.hasAwsServiceFilter()
                && Objects.equals(awsServiceFilterAsStrings(), other.awsServiceFilterAsStrings())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAssetInstancesRequest").add("OutpostIdentifier", outpostIdentifier())
                .add("AssetIdFilter", hasAssetIdFilter() ? assetIdFilter() : null)
                .add("InstanceTypeFilter", hasInstanceTypeFilter() ? instanceTypeFilter() : null)
                .add("AccountIdFilter", hasAccountIdFilter() ? accountIdFilter() : null)
                .add("AwsServiceFilter", hasAwsServiceFilter() ? awsServiceFilterAsStrings() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostIdentifier":
            return Optional.ofNullable(clazz.cast(outpostIdentifier()));
        case "AssetIdFilter":
            return Optional.ofNullable(clazz.cast(assetIdFilter()));
        case "InstanceTypeFilter":
            return Optional.ofNullable(clazz.cast(instanceTypeFilter()));
        case "AccountIdFilter":
            return Optional.ofNullable(clazz.cast(accountIdFilter()));
        case "AwsServiceFilter":
            return Optional.ofNullable(clazz.cast(awsServiceFilterAsStrings()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutpostId", OUTPOST_IDENTIFIER_FIELD);
        map.put("AssetIdFilter", ASSET_ID_FILTER_FIELD);
        map.put("InstanceTypeFilter", INSTANCE_TYPE_FILTER_FIELD);
        map.put("AccountIdFilter", ACCOUNT_ID_FILTER_FIELD);
        map.put("AwsServiceFilter", AWS_SERVICE_FILTER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssetInstancesRequest, T> g) {
        return obj -> g.apply((ListAssetInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAssetInstancesRequest> {
        /**
         * <p>
         * The ID of the Outpost.
         * </p>
         * 
         * @param outpostIdentifier
         *        The ID of the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostIdentifier(String outpostIdentifier);

        /**
         * <p>
         * Filters the results by asset ID.
         * </p>
         * 
         * @param assetIdFilter
         *        Filters the results by asset ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetIdFilter(Collection<String> assetIdFilter);

        /**
         * <p>
         * Filters the results by asset ID.
         * </p>
         * 
         * @param assetIdFilter
         *        Filters the results by asset ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetIdFilter(String... assetIdFilter);

        /**
         * <p>
         * Filters the results by instance ID.
         * </p>
         * 
         * @param instanceTypeFilter
         *        Filters the results by instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypeFilter(Collection<String> instanceTypeFilter);

        /**
         * <p>
         * Filters the results by instance ID.
         * </p>
         * 
         * @param instanceTypeFilter
         *        Filters the results by instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypeFilter(String... instanceTypeFilter);

        /**
         * <p>
         * Filters the results by account ID.
         * </p>
         * 
         * @param accountIdFilter
         *        Filters the results by account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdFilter(Collection<String> accountIdFilter);

        /**
         * <p>
         * Filters the results by account ID.
         * </p>
         * 
         * @param accountIdFilter
         *        Filters the results by account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdFilter(String... accountIdFilter);

        /**
         * <p>
         * Filters the results by Amazon Web Services service.
         * </p>
         * 
         * @param awsServiceFilter
         *        Filters the results by Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsServiceFilterWithStrings(Collection<String> awsServiceFilter);

        /**
         * <p>
         * Filters the results by Amazon Web Services service.
         * </p>
         * 
         * @param awsServiceFilter
         *        Filters the results by Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsServiceFilterWithStrings(String... awsServiceFilter);

        /**
         * <p>
         * Filters the results by Amazon Web Services service.
         * </p>
         * 
         * @param awsServiceFilter
         *        Filters the results by Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsServiceFilter(Collection<AWSServiceName> awsServiceFilter);

        /**
         * <p>
         * Filters the results by Amazon Web Services service.
         * </p>
         * 
         * @param awsServiceFilter
         *        Filters the results by Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsServiceFilter(AWSServiceName... awsServiceFilter);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String outpostIdentifier;

        private List<String> assetIdFilter = DefaultSdkAutoConstructList.getInstance();

        private List<String> instanceTypeFilter = DefaultSdkAutoConstructList.getInstance();

        private List<String> accountIdFilter = DefaultSdkAutoConstructList.getInstance();

        private List<String> awsServiceFilter = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssetInstancesRequest model) {
            super(model);
            outpostIdentifier(model.outpostIdentifier);
            assetIdFilter(model.assetIdFilter);
            instanceTypeFilter(model.instanceTypeFilter);
            accountIdFilter(model.accountIdFilter);
            awsServiceFilterWithStrings(model.awsServiceFilter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getOutpostIdentifier() {
            return outpostIdentifier;
        }

        public final void setOutpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
        }

        @Override
        public final Builder outpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
            return this;
        }

        public final Collection<String> getAssetIdFilter() {
            if (assetIdFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return assetIdFilter;
        }

        public final void setAssetIdFilter(Collection<String> assetIdFilter) {
            this.assetIdFilter = AssetIdListCopier.copy(assetIdFilter);
        }

        @Override
        public final Builder assetIdFilter(Collection<String> assetIdFilter) {
            this.assetIdFilter = AssetIdListCopier.copy(assetIdFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetIdFilter(String... assetIdFilter) {
            assetIdFilter(Arrays.asList(assetIdFilter));
            return this;
        }

        public final Collection<String> getInstanceTypeFilter() {
            if (instanceTypeFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceTypeFilter;
        }

        public final void setInstanceTypeFilter(Collection<String> instanceTypeFilter) {
            this.instanceTypeFilter = OutpostInstanceTypeListCopier.copy(instanceTypeFilter);
        }

        @Override
        public final Builder instanceTypeFilter(Collection<String> instanceTypeFilter) {
            this.instanceTypeFilter = OutpostInstanceTypeListCopier.copy(instanceTypeFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeFilter(String... instanceTypeFilter) {
            instanceTypeFilter(Arrays.asList(instanceTypeFilter));
            return this;
        }

        public final Collection<String> getAccountIdFilter() {
            if (accountIdFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIdFilter;
        }

        public final void setAccountIdFilter(Collection<String> accountIdFilter) {
            this.accountIdFilter = AccountIdListCopier.copy(accountIdFilter);
        }

        @Override
        public final Builder accountIdFilter(Collection<String> accountIdFilter) {
            this.accountIdFilter = AccountIdListCopier.copy(accountIdFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdFilter(String... accountIdFilter) {
            accountIdFilter(Arrays.asList(accountIdFilter));
            return this;
        }

        public final Collection<String> getAwsServiceFilter() {
            if (awsServiceFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return awsServiceFilter;
        }

        public final void setAwsServiceFilter(Collection<String> awsServiceFilter) {
            this.awsServiceFilter = AWSServiceNameListCopier.copy(awsServiceFilter);
        }

        @Override
        public final Builder awsServiceFilterWithStrings(Collection<String> awsServiceFilter) {
            this.awsServiceFilter = AWSServiceNameListCopier.copy(awsServiceFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsServiceFilterWithStrings(String... awsServiceFilter) {
            awsServiceFilterWithStrings(Arrays.asList(awsServiceFilter));
            return this;
        }

        @Override
        public final Builder awsServiceFilter(Collection<AWSServiceName> awsServiceFilter) {
            this.awsServiceFilter = AWSServiceNameListCopier.copyEnumToString(awsServiceFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsServiceFilter(AWSServiceName... awsServiceFilter) {
            awsServiceFilter(Arrays.asList(awsServiceFilter));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAssetInstancesRequest build() {
            return new ListAssetInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
