/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBlockingInstancesForCapacityTaskRequest extends OutpostsRequest implements
        ToCopyableBuilder<ListBlockingInstancesForCapacityTaskRequest.Builder, ListBlockingInstancesForCapacityTaskRequest> {
    private static final SdkField<String> OUTPOST_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostIdentifier").getter(getter(ListBlockingInstancesForCapacityTaskRequest::outpostIdentifier))
            .setter(setter(Builder::outpostIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("OutpostId").build()).build();

    private static final SdkField<String> CAPACITY_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityTaskId").getter(getter(ListBlockingInstancesForCapacityTaskRequest::capacityTaskId))
            .setter(setter(Builder::capacityTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("CapacityTaskId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListBlockingInstancesForCapacityTaskRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBlockingInstancesForCapacityTaskRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_IDENTIFIER_FIELD,
            CAPACITY_TASK_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String outpostIdentifier;

    private final String capacityTaskId;

    private final Integer maxResults;

    private final String nextToken;

    private ListBlockingInstancesForCapacityTaskRequest(BuilderImpl builder) {
        super(builder);
        this.outpostIdentifier = builder.outpostIdentifier;
        this.capacityTaskId = builder.capacityTaskId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The ID or ARN of the Outpost associated with the specified capacity task.
     * </p>
     * 
     * @return The ID or ARN of the Outpost associated with the specified capacity task.
     */
    public final String outpostIdentifier() {
        return outpostIdentifier;
    }

    /**
     * <p>
     * The ID of the capacity task.
     * </p>
     * 
     * @return The ID of the capacity task.
     */
    public final String capacityTaskId() {
        return capacityTaskId;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(outpostIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(capacityTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBlockingInstancesForCapacityTaskRequest)) {
            return false;
        }
        ListBlockingInstancesForCapacityTaskRequest other = (ListBlockingInstancesForCapacityTaskRequest) obj;
        return Objects.equals(outpostIdentifier(), other.outpostIdentifier())
                && Objects.equals(capacityTaskId(), other.capacityTaskId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBlockingInstancesForCapacityTaskRequest").add("OutpostIdentifier", outpostIdentifier())
                .add("CapacityTaskId", capacityTaskId()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostIdentifier":
            return Optional.ofNullable(clazz.cast(outpostIdentifier()));
        case "CapacityTaskId":
            return Optional.ofNullable(clazz.cast(capacityTaskId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutpostId", OUTPOST_IDENTIFIER_FIELD);
        map.put("CapacityTaskId", CAPACITY_TASK_ID_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBlockingInstancesForCapacityTaskRequest, T> g) {
        return obj -> g.apply((ListBlockingInstancesForCapacityTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBlockingInstancesForCapacityTaskRequest> {
        /**
         * <p>
         * The ID or ARN of the Outpost associated with the specified capacity task.
         * </p>
         * 
         * @param outpostIdentifier
         *        The ID or ARN of the Outpost associated with the specified capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostIdentifier(String outpostIdentifier);

        /**
         * <p>
         * The ID of the capacity task.
         * </p>
         * 
         * @param capacityTaskId
         *        The ID of the capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityTaskId(String capacityTaskId);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String outpostIdentifier;

        private String capacityTaskId;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBlockingInstancesForCapacityTaskRequest model) {
            super(model);
            outpostIdentifier(model.outpostIdentifier);
            capacityTaskId(model.capacityTaskId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getOutpostIdentifier() {
            return outpostIdentifier;
        }

        public final void setOutpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
        }

        @Override
        public final Builder outpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
            return this;
        }

        public final String getCapacityTaskId() {
            return capacityTaskId;
        }

        public final void setCapacityTaskId(String capacityTaskId) {
            this.capacityTaskId = capacityTaskId;
        }

        @Override
        public final Builder capacityTaskId(String capacityTaskId) {
            this.capacityTaskId = capacityTaskId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBlockingInstancesForCapacityTaskRequest build() {
            return new ListBlockingInstancesForCapacityTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
