/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBlockingInstancesForCapacityTaskResponse extends OutpostsResponse implements
        ToCopyableBuilder<ListBlockingInstancesForCapacityTaskResponse.Builder, ListBlockingInstancesForCapacityTaskResponse> {
    private static final SdkField<List<BlockingInstance>> BLOCKING_INSTANCES_FIELD = SdkField
            .<List<BlockingInstance>> builder(MarshallingType.LIST)
            .memberName("BlockingInstances")
            .getter(getter(ListBlockingInstancesForCapacityTaskResponse::blockingInstances))
            .setter(setter(Builder::blockingInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockingInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BlockingInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockingInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBlockingInstancesForCapacityTaskResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKING_INSTANCES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BlockingInstance> blockingInstances;

    private final String nextToken;

    private ListBlockingInstancesForCapacityTaskResponse(BuilderImpl builder) {
        super(builder);
        this.blockingInstances = builder.blockingInstances;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockingInstances property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockingInstances() {
        return blockingInstances != null && !(blockingInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all running Amazon EC2 instances on the Outpost. Stopping one or more of these instances can free up
     * the capacity needed to run the capacity task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockingInstances} method.
     * </p>
     * 
     * @return A list of all running Amazon EC2 instances on the Outpost. Stopping one or more of these instances can
     *         free up the capacity needed to run the capacity task.
     */
    public final List<BlockingInstance> blockingInstances() {
        return blockingInstances;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockingInstances() ? blockingInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBlockingInstancesForCapacityTaskResponse)) {
            return false;
        }
        ListBlockingInstancesForCapacityTaskResponse other = (ListBlockingInstancesForCapacityTaskResponse) obj;
        return hasBlockingInstances() == other.hasBlockingInstances()
                && Objects.equals(blockingInstances(), other.blockingInstances())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBlockingInstancesForCapacityTaskResponse")
                .add("BlockingInstances", hasBlockingInstances() ? blockingInstances() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockingInstances":
            return Optional.ofNullable(clazz.cast(blockingInstances()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BlockingInstances", BLOCKING_INSTANCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBlockingInstancesForCapacityTaskResponse, T> g) {
        return obj -> g.apply((ListBlockingInstancesForCapacityTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBlockingInstancesForCapacityTaskResponse> {
        /**
         * <p>
         * A list of all running Amazon EC2 instances on the Outpost. Stopping one or more of these instances can free
         * up the capacity needed to run the capacity task.
         * </p>
         * 
         * @param blockingInstances
         *        A list of all running Amazon EC2 instances on the Outpost. Stopping one or more of these instances can
         *        free up the capacity needed to run the capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockingInstances(Collection<BlockingInstance> blockingInstances);

        /**
         * <p>
         * A list of all running Amazon EC2 instances on the Outpost. Stopping one or more of these instances can free
         * up the capacity needed to run the capacity task.
         * </p>
         * 
         * @param blockingInstances
         *        A list of all running Amazon EC2 instances on the Outpost. Stopping one or more of these instances can
         *        free up the capacity needed to run the capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockingInstances(BlockingInstance... blockingInstances);

        /**
         * <p>
         * A list of all running Amazon EC2 instances on the Outpost. Stopping one or more of these instances can free
         * up the capacity needed to run the capacity task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.outposts.model.BlockingInstance.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.outposts.model.BlockingInstance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.outposts.model.BlockingInstance.Builder#build()} is called immediately
         * and its result is passed to {@link #blockingInstances(List<BlockingInstance>)}.
         * 
         * @param blockingInstances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.outposts.model.BlockingInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockingInstances(java.util.Collection<BlockingInstance>)
         */
        Builder blockingInstances(Consumer<BlockingInstance.Builder>... blockingInstances);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OutpostsResponse.BuilderImpl implements Builder {
        private List<BlockingInstance> blockingInstances = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBlockingInstancesForCapacityTaskResponse model) {
            super(model);
            blockingInstances(model.blockingInstances);
            nextToken(model.nextToken);
        }

        public final List<BlockingInstance.Builder> getBlockingInstances() {
            List<BlockingInstance.Builder> result = BlockingInstancesListCopier.copyToBuilder(this.blockingInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockingInstances(Collection<BlockingInstance.BuilderImpl> blockingInstances) {
            this.blockingInstances = BlockingInstancesListCopier.copyFromBuilder(blockingInstances);
        }

        @Override
        public final Builder blockingInstances(Collection<BlockingInstance> blockingInstances) {
            this.blockingInstances = BlockingInstancesListCopier.copy(blockingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockingInstances(BlockingInstance... blockingInstances) {
            blockingInstances(Arrays.asList(blockingInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockingInstances(Consumer<BlockingInstance.Builder>... blockingInstances) {
            blockingInstances(Stream.of(blockingInstances).map(c -> BlockingInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBlockingInstancesForCapacityTaskResponse build() {
            return new ListBlockingInstancesForCapacityTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
