/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCapacityTasksRequest extends OutpostsRequest implements
        ToCopyableBuilder<ListCapacityTasksRequest.Builder, ListCapacityTasksRequest> {
    private static final SdkField<String> OUTPOST_IDENTIFIER_FILTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutpostIdentifierFilter")
            .getter(getter(ListCapacityTasksRequest::outpostIdentifierFilter))
            .setter(setter(Builder::outpostIdentifierFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OutpostIdentifierFilter")
                    .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListCapacityTasksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCapacityTasksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<List<String>> CAPACITY_TASK_STATUS_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CapacityTaskStatusFilter")
            .getter(getter(ListCapacityTasksRequest::capacityTaskStatusFilterAsStrings))
            .setter(setter(Builder::capacityTaskStatusFilterWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CapacityTaskStatusFilter")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            OUTPOST_IDENTIFIER_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, CAPACITY_TASK_STATUS_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String outpostIdentifierFilter;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> capacityTaskStatusFilter;

    private ListCapacityTasksRequest(BuilderImpl builder) {
        super(builder);
        this.outpostIdentifierFilter = builder.outpostIdentifierFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.capacityTaskStatusFilter = builder.capacityTaskStatusFilter;
    }

    /**
     * <p>
     * Filters the results by an Outpost ID or an Outpost ARN.
     * </p>
     * 
     * @return Filters the results by an Outpost ID or an Outpost ARN.
     */
    public final String outpostIdentifierFilter() {
        return outpostIdentifierFilter;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A list of statuses. For example, <code>REQUESTED</code> or <code>WAITING_FOR_EVACUATION</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityTaskStatusFilter} method.
     * </p>
     * 
     * @return A list of statuses. For example, <code>REQUESTED</code> or <code>WAITING_FOR_EVACUATION</code>.
     */
    public final List<CapacityTaskStatus> capacityTaskStatusFilter() {
        return CapacityTaskStatusListCopier.copyStringToEnum(capacityTaskStatusFilter);
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityTaskStatusFilter property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCapacityTaskStatusFilter() {
        return capacityTaskStatusFilter != null && !(capacityTaskStatusFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of statuses. For example, <code>REQUESTED</code> or <code>WAITING_FOR_EVACUATION</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityTaskStatusFilter} method.
     * </p>
     * 
     * @return A list of statuses. For example, <code>REQUESTED</code> or <code>WAITING_FOR_EVACUATION</code>.
     */
    public final List<String> capacityTaskStatusFilterAsStrings() {
        return capacityTaskStatusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(outpostIdentifierFilter());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityTaskStatusFilter() ? capacityTaskStatusFilterAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCapacityTasksRequest)) {
            return false;
        }
        ListCapacityTasksRequest other = (ListCapacityTasksRequest) obj;
        return Objects.equals(outpostIdentifierFilter(), other.outpostIdentifierFilter())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasCapacityTaskStatusFilter() == other.hasCapacityTaskStatusFilter()
                && Objects.equals(capacityTaskStatusFilterAsStrings(), other.capacityTaskStatusFilterAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCapacityTasksRequest").add("OutpostIdentifierFilter", outpostIdentifierFilter())
                .add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("CapacityTaskStatusFilter", hasCapacityTaskStatusFilter() ? capacityTaskStatusFilterAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostIdentifierFilter":
            return Optional.ofNullable(clazz.cast(outpostIdentifierFilter()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CapacityTaskStatusFilter":
            return Optional.ofNullable(clazz.cast(capacityTaskStatusFilterAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutpostIdentifierFilter", OUTPOST_IDENTIFIER_FILTER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("CapacityTaskStatusFilter", CAPACITY_TASK_STATUS_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCapacityTasksRequest, T> g) {
        return obj -> g.apply((ListCapacityTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCapacityTasksRequest> {
        /**
         * <p>
         * Filters the results by an Outpost ID or an Outpost ARN.
         * </p>
         * 
         * @param outpostIdentifierFilter
         *        Filters the results by an Outpost ID or an Outpost ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostIdentifierFilter(String outpostIdentifierFilter);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of statuses. For example, <code>REQUESTED</code> or <code>WAITING_FOR_EVACUATION</code>.
         * </p>
         * 
         * @param capacityTaskStatusFilter
         *        A list of statuses. For example, <code>REQUESTED</code> or <code>WAITING_FOR_EVACUATION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityTaskStatusFilterWithStrings(Collection<String> capacityTaskStatusFilter);

        /**
         * <p>
         * A list of statuses. For example, <code>REQUESTED</code> or <code>WAITING_FOR_EVACUATION</code>.
         * </p>
         * 
         * @param capacityTaskStatusFilter
         *        A list of statuses. For example, <code>REQUESTED</code> or <code>WAITING_FOR_EVACUATION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityTaskStatusFilterWithStrings(String... capacityTaskStatusFilter);

        /**
         * <p>
         * A list of statuses. For example, <code>REQUESTED</code> or <code>WAITING_FOR_EVACUATION</code>.
         * </p>
         * 
         * @param capacityTaskStatusFilter
         *        A list of statuses. For example, <code>REQUESTED</code> or <code>WAITING_FOR_EVACUATION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityTaskStatusFilter(Collection<CapacityTaskStatus> capacityTaskStatusFilter);

        /**
         * <p>
         * A list of statuses. For example, <code>REQUESTED</code> or <code>WAITING_FOR_EVACUATION</code>.
         * </p>
         * 
         * @param capacityTaskStatusFilter
         *        A list of statuses. For example, <code>REQUESTED</code> or <code>WAITING_FOR_EVACUATION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityTaskStatusFilter(CapacityTaskStatus... capacityTaskStatusFilter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String outpostIdentifierFilter;

        private Integer maxResults;

        private String nextToken;

        private List<String> capacityTaskStatusFilter = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCapacityTasksRequest model) {
            super(model);
            outpostIdentifierFilter(model.outpostIdentifierFilter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            capacityTaskStatusFilterWithStrings(model.capacityTaskStatusFilter);
        }

        public final String getOutpostIdentifierFilter() {
            return outpostIdentifierFilter;
        }

        public final void setOutpostIdentifierFilter(String outpostIdentifierFilter) {
            this.outpostIdentifierFilter = outpostIdentifierFilter;
        }

        @Override
        public final Builder outpostIdentifierFilter(String outpostIdentifierFilter) {
            this.outpostIdentifierFilter = outpostIdentifierFilter;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getCapacityTaskStatusFilter() {
            if (capacityTaskStatusFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return capacityTaskStatusFilter;
        }

        public final void setCapacityTaskStatusFilter(Collection<String> capacityTaskStatusFilter) {
            this.capacityTaskStatusFilter = CapacityTaskStatusListCopier.copy(capacityTaskStatusFilter);
        }

        @Override
        public final Builder capacityTaskStatusFilterWithStrings(Collection<String> capacityTaskStatusFilter) {
            this.capacityTaskStatusFilter = CapacityTaskStatusListCopier.copy(capacityTaskStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityTaskStatusFilterWithStrings(String... capacityTaskStatusFilter) {
            capacityTaskStatusFilterWithStrings(Arrays.asList(capacityTaskStatusFilter));
            return this;
        }

        @Override
        public final Builder capacityTaskStatusFilter(Collection<CapacityTaskStatus> capacityTaskStatusFilter) {
            this.capacityTaskStatusFilter = CapacityTaskStatusListCopier.copyEnumToString(capacityTaskStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityTaskStatusFilter(CapacityTaskStatus... capacityTaskStatusFilter) {
            capacityTaskStatusFilter(Arrays.asList(capacityTaskStatusFilter));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCapacityTasksRequest build() {
            return new ListCapacityTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
