/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCapacityTasksResponse extends OutpostsResponse implements
        ToCopyableBuilder<ListCapacityTasksResponse.Builder, ListCapacityTasksResponse> {
    private static final SdkField<List<CapacityTaskSummary>> CAPACITY_TASKS_FIELD = SdkField
            .<List<CapacityTaskSummary>> builder(MarshallingType.LIST)
            .memberName("CapacityTasks")
            .getter(getter(ListCapacityTasksResponse::capacityTasks))
            .setter(setter(Builder::capacityTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityTasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapacityTaskSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityTaskSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCapacityTasksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_TASKS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CapacityTaskSummary> capacityTasks;

    private final String nextToken;

    private ListCapacityTasksResponse(BuilderImpl builder) {
        super(builder);
        this.capacityTasks = builder.capacityTasks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityTasks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapacityTasks() {
        return capacityTasks != null && !(capacityTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists all the capacity tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityTasks} method.
     * </p>
     * 
     * @return Lists all the capacity tasks.
     */
    public final List<CapacityTaskSummary> capacityTasks() {
        return capacityTasks;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityTasks() ? capacityTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCapacityTasksResponse)) {
            return false;
        }
        ListCapacityTasksResponse other = (ListCapacityTasksResponse) obj;
        return hasCapacityTasks() == other.hasCapacityTasks() && Objects.equals(capacityTasks(), other.capacityTasks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCapacityTasksResponse").add("CapacityTasks", hasCapacityTasks() ? capacityTasks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityTasks":
            return Optional.ofNullable(clazz.cast(capacityTasks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityTasks", CAPACITY_TASKS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCapacityTasksResponse, T> g) {
        return obj -> g.apply((ListCapacityTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCapacityTasksResponse> {
        /**
         * <p>
         * Lists all the capacity tasks.
         * </p>
         * 
         * @param capacityTasks
         *        Lists all the capacity tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityTasks(Collection<CapacityTaskSummary> capacityTasks);

        /**
         * <p>
         * Lists all the capacity tasks.
         * </p>
         * 
         * @param capacityTasks
         *        Lists all the capacity tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityTasks(CapacityTaskSummary... capacityTasks);

        /**
         * <p>
         * Lists all the capacity tasks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.outposts.model.CapacityTaskSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.outposts.model.CapacityTaskSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.outposts.model.CapacityTaskSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #capacityTasks(List<CapacityTaskSummary>)}.
         * 
         * @param capacityTasks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.outposts.model.CapacityTaskSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityTasks(java.util.Collection<CapacityTaskSummary>)
         */
        Builder capacityTasks(Consumer<CapacityTaskSummary.Builder>... capacityTasks);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OutpostsResponse.BuilderImpl implements Builder {
        private List<CapacityTaskSummary> capacityTasks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCapacityTasksResponse model) {
            super(model);
            capacityTasks(model.capacityTasks);
            nextToken(model.nextToken);
        }

        public final List<CapacityTaskSummary.Builder> getCapacityTasks() {
            List<CapacityTaskSummary.Builder> result = CapacityTaskListCopier.copyToBuilder(this.capacityTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityTasks(Collection<CapacityTaskSummary.BuilderImpl> capacityTasks) {
            this.capacityTasks = CapacityTaskListCopier.copyFromBuilder(capacityTasks);
        }

        @Override
        public final Builder capacityTasks(Collection<CapacityTaskSummary> capacityTasks) {
            this.capacityTasks = CapacityTaskListCopier.copy(capacityTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityTasks(CapacityTaskSummary... capacityTasks) {
            capacityTasks(Arrays.asList(capacityTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityTasks(Consumer<CapacityTaskSummary.Builder>... capacityTasks) {
            capacityTasks(Stream.of(capacityTasks).map(c -> CapacityTaskSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCapacityTasksResponse build() {
            return new ListCapacityTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
