/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a line item shipment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShipmentInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<ShipmentInformation.Builder, ShipmentInformation> {
    private static final SdkField<String> SHIPMENT_TRACKING_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShipmentTrackingNumber").getter(getter(ShipmentInformation::shipmentTrackingNumber))
            .setter(setter(Builder::shipmentTrackingNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShipmentTrackingNumber").build())
            .build();

    private static final SdkField<String> SHIPMENT_CARRIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShipmentCarrier").getter(getter(ShipmentInformation::shipmentCarrierAsString))
            .setter(setter(Builder::shipmentCarrier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShipmentCarrier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SHIPMENT_TRACKING_NUMBER_FIELD, SHIPMENT_CARRIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String shipmentTrackingNumber;

    private final String shipmentCarrier;

    private ShipmentInformation(BuilderImpl builder) {
        this.shipmentTrackingNumber = builder.shipmentTrackingNumber;
        this.shipmentCarrier = builder.shipmentCarrier;
    }

    /**
     * <p>
     * The tracking number of the shipment.
     * </p>
     * 
     * @return The tracking number of the shipment.
     */
    public final String shipmentTrackingNumber() {
        return shipmentTrackingNumber;
    }

    /**
     * <p>
     * The carrier of the shipment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shipmentCarrier}
     * will return {@link ShipmentCarrier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shipmentCarrierAsString}.
     * </p>
     * 
     * @return The carrier of the shipment.
     * @see ShipmentCarrier
     */
    public final ShipmentCarrier shipmentCarrier() {
        return ShipmentCarrier.fromValue(shipmentCarrier);
    }

    /**
     * <p>
     * The carrier of the shipment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shipmentCarrier}
     * will return {@link ShipmentCarrier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shipmentCarrierAsString}.
     * </p>
     * 
     * @return The carrier of the shipment.
     * @see ShipmentCarrier
     */
    public final String shipmentCarrierAsString() {
        return shipmentCarrier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shipmentTrackingNumber());
        hashCode = 31 * hashCode + Objects.hashCode(shipmentCarrierAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShipmentInformation)) {
            return false;
        }
        ShipmentInformation other = (ShipmentInformation) obj;
        return Objects.equals(shipmentTrackingNumber(), other.shipmentTrackingNumber())
                && Objects.equals(shipmentCarrierAsString(), other.shipmentCarrierAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShipmentInformation").add("ShipmentTrackingNumber", shipmentTrackingNumber())
                .add("ShipmentCarrier", shipmentCarrierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShipmentTrackingNumber":
            return Optional.ofNullable(clazz.cast(shipmentTrackingNumber()));
        case "ShipmentCarrier":
            return Optional.ofNullable(clazz.cast(shipmentCarrierAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ShipmentTrackingNumber", SHIPMENT_TRACKING_NUMBER_FIELD);
        map.put("ShipmentCarrier", SHIPMENT_CARRIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ShipmentInformation, T> g) {
        return obj -> g.apply((ShipmentInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShipmentInformation> {
        /**
         * <p>
         * The tracking number of the shipment.
         * </p>
         * 
         * @param shipmentTrackingNumber
         *        The tracking number of the shipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shipmentTrackingNumber(String shipmentTrackingNumber);

        /**
         * <p>
         * The carrier of the shipment.
         * </p>
         * 
         * @param shipmentCarrier
         *        The carrier of the shipment.
         * @see ShipmentCarrier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShipmentCarrier
         */
        Builder shipmentCarrier(String shipmentCarrier);

        /**
         * <p>
         * The carrier of the shipment.
         * </p>
         * 
         * @param shipmentCarrier
         *        The carrier of the shipment.
         * @see ShipmentCarrier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShipmentCarrier
         */
        Builder shipmentCarrier(ShipmentCarrier shipmentCarrier);
    }

    static final class BuilderImpl implements Builder {
        private String shipmentTrackingNumber;

        private String shipmentCarrier;

        private BuilderImpl() {
        }

        private BuilderImpl(ShipmentInformation model) {
            shipmentTrackingNumber(model.shipmentTrackingNumber);
            shipmentCarrier(model.shipmentCarrier);
        }

        public final String getShipmentTrackingNumber() {
            return shipmentTrackingNumber;
        }

        public final void setShipmentTrackingNumber(String shipmentTrackingNumber) {
            this.shipmentTrackingNumber = shipmentTrackingNumber;
        }

        @Override
        public final Builder shipmentTrackingNumber(String shipmentTrackingNumber) {
            this.shipmentTrackingNumber = shipmentTrackingNumber;
            return this;
        }

        public final String getShipmentCarrier() {
            return shipmentCarrier;
        }

        public final void setShipmentCarrier(String shipmentCarrier) {
            this.shipmentCarrier = shipmentCarrier;
        }

        @Override
        public final Builder shipmentCarrier(String shipmentCarrier) {
            this.shipmentCarrier = shipmentCarrier;
            return this;
        }

        @Override
        public final Builder shipmentCarrier(ShipmentCarrier shipmentCarrier) {
            this.shipmentCarrier(shipmentCarrier == null ? null : shipmentCarrier.toString());
            return this;
        }

        @Override
        public ShipmentInformation build() {
            return new ShipmentInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
