/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a site.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Site implements SdkPojo, Serializable, ToCopyableBuilder<Site.Builder, Site> {
    private static final SdkField<String> SITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SiteId")
            .getter(getter(Site::siteId)).setter(setter(Builder::siteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteId").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(Site::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Site::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Site::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Site::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SITE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SiteArn").getter(getter(Site::siteArn)).setter(setter(Builder::siteArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SiteArn").build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(Site::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<String> OPERATING_ADDRESS_COUNTRY_CODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OperatingAddressCountryCode")
            .getter(getter(Site::operatingAddressCountryCode))
            .setter(setter(Builder::operatingAddressCountryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingAddressCountryCode")
                    .build()).build();

    private static final SdkField<String> OPERATING_ADDRESS_STATE_OR_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OperatingAddressStateOrRegion")
            .getter(getter(Site::operatingAddressStateOrRegion))
            .setter(setter(Builder::operatingAddressStateOrRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingAddressStateOrRegion")
                    .build()).build();

    private static final SdkField<String> OPERATING_ADDRESS_CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatingAddressCity").getter(getter(Site::operatingAddressCity))
            .setter(setter(Builder::operatingAddressCity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingAddressCity").build())
            .build();

    private static final SdkField<RackPhysicalProperties> RACK_PHYSICAL_PROPERTIES_FIELD = SdkField
            .<RackPhysicalProperties> builder(MarshallingType.SDK_POJO).memberName("RackPhysicalProperties")
            .getter(getter(Site::rackPhysicalProperties)).setter(setter(Builder::rackPhysicalProperties))
            .constructor(RackPhysicalProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RackPhysicalProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITE_ID_FIELD,
            ACCOUNT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, SITE_ARN_FIELD, NOTES_FIELD,
            OPERATING_ADDRESS_COUNTRY_CODE_FIELD, OPERATING_ADDRESS_STATE_OR_REGION_FIELD, OPERATING_ADDRESS_CITY_FIELD,
            RACK_PHYSICAL_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String siteId;

    private final String accountId;

    private final String name;

    private final String description;

    private final Map<String, String> tags;

    private final String siteArn;

    private final String notes;

    private final String operatingAddressCountryCode;

    private final String operatingAddressStateOrRegion;

    private final String operatingAddressCity;

    private final RackPhysicalProperties rackPhysicalProperties;

    private Site(BuilderImpl builder) {
        this.siteId = builder.siteId;
        this.accountId = builder.accountId;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
        this.siteArn = builder.siteArn;
        this.notes = builder.notes;
        this.operatingAddressCountryCode = builder.operatingAddressCountryCode;
        this.operatingAddressStateOrRegion = builder.operatingAddressStateOrRegion;
        this.operatingAddressCity = builder.operatingAddressCity;
        this.rackPhysicalProperties = builder.rackPhysicalProperties;
    }

    /**
     * Returns the value of the SiteId property for this object.
     * 
     * @return The value of the SiteId property for this object.
     */
    public final String siteId() {
        return siteId;
    }

    /**
     * Returns the value of the AccountId property for this object.
     * 
     * @return The value of the AccountId property for this object.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The site tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The site tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * Returns the value of the SiteArn property for this object.
     * 
     * @return The value of the SiteArn property for this object.
     */
    public final String siteArn() {
        return siteArn;
    }

    /**
     * <p>
     * Notes about a site.
     * </p>
     * 
     * @return Notes about a site.
     */
    public final String notes() {
        return notes;
    }

    /**
     * <p>
     * The ISO-3166 two-letter country code where the hardware is installed and powered on.
     * </p>
     * 
     * @return The ISO-3166 two-letter country code where the hardware is installed and powered on.
     */
    public final String operatingAddressCountryCode() {
        return operatingAddressCountryCode;
    }

    /**
     * <p>
     * State or region where the hardware is installed and powered on.
     * </p>
     * 
     * @return State or region where the hardware is installed and powered on.
     */
    public final String operatingAddressStateOrRegion() {
        return operatingAddressStateOrRegion;
    }

    /**
     * <p>
     * City where the hardware is installed and powered on.
     * </p>
     * 
     * @return City where the hardware is installed and powered on.
     */
    public final String operatingAddressCity() {
        return operatingAddressCity;
    }

    /**
     * <p>
     * Information about the physical and logistical details for a rack at the site.
     * </p>
     * 
     * @return Information about the physical and logistical details for a rack at the site.
     */
    public final RackPhysicalProperties rackPhysicalProperties() {
        return rackPhysicalProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(siteId());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(siteArn());
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(operatingAddressCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(operatingAddressStateOrRegion());
        hashCode = 31 * hashCode + Objects.hashCode(operatingAddressCity());
        hashCode = 31 * hashCode + Objects.hashCode(rackPhysicalProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Site)) {
            return false;
        }
        Site other = (Site) obj;
        return Objects.equals(siteId(), other.siteId()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(siteArn(), other.siteArn()) && Objects.equals(notes(), other.notes())
                && Objects.equals(operatingAddressCountryCode(), other.operatingAddressCountryCode())
                && Objects.equals(operatingAddressStateOrRegion(), other.operatingAddressStateOrRegion())
                && Objects.equals(operatingAddressCity(), other.operatingAddressCity())
                && Objects.equals(rackPhysicalProperties(), other.rackPhysicalProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Site").add("SiteId", siteId()).add("AccountId", accountId()).add("Name", name())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null).add("SiteArn", siteArn())
                .add("Notes", notes()).add("OperatingAddressCountryCode", operatingAddressCountryCode())
                .add("OperatingAddressStateOrRegion", operatingAddressStateOrRegion())
                .add("OperatingAddressCity", operatingAddressCity()).add("RackPhysicalProperties", rackPhysicalProperties())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SiteId":
            return Optional.ofNullable(clazz.cast(siteId()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SiteArn":
            return Optional.ofNullable(clazz.cast(siteArn()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "OperatingAddressCountryCode":
            return Optional.ofNullable(clazz.cast(operatingAddressCountryCode()));
        case "OperatingAddressStateOrRegion":
            return Optional.ofNullable(clazz.cast(operatingAddressStateOrRegion()));
        case "OperatingAddressCity":
            return Optional.ofNullable(clazz.cast(operatingAddressCity()));
        case "RackPhysicalProperties":
            return Optional.ofNullable(clazz.cast(rackPhysicalProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SiteId", SITE_ID_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SiteArn", SITE_ARN_FIELD);
        map.put("Notes", NOTES_FIELD);
        map.put("OperatingAddressCountryCode", OPERATING_ADDRESS_COUNTRY_CODE_FIELD);
        map.put("OperatingAddressStateOrRegion", OPERATING_ADDRESS_STATE_OR_REGION_FIELD);
        map.put("OperatingAddressCity", OPERATING_ADDRESS_CITY_FIELD);
        map.put("RackPhysicalProperties", RACK_PHYSICAL_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Site, T> g) {
        return obj -> g.apply((Site) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Site> {
        /**
         * Sets the value of the SiteId property for this object.
         *
         * @param siteId
         *        The new value for the SiteId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteId(String siteId);

        /**
         * Sets the value of the AccountId property for this object.
         *
         * @param accountId
         *        The new value for the AccountId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The site tags.
         * </p>
         * 
         * @param tags
         *        The site tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * Sets the value of the SiteArn property for this object.
         *
         * @param siteArn
         *        The new value for the SiteArn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteArn(String siteArn);

        /**
         * <p>
         * Notes about a site.
         * </p>
         * 
         * @param notes
         *        Notes about a site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * <p>
         * The ISO-3166 two-letter country code where the hardware is installed and powered on.
         * </p>
         * 
         * @param operatingAddressCountryCode
         *        The ISO-3166 two-letter country code where the hardware is installed and powered on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingAddressCountryCode(String operatingAddressCountryCode);

        /**
         * <p>
         * State or region where the hardware is installed and powered on.
         * </p>
         * 
         * @param operatingAddressStateOrRegion
         *        State or region where the hardware is installed and powered on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingAddressStateOrRegion(String operatingAddressStateOrRegion);

        /**
         * <p>
         * City where the hardware is installed and powered on.
         * </p>
         * 
         * @param operatingAddressCity
         *        City where the hardware is installed and powered on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingAddressCity(String operatingAddressCity);

        /**
         * <p>
         * Information about the physical and logistical details for a rack at the site.
         * </p>
         * 
         * @param rackPhysicalProperties
         *        Information about the physical and logistical details for a rack at the site.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rackPhysicalProperties(RackPhysicalProperties rackPhysicalProperties);

        /**
         * <p>
         * Information about the physical and logistical details for a rack at the site.
         * </p>
         * This is a convenience method that creates an instance of the {@link RackPhysicalProperties.Builder} avoiding
         * the need to create one manually via {@link RackPhysicalProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RackPhysicalProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #rackPhysicalProperties(RackPhysicalProperties)}.
         * 
         * @param rackPhysicalProperties
         *        a consumer that will call methods on {@link RackPhysicalProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rackPhysicalProperties(RackPhysicalProperties)
         */
        default Builder rackPhysicalProperties(Consumer<RackPhysicalProperties.Builder> rackPhysicalProperties) {
            return rackPhysicalProperties(RackPhysicalProperties.builder().applyMutation(rackPhysicalProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String siteId;

        private String accountId;

        private String name;

        private String description;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String siteArn;

        private String notes;

        private String operatingAddressCountryCode;

        private String operatingAddressStateOrRegion;

        private String operatingAddressCity;

        private RackPhysicalProperties rackPhysicalProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(Site model) {
            siteId(model.siteId);
            accountId(model.accountId);
            name(model.name);
            description(model.description);
            tags(model.tags);
            siteArn(model.siteArn);
            notes(model.notes);
            operatingAddressCountryCode(model.operatingAddressCountryCode);
            operatingAddressStateOrRegion(model.operatingAddressStateOrRegion);
            operatingAddressCity(model.operatingAddressCity);
            rackPhysicalProperties(model.rackPhysicalProperties);
        }

        public final String getSiteId() {
            return siteId;
        }

        public final void setSiteId(String siteId) {
            this.siteId = siteId;
        }

        @Override
        public final Builder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getSiteArn() {
            return siteArn;
        }

        public final void setSiteArn(String siteArn) {
            this.siteArn = siteArn;
        }

        @Override
        public final Builder siteArn(String siteArn) {
            this.siteArn = siteArn;
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final String getOperatingAddressCountryCode() {
            return operatingAddressCountryCode;
        }

        public final void setOperatingAddressCountryCode(String operatingAddressCountryCode) {
            this.operatingAddressCountryCode = operatingAddressCountryCode;
        }

        @Override
        public final Builder operatingAddressCountryCode(String operatingAddressCountryCode) {
            this.operatingAddressCountryCode = operatingAddressCountryCode;
            return this;
        }

        public final String getOperatingAddressStateOrRegion() {
            return operatingAddressStateOrRegion;
        }

        public final void setOperatingAddressStateOrRegion(String operatingAddressStateOrRegion) {
            this.operatingAddressStateOrRegion = operatingAddressStateOrRegion;
        }

        @Override
        public final Builder operatingAddressStateOrRegion(String operatingAddressStateOrRegion) {
            this.operatingAddressStateOrRegion = operatingAddressStateOrRegion;
            return this;
        }

        public final String getOperatingAddressCity() {
            return operatingAddressCity;
        }

        public final void setOperatingAddressCity(String operatingAddressCity) {
            this.operatingAddressCity = operatingAddressCity;
        }

        @Override
        public final Builder operatingAddressCity(String operatingAddressCity) {
            this.operatingAddressCity = operatingAddressCity;
            return this;
        }

        public final RackPhysicalProperties.Builder getRackPhysicalProperties() {
            return rackPhysicalProperties != null ? rackPhysicalProperties.toBuilder() : null;
        }

        public final void setRackPhysicalProperties(RackPhysicalProperties.BuilderImpl rackPhysicalProperties) {
            this.rackPhysicalProperties = rackPhysicalProperties != null ? rackPhysicalProperties.build() : null;
        }

        @Override
        public final Builder rackPhysicalProperties(RackPhysicalProperties rackPhysicalProperties) {
            this.rackPhysicalProperties = rackPhysicalProperties;
            return this;
        }

        @Override
        public Site build() {
            return new Site(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
