/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCapacityTaskRequest extends OutpostsRequest implements
        ToCopyableBuilder<StartCapacityTaskRequest.Builder, StartCapacityTaskRequest> {
    private static final SdkField<String> OUTPOST_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostIdentifier").getter(getter(StartCapacityTaskRequest::outpostIdentifier))
            .setter(setter(Builder::outpostIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("OutpostId").build()).build();

    private static final SdkField<String> ORDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrderId").getter(getter(StartCapacityTaskRequest::orderId)).setter(setter(Builder::orderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderId").build()).build();

    private static final SdkField<List<InstanceTypeCapacity>> INSTANCE_POOLS_FIELD = SdkField
            .<List<InstanceTypeCapacity>> builder(MarshallingType.LIST)
            .memberName("InstancePools")
            .getter(getter(StartCapacityTaskRequest::instancePools))
            .setter(setter(Builder::instancePools))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceTypeCapacity> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceTypeCapacity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InstancesToExclude> INSTANCES_TO_EXCLUDE_FIELD = SdkField
            .<InstancesToExclude> builder(MarshallingType.SDK_POJO).memberName("InstancesToExclude")
            .getter(getter(StartCapacityTaskRequest::instancesToExclude)).setter(setter(Builder::instancesToExclude))
            .constructor(InstancesToExclude::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesToExclude").build())
            .build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(StartCapacityTaskRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final SdkField<String> TASK_ACTION_ON_BLOCKING_INSTANCES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TaskActionOnBlockingInstances")
            .getter(getter(StartCapacityTaskRequest::taskActionOnBlockingInstancesAsString))
            .setter(setter(Builder::taskActionOnBlockingInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskActionOnBlockingInstances")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_IDENTIFIER_FIELD,
            ORDER_ID_FIELD, INSTANCE_POOLS_FIELD, INSTANCES_TO_EXCLUDE_FIELD, DRY_RUN_FIELD,
            TASK_ACTION_ON_BLOCKING_INSTANCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String outpostIdentifier;

    private final String orderId;

    private final List<InstanceTypeCapacity> instancePools;

    private final InstancesToExclude instancesToExclude;

    private final Boolean dryRun;

    private final String taskActionOnBlockingInstances;

    private StartCapacityTaskRequest(BuilderImpl builder) {
        super(builder);
        this.outpostIdentifier = builder.outpostIdentifier;
        this.orderId = builder.orderId;
        this.instancePools = builder.instancePools;
        this.instancesToExclude = builder.instancesToExclude;
        this.dryRun = builder.dryRun;
        this.taskActionOnBlockingInstances = builder.taskActionOnBlockingInstances;
    }

    /**
     * <p>
     * The ID or ARN of the Outposts associated with the specified capacity task.
     * </p>
     * 
     * @return The ID or ARN of the Outposts associated with the specified capacity task.
     */
    public final String outpostIdentifier() {
        return outpostIdentifier;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Outposts order associated with the specified capacity task.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Outposts order associated with the specified capacity task.
     */
    public final String orderId() {
        return orderId;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstancePools property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstancePools() {
        return instancePools != null && !(instancePools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance pools specified in the capacity task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstancePools} method.
     * </p>
     * 
     * @return The instance pools specified in the capacity task.
     */
    public final List<InstanceTypeCapacity> instancePools() {
        return instancePools;
    }

    /**
     * <p>
     * List of user-specified running instances that must not be stopped in order to free up the capacity needed to run
     * the capacity task.
     * </p>
     * 
     * @return List of user-specified running instances that must not be stopped in order to free up the capacity needed
     *         to run the capacity task.
     */
    public final InstancesToExclude instancesToExclude() {
        return instancesToExclude;
    }

    /**
     * <p>
     * You can request a dry run to determine if the instance type and instance size changes is above or below available
     * instance capacity. Requesting a dry run does not make any changes to your plan.
     * </p>
     * 
     * @return You can request a dry run to determine if the instance type and instance size changes is above or below
     *         available instance capacity. Requesting a dry run does not make any changes to your plan.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * Specify one of the following options in case an instance is blocking the capacity task from running.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>WAIT_FOR_EVACUATION</code> - Checks every 10 minutes over 48 hours to determine if instances have stopped
     * and capacity is available to complete the task.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAIL_TASK</code> - The capacity task fails.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #taskActionOnBlockingInstances} will return {@link TaskActionOnBlockingInstances#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #taskActionOnBlockingInstancesAsString}.
     * </p>
     * 
     * @return Specify one of the following options in case an instance is blocking the capacity task from running.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>WAIT_FOR_EVACUATION</code> - Checks every 10 minutes over 48 hours to determine if instances have
     *         stopped and capacity is available to complete the task.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAIL_TASK</code> - The capacity task fails.
     *         </p>
     *         </li>
     * @see TaskActionOnBlockingInstances
     */
    public final TaskActionOnBlockingInstances taskActionOnBlockingInstances() {
        return TaskActionOnBlockingInstances.fromValue(taskActionOnBlockingInstances);
    }

    /**
     * <p>
     * Specify one of the following options in case an instance is blocking the capacity task from running.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>WAIT_FOR_EVACUATION</code> - Checks every 10 minutes over 48 hours to determine if instances have stopped
     * and capacity is available to complete the task.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAIL_TASK</code> - The capacity task fails.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #taskActionOnBlockingInstances} will return {@link TaskActionOnBlockingInstances#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #taskActionOnBlockingInstancesAsString}.
     * </p>
     * 
     * @return Specify one of the following options in case an instance is blocking the capacity task from running.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>WAIT_FOR_EVACUATION</code> - Checks every 10 minutes over 48 hours to determine if instances have
     *         stopped and capacity is available to complete the task.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAIL_TASK</code> - The capacity task fails.
     *         </p>
     *         </li>
     * @see TaskActionOnBlockingInstances
     */
    public final String taskActionOnBlockingInstancesAsString() {
        return taskActionOnBlockingInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(outpostIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(orderId());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstancePools() ? instancePools() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instancesToExclude());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(taskActionOnBlockingInstancesAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCapacityTaskRequest)) {
            return false;
        }
        StartCapacityTaskRequest other = (StartCapacityTaskRequest) obj;
        return Objects.equals(outpostIdentifier(), other.outpostIdentifier()) && Objects.equals(orderId(), other.orderId())
                && hasInstancePools() == other.hasInstancePools() && Objects.equals(instancePools(), other.instancePools())
                && Objects.equals(instancesToExclude(), other.instancesToExclude()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(taskActionOnBlockingInstancesAsString(), other.taskActionOnBlockingInstancesAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCapacityTaskRequest").add("OutpostIdentifier", outpostIdentifier())
                .add("OrderId", orderId()).add("InstancePools", hasInstancePools() ? instancePools() : null)
                .add("InstancesToExclude", instancesToExclude()).add("DryRun", dryRun())
                .add("TaskActionOnBlockingInstances", taskActionOnBlockingInstancesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostIdentifier":
            return Optional.ofNullable(clazz.cast(outpostIdentifier()));
        case "OrderId":
            return Optional.ofNullable(clazz.cast(orderId()));
        case "InstancePools":
            return Optional.ofNullable(clazz.cast(instancePools()));
        case "InstancesToExclude":
            return Optional.ofNullable(clazz.cast(instancesToExclude()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "TaskActionOnBlockingInstances":
            return Optional.ofNullable(clazz.cast(taskActionOnBlockingInstancesAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutpostId", OUTPOST_IDENTIFIER_FIELD);
        map.put("OrderId", ORDER_ID_FIELD);
        map.put("InstancePools", INSTANCE_POOLS_FIELD);
        map.put("InstancesToExclude", INSTANCES_TO_EXCLUDE_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("TaskActionOnBlockingInstances", TASK_ACTION_ON_BLOCKING_INSTANCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCapacityTaskRequest, T> g) {
        return obj -> g.apply((StartCapacityTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartCapacityTaskRequest> {
        /**
         * <p>
         * The ID or ARN of the Outposts associated with the specified capacity task.
         * </p>
         * 
         * @param outpostIdentifier
         *        The ID or ARN of the Outposts associated with the specified capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostIdentifier(String outpostIdentifier);

        /**
         * <p>
         * The ID of the Amazon Web Services Outposts order associated with the specified capacity task.
         * </p>
         * 
         * @param orderId
         *        The ID of the Amazon Web Services Outposts order associated with the specified capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderId(String orderId);

        /**
         * <p>
         * The instance pools specified in the capacity task.
         * </p>
         * 
         * @param instancePools
         *        The instance pools specified in the capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePools(Collection<InstanceTypeCapacity> instancePools);

        /**
         * <p>
         * The instance pools specified in the capacity task.
         * </p>
         * 
         * @param instancePools
         *        The instance pools specified in the capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancePools(InstanceTypeCapacity... instancePools);

        /**
         * <p>
         * The instance pools specified in the capacity task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.outposts.model.InstanceTypeCapacity.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.outposts.model.InstanceTypeCapacity#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.outposts.model.InstanceTypeCapacity.Builder#build()} is called
         * immediately and its result is passed to {@link #instancePools(List<InstanceTypeCapacity>)}.
         * 
         * @param instancePools
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.outposts.model.InstanceTypeCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instancePools(java.util.Collection<InstanceTypeCapacity>)
         */
        Builder instancePools(Consumer<InstanceTypeCapacity.Builder>... instancePools);

        /**
         * <p>
         * List of user-specified running instances that must not be stopped in order to free up the capacity needed to
         * run the capacity task.
         * </p>
         * 
         * @param instancesToExclude
         *        List of user-specified running instances that must not be stopped in order to free up the capacity
         *        needed to run the capacity task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instancesToExclude(InstancesToExclude instancesToExclude);

        /**
         * <p>
         * List of user-specified running instances that must not be stopped in order to free up the capacity needed to
         * run the capacity task.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstancesToExclude.Builder} avoiding the
         * need to create one manually via {@link InstancesToExclude#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstancesToExclude.Builder#build()} is called immediately and its
         * result is passed to {@link #instancesToExclude(InstancesToExclude)}.
         * 
         * @param instancesToExclude
         *        a consumer that will call methods on {@link InstancesToExclude.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instancesToExclude(InstancesToExclude)
         */
        default Builder instancesToExclude(Consumer<InstancesToExclude.Builder> instancesToExclude) {
            return instancesToExclude(InstancesToExclude.builder().applyMutation(instancesToExclude).build());
        }

        /**
         * <p>
         * You can request a dry run to determine if the instance type and instance size changes is above or below
         * available instance capacity. Requesting a dry run does not make any changes to your plan.
         * </p>
         * 
         * @param dryRun
         *        You can request a dry run to determine if the instance type and instance size changes is above or
         *        below available instance capacity. Requesting a dry run does not make any changes to your plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * Specify one of the following options in case an instance is blocking the capacity task from running.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>WAIT_FOR_EVACUATION</code> - Checks every 10 minutes over 48 hours to determine if instances have
         * stopped and capacity is available to complete the task.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAIL_TASK</code> - The capacity task fails.
         * </p>
         * </li>
         * </ul>
         * 
         * @param taskActionOnBlockingInstances
         *        Specify one of the following options in case an instance is blocking the capacity task from
         *        running.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>WAIT_FOR_EVACUATION</code> - Checks every 10 minutes over 48 hours to determine if instances
         *        have stopped and capacity is available to complete the task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAIL_TASK</code> - The capacity task fails.
         *        </p>
         *        </li>
         * @see TaskActionOnBlockingInstances
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskActionOnBlockingInstances
         */
        Builder taskActionOnBlockingInstances(String taskActionOnBlockingInstances);

        /**
         * <p>
         * Specify one of the following options in case an instance is blocking the capacity task from running.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>WAIT_FOR_EVACUATION</code> - Checks every 10 minutes over 48 hours to determine if instances have
         * stopped and capacity is available to complete the task.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAIL_TASK</code> - The capacity task fails.
         * </p>
         * </li>
         * </ul>
         * 
         * @param taskActionOnBlockingInstances
         *        Specify one of the following options in case an instance is blocking the capacity task from
         *        running.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>WAIT_FOR_EVACUATION</code> - Checks every 10 minutes over 48 hours to determine if instances
         *        have stopped and capacity is available to complete the task.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAIL_TASK</code> - The capacity task fails.
         *        </p>
         *        </li>
         * @see TaskActionOnBlockingInstances
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskActionOnBlockingInstances
         */
        Builder taskActionOnBlockingInstances(TaskActionOnBlockingInstances taskActionOnBlockingInstances);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String outpostIdentifier;

        private String orderId;

        private List<InstanceTypeCapacity> instancePools = DefaultSdkAutoConstructList.getInstance();

        private InstancesToExclude instancesToExclude;

        private Boolean dryRun;

        private String taskActionOnBlockingInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCapacityTaskRequest model) {
            super(model);
            outpostIdentifier(model.outpostIdentifier);
            orderId(model.orderId);
            instancePools(model.instancePools);
            instancesToExclude(model.instancesToExclude);
            dryRun(model.dryRun);
            taskActionOnBlockingInstances(model.taskActionOnBlockingInstances);
        }

        public final String getOutpostIdentifier() {
            return outpostIdentifier;
        }

        public final void setOutpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
        }

        @Override
        public final Builder outpostIdentifier(String outpostIdentifier) {
            this.outpostIdentifier = outpostIdentifier;
            return this;
        }

        public final String getOrderId() {
            return orderId;
        }

        public final void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        @Override
        public final Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public final List<InstanceTypeCapacity.Builder> getInstancePools() {
            List<InstanceTypeCapacity.Builder> result = RequestedInstancePoolsCopier.copyToBuilder(this.instancePools);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstancePools(Collection<InstanceTypeCapacity.BuilderImpl> instancePools) {
            this.instancePools = RequestedInstancePoolsCopier.copyFromBuilder(instancePools);
        }

        @Override
        public final Builder instancePools(Collection<InstanceTypeCapacity> instancePools) {
            this.instancePools = RequestedInstancePoolsCopier.copy(instancePools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancePools(InstanceTypeCapacity... instancePools) {
            instancePools(Arrays.asList(instancePools));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancePools(Consumer<InstanceTypeCapacity.Builder>... instancePools) {
            instancePools(Stream.of(instancePools).map(c -> InstanceTypeCapacity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InstancesToExclude.Builder getInstancesToExclude() {
            return instancesToExclude != null ? instancesToExclude.toBuilder() : null;
        }

        public final void setInstancesToExclude(InstancesToExclude.BuilderImpl instancesToExclude) {
            this.instancesToExclude = instancesToExclude != null ? instancesToExclude.build() : null;
        }

        @Override
        public final Builder instancesToExclude(InstancesToExclude instancesToExclude) {
            this.instancesToExclude = instancesToExclude;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getTaskActionOnBlockingInstances() {
            return taskActionOnBlockingInstances;
        }

        public final void setTaskActionOnBlockingInstances(String taskActionOnBlockingInstances) {
            this.taskActionOnBlockingInstances = taskActionOnBlockingInstances;
        }

        @Override
        public final Builder taskActionOnBlockingInstances(String taskActionOnBlockingInstances) {
            this.taskActionOnBlockingInstances = taskActionOnBlockingInstances;
            return this;
        }

        @Override
        public final Builder taskActionOnBlockingInstances(TaskActionOnBlockingInstances taskActionOnBlockingInstances) {
            this.taskActionOnBlockingInstances(taskActionOnBlockingInstances == null ? null : taskActionOnBlockingInstances
                    .toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCapacityTaskRequest build() {
            return new StartCapacityTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
