/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOutpostRequest extends OutpostsRequest implements
        ToCopyableBuilder<UpdateOutpostRequest.Builder, UpdateOutpostRequest> {
    private static final SdkField<String> OUTPOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutpostId").getter(getter(UpdateOutpostRequest::outpostId)).setter(setter(Builder::outpostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("OutpostId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateOutpostRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateOutpostRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SUPPORTED_HARDWARE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportedHardwareType").getter(getter(UpdateOutpostRequest::supportedHardwareTypeAsString))
            .setter(setter(Builder::supportedHardwareType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedHardwareType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPOST_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, SUPPORTED_HARDWARE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String outpostId;

    private final String name;

    private final String description;

    private final String supportedHardwareType;

    private UpdateOutpostRequest(BuilderImpl builder) {
        super(builder);
        this.outpostId = builder.outpostId;
        this.name = builder.name;
        this.description = builder.description;
        this.supportedHardwareType = builder.supportedHardwareType;
    }

    /**
     * <p>
     * The ID or ARN of the Outpost.
     * </p>
     * 
     * @return The ID or ARN of the Outpost.
     */
    public final String outpostId() {
        return outpostId;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of hardware for this Outpost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #supportedHardwareType} will return {@link SupportedHardwareType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #supportedHardwareTypeAsString}.
     * </p>
     * 
     * @return The type of hardware for this Outpost.
     * @see SupportedHardwareType
     */
    public final SupportedHardwareType supportedHardwareType() {
        return SupportedHardwareType.fromValue(supportedHardwareType);
    }

    /**
     * <p>
     * The type of hardware for this Outpost.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #supportedHardwareType} will return {@link SupportedHardwareType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #supportedHardwareTypeAsString}.
     * </p>
     * 
     * @return The type of hardware for this Outpost.
     * @see SupportedHardwareType
     */
    public final String supportedHardwareTypeAsString() {
        return supportedHardwareType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(outpostId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(supportedHardwareTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOutpostRequest)) {
            return false;
        }
        UpdateOutpostRequest other = (UpdateOutpostRequest) obj;
        return Objects.equals(outpostId(), other.outpostId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(supportedHardwareTypeAsString(), other.supportedHardwareTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateOutpostRequest").add("OutpostId", outpostId()).add("Name", name())
                .add("Description", description()).add("SupportedHardwareType", supportedHardwareTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutpostId":
            return Optional.ofNullable(clazz.cast(outpostId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SupportedHardwareType":
            return Optional.ofNullable(clazz.cast(supportedHardwareTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OutpostId", OUTPOST_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SupportedHardwareType", SUPPORTED_HARDWARE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOutpostRequest, T> g) {
        return obj -> g.apply((UpdateOutpostRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OutpostsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateOutpostRequest> {
        /**
         * <p>
         * The ID or ARN of the Outpost.
         * </p>
         * 
         * @param outpostId
         *        The ID or ARN of the Outpost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outpostId(String outpostId);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of hardware for this Outpost.
         * </p>
         * 
         * @param supportedHardwareType
         *        The type of hardware for this Outpost.
         * @see SupportedHardwareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedHardwareType
         */
        Builder supportedHardwareType(String supportedHardwareType);

        /**
         * <p>
         * The type of hardware for this Outpost.
         * </p>
         * 
         * @param supportedHardwareType
         *        The type of hardware for this Outpost.
         * @see SupportedHardwareType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedHardwareType
         */
        Builder supportedHardwareType(SupportedHardwareType supportedHardwareType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OutpostsRequest.BuilderImpl implements Builder {
        private String outpostId;

        private String name;

        private String description;

        private String supportedHardwareType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOutpostRequest model) {
            super(model);
            outpostId(model.outpostId);
            name(model.name);
            description(model.description);
            supportedHardwareType(model.supportedHardwareType);
        }

        public final String getOutpostId() {
            return outpostId;
        }

        public final void setOutpostId(String outpostId) {
            this.outpostId = outpostId;
        }

        @Override
        public final Builder outpostId(String outpostId) {
            this.outpostId = outpostId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSupportedHardwareType() {
            return supportedHardwareType;
        }

        public final void setSupportedHardwareType(String supportedHardwareType) {
            this.supportedHardwareType = supportedHardwareType;
        }

        @Override
        public final Builder supportedHardwareType(String supportedHardwareType) {
            this.supportedHardwareType = supportedHardwareType;
            return this;
        }

        @Override
        public final Builder supportedHardwareType(SupportedHardwareType supportedHardwareType) {
            this.supportedHardwareType(supportedHardwareType == null ? null : supportedHardwareType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOutpostRequest build() {
            return new UpdateOutpostRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
