/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PowerConnector {
    L6_30_P("L6_30P"),
    IEC309("IEC309"),
    AH530_P7_W("AH530P7W"),
    AH532_P6_W("AH532P6W"),
    CS8365_C("CS8365C"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PowerConnector> VALUE_MAP;
    private final String value;

    private PowerConnector(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PowerConnector fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PowerConnector> knownValues() {
        EnumSet<PowerConnector> knownValues = EnumSet.allOf(PowerConnector.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PowerConnector.class, PowerConnector::toString);
    }
}

