/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A job's configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceJobConfig implements SdkPojo, Serializable, ToCopyableBuilder<DeviceJobConfig.Builder, DeviceJobConfig> {
    private static final SdkField<OTAJobConfig> OTA_JOB_CONFIG_FIELD = SdkField.<OTAJobConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OTAJobConfig").getter(getter(DeviceJobConfig::otaJobConfig)).setter(setter(Builder::otaJobConfig))
            .constructor(OTAJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OTAJobConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTA_JOB_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OTAJobConfig otaJobConfig;

    private DeviceJobConfig(BuilderImpl builder) {
        this.otaJobConfig = builder.otaJobConfig;
    }

    /**
     * <p>
     * A configuration for an over-the-air (OTA) upgrade. Required for OTA jobs.
     * </p>
     * 
     * @return A configuration for an over-the-air (OTA) upgrade. Required for OTA jobs.
     */
    public final OTAJobConfig otaJobConfig() {
        return otaJobConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(otaJobConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceJobConfig)) {
            return false;
        }
        DeviceJobConfig other = (DeviceJobConfig) obj;
        return Objects.equals(otaJobConfig(), other.otaJobConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceJobConfig").add("OTAJobConfig", otaJobConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OTAJobConfig":
            return Optional.ofNullable(clazz.cast(otaJobConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OTAJobConfig", OTA_JOB_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceJobConfig, T> g) {
        return obj -> g.apply((DeviceJobConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceJobConfig> {
        /**
         * <p>
         * A configuration for an over-the-air (OTA) upgrade. Required for OTA jobs.
         * </p>
         * 
         * @param otaJobConfig
         *        A configuration for an over-the-air (OTA) upgrade. Required for OTA jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaJobConfig(OTAJobConfig otaJobConfig);

        /**
         * <p>
         * A configuration for an over-the-air (OTA) upgrade. Required for OTA jobs.
         * </p>
         * This is a convenience method that creates an instance of the {@link OTAJobConfig.Builder} avoiding the need
         * to create one manually via {@link OTAJobConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OTAJobConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #otaJobConfig(OTAJobConfig)}.
         * 
         * @param otaJobConfig
         *        a consumer that will call methods on {@link OTAJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #otaJobConfig(OTAJobConfig)
         */
        default Builder otaJobConfig(Consumer<OTAJobConfig.Builder> otaJobConfig) {
            return otaJobConfig(OTAJobConfig.builder().applyMutation(otaJobConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OTAJobConfig otaJobConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceJobConfig model) {
            otaJobConfig(model.otaJobConfig);
        }

        public final OTAJobConfig.Builder getOtaJobConfig() {
            return otaJobConfig != null ? otaJobConfig.toBuilder() : null;
        }

        public final void setOtaJobConfig(OTAJobConfig.BuilderImpl otaJobConfig) {
            this.otaJobConfig = otaJobConfig != null ? otaJobConfig.build() : null;
        }

        @Override
        public final Builder otaJobConfig(OTAJobConfig otaJobConfig) {
            this.otaJobConfig = otaJobConfig;
            return this;
        }

        @Override
        public DeviceJobConfig build() {
            return new DeviceJobConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
