/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDevicesRequest extends PanoramaRequest implements
        ToCopyableBuilder<ListDevicesRequest.Builder, ListDevicesRequest> {
    private static final SdkField<String> DEVICE_AGGREGATED_STATUS_FILTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeviceAggregatedStatusFilter")
            .getter(getter(ListDevicesRequest::deviceAggregatedStatusFilterAsString))
            .setter(setter(Builder::deviceAggregatedStatusFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DeviceAggregatedStatusFilter")
                    .build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListDevicesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NAME_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameFilter").getter(getter(ListDevicesRequest::nameFilter)).setter(setter(Builder::nameFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NameFilter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDevicesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListDevicesRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListDevicesRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEVICE_AGGREGATED_STATUS_FILTER_FIELD, MAX_RESULTS_FIELD, NAME_FILTER_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD,
            SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String deviceAggregatedStatusFilter;

    private final Integer maxResults;

    private final String nameFilter;

    private final String nextToken;

    private final String sortBy;

    private final String sortOrder;

    private ListDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.deviceAggregatedStatusFilter = builder.deviceAggregatedStatusFilter;
        this.maxResults = builder.maxResults;
        this.nameFilter = builder.nameFilter;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * Filter based on a device's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceAggregatedStatusFilter} will return {@link DeviceAggregatedStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceAggregatedStatusFilterAsString}.
     * </p>
     * 
     * @return Filter based on a device's status.
     * @see DeviceAggregatedStatus
     */
    public final DeviceAggregatedStatus deviceAggregatedStatusFilter() {
        return DeviceAggregatedStatus.fromValue(deviceAggregatedStatusFilter);
    }

    /**
     * <p>
     * Filter based on a device's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceAggregatedStatusFilter} will return {@link DeviceAggregatedStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceAggregatedStatusFilterAsString}.
     * </p>
     * 
     * @return Filter based on a device's status.
     * @see DeviceAggregatedStatus
     */
    public final String deviceAggregatedStatusFilterAsString() {
        return deviceAggregatedStatusFilter;
    }

    /**
     * <p>
     * The maximum number of devices to return in one page of results.
     * </p>
     * 
     * @return The maximum number of devices to return in one page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filter based on device's name. Prefixes supported.
     * </p>
     * 
     * @return Filter based on device's name. Prefixes supported.
     */
    public final String nameFilter() {
        return nameFilter;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The target column to be sorted on. Default column sort is CREATED_TIME.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListDevicesSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The target column to be sorted on. Default column sort is CREATED_TIME.
     * @see ListDevicesSortBy
     */
    public final ListDevicesSortBy sortBy() {
        return ListDevicesSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The target column to be sorted on. Default column sort is CREATED_TIME.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListDevicesSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The target column to be sorted on. Default column sort is CREATED_TIME.
     * @see ListDevicesSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sorting order for the returned list. SortOrder is DESCENDING by default based on CREATED_TIME. Otherwise,
     * SortOrder is ASCENDING.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sorting order for the returned list. SortOrder is DESCENDING by default based on CREATED_TIME.
     *         Otherwise, SortOrder is ASCENDING.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sorting order for the returned list. SortOrder is DESCENDING by default based on CREATED_TIME. Otherwise,
     * SortOrder is ASCENDING.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sorting order for the returned list. SortOrder is DESCENDING by default based on CREATED_TIME.
     *         Otherwise, SortOrder is ASCENDING.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceAggregatedStatusFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nameFilter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesRequest)) {
            return false;
        }
        ListDevicesRequest other = (ListDevicesRequest) obj;
        return Objects.equals(deviceAggregatedStatusFilterAsString(), other.deviceAggregatedStatusFilterAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nameFilter(), other.nameFilter())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDevicesRequest").add("DeviceAggregatedStatusFilter", deviceAggregatedStatusFilterAsString())
                .add("MaxResults", maxResults()).add("NameFilter", nameFilter()).add("NextToken", nextToken())
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceAggregatedStatusFilter":
            return Optional.ofNullable(clazz.cast(deviceAggregatedStatusFilterAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NameFilter":
            return Optional.ofNullable(clazz.cast(nameFilter()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeviceAggregatedStatusFilter", DEVICE_AGGREGATED_STATUS_FILTER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NameFilter", NAME_FILTER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDevicesRequest, T> g) {
        return obj -> g.apply((ListDevicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDevicesRequest> {
        /**
         * <p>
         * Filter based on a device's status.
         * </p>
         * 
         * @param deviceAggregatedStatusFilter
         *        Filter based on a device's status.
         * @see DeviceAggregatedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAggregatedStatus
         */
        Builder deviceAggregatedStatusFilter(String deviceAggregatedStatusFilter);

        /**
         * <p>
         * Filter based on a device's status.
         * </p>
         * 
         * @param deviceAggregatedStatusFilter
         *        Filter based on a device's status.
         * @see DeviceAggregatedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAggregatedStatus
         */
        Builder deviceAggregatedStatusFilter(DeviceAggregatedStatus deviceAggregatedStatusFilter);

        /**
         * <p>
         * The maximum number of devices to return in one page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of devices to return in one page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filter based on device's name. Prefixes supported.
         * </p>
         * 
         * @param nameFilter
         *        Filter based on device's name. Prefixes supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameFilter(String nameFilter);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The target column to be sorted on. Default column sort is CREATED_TIME.
         * </p>
         * 
         * @param sortBy
         *        The target column to be sorted on. Default column sort is CREATED_TIME.
         * @see ListDevicesSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListDevicesSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The target column to be sorted on. Default column sort is CREATED_TIME.
         * </p>
         * 
         * @param sortBy
         *        The target column to be sorted on. Default column sort is CREATED_TIME.
         * @see ListDevicesSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListDevicesSortBy
         */
        Builder sortBy(ListDevicesSortBy sortBy);

        /**
         * <p>
         * The sorting order for the returned list. SortOrder is DESCENDING by default based on CREATED_TIME. Otherwise,
         * SortOrder is ASCENDING.
         * </p>
         * 
         * @param sortOrder
         *        The sorting order for the returned list. SortOrder is DESCENDING by default based on CREATED_TIME.
         *        Otherwise, SortOrder is ASCENDING.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sorting order for the returned list. SortOrder is DESCENDING by default based on CREATED_TIME. Otherwise,
         * SortOrder is ASCENDING.
         * </p>
         * 
         * @param sortOrder
         *        The sorting order for the returned list. SortOrder is DESCENDING by default based on CREATED_TIME.
         *        Otherwise, SortOrder is ASCENDING.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PanoramaRequest.BuilderImpl implements Builder {
        private String deviceAggregatedStatusFilter;

        private Integer maxResults;

        private String nameFilter;

        private String nextToken;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesRequest model) {
            super(model);
            deviceAggregatedStatusFilter(model.deviceAggregatedStatusFilter);
            maxResults(model.maxResults);
            nameFilter(model.nameFilter);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final String getDeviceAggregatedStatusFilter() {
            return deviceAggregatedStatusFilter;
        }

        public final void setDeviceAggregatedStatusFilter(String deviceAggregatedStatusFilter) {
            this.deviceAggregatedStatusFilter = deviceAggregatedStatusFilter;
        }

        @Override
        public final Builder deviceAggregatedStatusFilter(String deviceAggregatedStatusFilter) {
            this.deviceAggregatedStatusFilter = deviceAggregatedStatusFilter;
            return this;
        }

        @Override
        public final Builder deviceAggregatedStatusFilter(DeviceAggregatedStatus deviceAggregatedStatusFilter) {
            this.deviceAggregatedStatusFilter(deviceAggregatedStatusFilter == null ? null : deviceAggregatedStatusFilter
                    .toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNameFilter() {
            return nameFilter;
        }

        public final void setNameFilter(String nameFilter) {
            this.nameFilter = nameFilter;
        }

        @Override
        public final Builder nameFilter(String nameFilter) {
            this.nameFilter = nameFilter;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ListDevicesSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDevicesRequest build() {
            return new ListDevicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
