/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNodesRequest extends PanoramaRequest implements
        ToCopyableBuilder<ListNodesRequest.Builder, ListNodesRequest> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(ListNodesRequest::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("category").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListNodesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListNodesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccount").getter(getter(ListNodesRequest::ownerAccount)).setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ownerAccount").build()).build();

    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageName").getter(getter(ListNodesRequest::packageName)).setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("packageName").build()).build();

    private static final SdkField<String> PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageVersion").getter(getter(ListNodesRequest::packageVersion))
            .setter(setter(Builder::packageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("packageVersion").build())
            .build();

    private static final SdkField<String> PATCH_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatchVersion").getter(getter(ListNodesRequest::patchVersion)).setter(setter(Builder::patchVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("patchVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OWNER_ACCOUNT_FIELD, PACKAGE_NAME_FIELD, PACKAGE_VERSION_FIELD,
            PATCH_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String category;

    private final Integer maxResults;

    private final String nextToken;

    private final String ownerAccount;

    private final String packageName;

    private final String packageVersion;

    private final String patchVersion;

    private ListNodesRequest(BuilderImpl builder) {
        super(builder);
        this.category = builder.category;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.ownerAccount = builder.ownerAccount;
        this.packageName = builder.packageName;
        this.packageVersion = builder.packageVersion;
        this.patchVersion = builder.patchVersion;
    }

    /**
     * <p>
     * Search for nodes by category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link NodeCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return Search for nodes by category.
     * @see NodeCategory
     */
    public final NodeCategory category() {
        return NodeCategory.fromValue(category);
    }

    /**
     * <p>
     * Search for nodes by category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link NodeCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #categoryAsString}.
     * </p>
     * 
     * @return Search for nodes by category.
     * @see NodeCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * The maximum number of nodes to return in one page of results.
     * </p>
     * 
     * @return The maximum number of nodes to return in one page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Search for nodes by the account ID of the nodes' owner.
     * </p>
     * 
     * @return Search for nodes by the account ID of the nodes' owner.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * Search for nodes by name.
     * </p>
     * 
     * @return Search for nodes by name.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * Search for nodes by version.
     * </p>
     * 
     * @return Search for nodes by version.
     */
    public final String packageVersion() {
        return packageVersion;
    }

    /**
     * <p>
     * Search for nodes by patch version.
     * </p>
     * 
     * @return Search for nodes by patch version.
     */
    public final String patchVersion() {
        return patchVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(packageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(patchVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNodesRequest)) {
            return false;
        }
        ListNodesRequest other = (ListNodesRequest) obj;
        return Objects.equals(categoryAsString(), other.categoryAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(ownerAccount(), other.ownerAccount())
                && Objects.equals(packageName(), other.packageName()) && Objects.equals(packageVersion(), other.packageVersion())
                && Objects.equals(patchVersion(), other.patchVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNodesRequest").add("Category", categoryAsString()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("OwnerAccount", ownerAccount()).add("PackageName", packageName())
                .add("PackageVersion", packageVersion()).add("PatchVersion", patchVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "OwnerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "PackageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "PackageVersion":
            return Optional.ofNullable(clazz.cast(packageVersion()));
        case "PatchVersion":
            return Optional.ofNullable(clazz.cast(patchVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("category", CATEGORY_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("ownerAccount", OWNER_ACCOUNT_FIELD);
        map.put("packageName", PACKAGE_NAME_FIELD);
        map.put("packageVersion", PACKAGE_VERSION_FIELD);
        map.put("patchVersion", PATCH_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNodesRequest, T> g) {
        return obj -> g.apply((ListNodesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListNodesRequest> {
        /**
         * <p>
         * Search for nodes by category.
         * </p>
         * 
         * @param category
         *        Search for nodes by category.
         * @see NodeCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeCategory
         */
        Builder category(String category);

        /**
         * <p>
         * Search for nodes by category.
         * </p>
         * 
         * @param category
         *        Search for nodes by category.
         * @see NodeCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeCategory
         */
        Builder category(NodeCategory category);

        /**
         * <p>
         * The maximum number of nodes to return in one page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of nodes to return in one page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Search for nodes by the account ID of the nodes' owner.
         * </p>
         * 
         * @param ownerAccount
         *        Search for nodes by the account ID of the nodes' owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * Search for nodes by name.
         * </p>
         * 
         * @param packageName
         *        Search for nodes by name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * Search for nodes by version.
         * </p>
         * 
         * @param packageVersion
         *        Search for nodes by version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersion(String packageVersion);

        /**
         * <p>
         * Search for nodes by patch version.
         * </p>
         * 
         * @param patchVersion
         *        Search for nodes by patch version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchVersion(String patchVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PanoramaRequest.BuilderImpl implements Builder {
        private String category;

        private Integer maxResults;

        private String nextToken;

        private String ownerAccount;

        private String packageName;

        private String packageVersion;

        private String patchVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNodesRequest model) {
            super(model);
            category(model.category);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            ownerAccount(model.ownerAccount);
            packageName(model.packageName);
            packageVersion(model.packageVersion);
            patchVersion(model.patchVersion);
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(NodeCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageVersion() {
            return packageVersion;
        }

        public final void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        @Override
        public final Builder packageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        public final String getPatchVersion() {
            return patchVersion;
        }

        public final void setPatchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
        }

        @Override
        public final Builder patchVersion(String patchVersion) {
            this.patchVersion = patchVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNodesRequest build() {
            return new ListNodesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
