/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The network status of a device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkStatus implements SdkPojo, Serializable, ToCopyableBuilder<NetworkStatus.Builder, NetworkStatus> {
    private static final SdkField<EthernetStatus> ETHERNET0_STATUS_FIELD = SdkField
            .<EthernetStatus> builder(MarshallingType.SDK_POJO).memberName("Ethernet0Status")
            .getter(getter(NetworkStatus::ethernet0Status)).setter(setter(Builder::ethernet0Status))
            .constructor(EthernetStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ethernet0Status").build()).build();

    private static final SdkField<EthernetStatus> ETHERNET1_STATUS_FIELD = SdkField
            .<EthernetStatus> builder(MarshallingType.SDK_POJO).memberName("Ethernet1Status")
            .getter(getter(NetworkStatus::ethernet1Status)).setter(setter(Builder::ethernet1Status))
            .constructor(EthernetStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ethernet1Status").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(NetworkStatus::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<NtpStatus> NTP_STATUS_FIELD = SdkField.<NtpStatus> builder(MarshallingType.SDK_POJO)
            .memberName("NtpStatus").getter(getter(NetworkStatus::ntpStatus)).setter(setter(Builder::ntpStatus))
            .constructor(NtpStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NtpStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ETHERNET0_STATUS_FIELD,
            ETHERNET1_STATUS_FIELD, LAST_UPDATED_TIME_FIELD, NTP_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EthernetStatus ethernet0Status;

    private final EthernetStatus ethernet1Status;

    private final Instant lastUpdatedTime;

    private final NtpStatus ntpStatus;

    private NetworkStatus(BuilderImpl builder) {
        this.ethernet0Status = builder.ethernet0Status;
        this.ethernet1Status = builder.ethernet1Status;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.ntpStatus = builder.ntpStatus;
    }

    /**
     * <p>
     * The status of Ethernet port 0.
     * </p>
     * 
     * @return The status of Ethernet port 0.
     */
    public final EthernetStatus ethernet0Status() {
        return ethernet0Status;
    }

    /**
     * <p>
     * The status of Ethernet port 1.
     * </p>
     * 
     * @return The status of Ethernet port 1.
     */
    public final EthernetStatus ethernet1Status() {
        return ethernet1Status;
    }

    /**
     * <p>
     * When the network status changed.
     * </p>
     * 
     * @return When the network status changed.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Details about a network time protocol (NTP) server connection.
     * </p>
     * 
     * @return Details about a network time protocol (NTP) server connection.
     */
    public final NtpStatus ntpStatus() {
        return ntpStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ethernet0Status());
        hashCode = 31 * hashCode + Objects.hashCode(ethernet1Status());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(ntpStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkStatus)) {
            return false;
        }
        NetworkStatus other = (NetworkStatus) obj;
        return Objects.equals(ethernet0Status(), other.ethernet0Status())
                && Objects.equals(ethernet1Status(), other.ethernet1Status())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(ntpStatus(), other.ntpStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkStatus").add("Ethernet0Status", ethernet0Status())
                .add("Ethernet1Status", ethernet1Status()).add("LastUpdatedTime", lastUpdatedTime())
                .add("NtpStatus", ntpStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ethernet0Status":
            return Optional.ofNullable(clazz.cast(ethernet0Status()));
        case "Ethernet1Status":
            return Optional.ofNullable(clazz.cast(ethernet1Status()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "NtpStatus":
            return Optional.ofNullable(clazz.cast(ntpStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Ethernet0Status", ETHERNET0_STATUS_FIELD);
        map.put("Ethernet1Status", ETHERNET1_STATUS_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("NtpStatus", NTP_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkStatus, T> g) {
        return obj -> g.apply((NetworkStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkStatus> {
        /**
         * <p>
         * The status of Ethernet port 0.
         * </p>
         * 
         * @param ethernet0Status
         *        The status of Ethernet port 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ethernet0Status(EthernetStatus ethernet0Status);

        /**
         * <p>
         * The status of Ethernet port 0.
         * </p>
         * This is a convenience method that creates an instance of the {@link EthernetStatus.Builder} avoiding the need
         * to create one manually via {@link EthernetStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EthernetStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #ethernet0Status(EthernetStatus)}.
         * 
         * @param ethernet0Status
         *        a consumer that will call methods on {@link EthernetStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ethernet0Status(EthernetStatus)
         */
        default Builder ethernet0Status(Consumer<EthernetStatus.Builder> ethernet0Status) {
            return ethernet0Status(EthernetStatus.builder().applyMutation(ethernet0Status).build());
        }

        /**
         * <p>
         * The status of Ethernet port 1.
         * </p>
         * 
         * @param ethernet1Status
         *        The status of Ethernet port 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ethernet1Status(EthernetStatus ethernet1Status);

        /**
         * <p>
         * The status of Ethernet port 1.
         * </p>
         * This is a convenience method that creates an instance of the {@link EthernetStatus.Builder} avoiding the need
         * to create one manually via {@link EthernetStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EthernetStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #ethernet1Status(EthernetStatus)}.
         * 
         * @param ethernet1Status
         *        a consumer that will call methods on {@link EthernetStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ethernet1Status(EthernetStatus)
         */
        default Builder ethernet1Status(Consumer<EthernetStatus.Builder> ethernet1Status) {
            return ethernet1Status(EthernetStatus.builder().applyMutation(ethernet1Status).build());
        }

        /**
         * <p>
         * When the network status changed.
         * </p>
         * 
         * @param lastUpdatedTime
         *        When the network status changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * Details about a network time protocol (NTP) server connection.
         * </p>
         * 
         * @param ntpStatus
         *        Details about a network time protocol (NTP) server connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ntpStatus(NtpStatus ntpStatus);

        /**
         * <p>
         * Details about a network time protocol (NTP) server connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link NtpStatus.Builder} avoiding the need to
         * create one manually via {@link NtpStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NtpStatus.Builder#build()} is called immediately and its result
         * is passed to {@link #ntpStatus(NtpStatus)}.
         * 
         * @param ntpStatus
         *        a consumer that will call methods on {@link NtpStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ntpStatus(NtpStatus)
         */
        default Builder ntpStatus(Consumer<NtpStatus.Builder> ntpStatus) {
            return ntpStatus(NtpStatus.builder().applyMutation(ntpStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EthernetStatus ethernet0Status;

        private EthernetStatus ethernet1Status;

        private Instant lastUpdatedTime;

        private NtpStatus ntpStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkStatus model) {
            ethernet0Status(model.ethernet0Status);
            ethernet1Status(model.ethernet1Status);
            lastUpdatedTime(model.lastUpdatedTime);
            ntpStatus(model.ntpStatus);
        }

        public final EthernetStatus.Builder getEthernet0Status() {
            return ethernet0Status != null ? ethernet0Status.toBuilder() : null;
        }

        public final void setEthernet0Status(EthernetStatus.BuilderImpl ethernet0Status) {
            this.ethernet0Status = ethernet0Status != null ? ethernet0Status.build() : null;
        }

        @Override
        public final Builder ethernet0Status(EthernetStatus ethernet0Status) {
            this.ethernet0Status = ethernet0Status;
            return this;
        }

        public final EthernetStatus.Builder getEthernet1Status() {
            return ethernet1Status != null ? ethernet1Status.toBuilder() : null;
        }

        public final void setEthernet1Status(EthernetStatus.BuilderImpl ethernet1Status) {
            this.ethernet1Status = ethernet1Status != null ? ethernet1Status.build() : null;
        }

        @Override
        public final Builder ethernet1Status(EthernetStatus ethernet1Status) {
            this.ethernet1Status = ethernet1Status;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final NtpStatus.Builder getNtpStatus() {
            return ntpStatus != null ? ntpStatus.toBuilder() : null;
        }

        public final void setNtpStatus(NtpStatus.BuilderImpl ntpStatus) {
            this.ntpStatus = ntpStatus != null ? ntpStatus.build() : null;
        }

        @Override
        public final Builder ntpStatus(NtpStatus ntpStatus) {
            this.ntpStatus = ntpStatus;
            return this;
        }

        @Override
        public NetworkStatus build() {
            return new NetworkStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
