/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A signal to a camera node to start or stop processing video.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeSignal implements SdkPojo, Serializable, ToCopyableBuilder<NodeSignal.Builder, NodeSignal> {
    private static final SdkField<String> NODE_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeInstanceId").getter(getter(NodeSignal::nodeInstanceId)).setter(setter(Builder::nodeInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeInstanceId").build()).build();

    private static final SdkField<String> SIGNAL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Signal")
            .getter(getter(NodeSignal::signalAsString)).setter(setter(Builder::signal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_INSTANCE_ID_FIELD,
            SIGNAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodeInstanceId;

    private final String signal;

    private NodeSignal(BuilderImpl builder) {
        this.nodeInstanceId = builder.nodeInstanceId;
        this.signal = builder.signal;
    }

    /**
     * <p>
     * The camera node's name, from the application manifest.
     * </p>
     * 
     * @return The camera node's name, from the application manifest.
     */
    public final String nodeInstanceId() {
        return nodeInstanceId;
    }

    /**
     * <p>
     * The signal value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signal} will
     * return {@link NodeSignalValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #signalAsString}.
     * </p>
     * 
     * @return The signal value.
     * @see NodeSignalValue
     */
    public final NodeSignalValue signal() {
        return NodeSignalValue.fromValue(signal);
    }

    /**
     * <p>
     * The signal value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signal} will
     * return {@link NodeSignalValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #signalAsString}.
     * </p>
     * 
     * @return The signal value.
     * @see NodeSignalValue
     */
    public final String signalAsString() {
        return signal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(signalAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeSignal)) {
            return false;
        }
        NodeSignal other = (NodeSignal) obj;
        return Objects.equals(nodeInstanceId(), other.nodeInstanceId())
                && Objects.equals(signalAsString(), other.signalAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeSignal").add("NodeInstanceId", nodeInstanceId()).add("Signal", signalAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeInstanceId":
            return Optional.ofNullable(clazz.cast(nodeInstanceId()));
        case "Signal":
            return Optional.ofNullable(clazz.cast(signalAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NodeInstanceId", NODE_INSTANCE_ID_FIELD);
        map.put("Signal", SIGNAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeSignal, T> g) {
        return obj -> g.apply((NodeSignal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeSignal> {
        /**
         * <p>
         * The camera node's name, from the application manifest.
         * </p>
         * 
         * @param nodeInstanceId
         *        The camera node's name, from the application manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeInstanceId(String nodeInstanceId);

        /**
         * <p>
         * The signal value.
         * </p>
         * 
         * @param signal
         *        The signal value.
         * @see NodeSignalValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeSignalValue
         */
        Builder signal(String signal);

        /**
         * <p>
         * The signal value.
         * </p>
         * 
         * @param signal
         *        The signal value.
         * @see NodeSignalValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeSignalValue
         */
        Builder signal(NodeSignalValue signal);
    }

    static final class BuilderImpl implements Builder {
        private String nodeInstanceId;

        private String signal;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeSignal model) {
            nodeInstanceId(model.nodeInstanceId);
            signal(model.signal);
        }

        public final String getNodeInstanceId() {
            return nodeInstanceId;
        }

        public final void setNodeInstanceId(String nodeInstanceId) {
            this.nodeInstanceId = nodeInstanceId;
        }

        @Override
        public final Builder nodeInstanceId(String nodeInstanceId) {
            this.nodeInstanceId = nodeInstanceId;
            return this;
        }

        public final String getSignal() {
            return signal;
        }

        public final void setSignal(String signal) {
            this.signal = signal;
        }

        @Override
        public final Builder signal(String signal) {
            this.signal = signal;
            return this;
        }

        @Override
        public final Builder signal(NodeSignalValue signal) {
            this.signal(signal == null ? null : signal.toString());
            return this;
        }

        @Override
        public NodeSignal build() {
            return new NodeSignal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
