/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an NTP server connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NtpStatus implements SdkPojo, Serializable, ToCopyableBuilder<NtpStatus.Builder, NtpStatus> {
    private static final SdkField<String> CONNECTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionStatus").getter(getter(NtpStatus::connectionStatusAsString))
            .setter(setter(Builder::connectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(NtpStatus::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> NTP_SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NtpServerName").getter(getter(NtpStatus::ntpServerName)).setter(setter(Builder::ntpServerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NtpServerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_STATUS_FIELD,
            IP_ADDRESS_FIELD, NTP_SERVER_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectionStatus;

    private final String ipAddress;

    private final String ntpServerName;

    private NtpStatus(BuilderImpl builder) {
        this.connectionStatus = builder.connectionStatus;
        this.ipAddress = builder.ipAddress;
        this.ntpServerName = builder.ntpServerName;
    }

    /**
     * <p>
     * The connection's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionStatus}
     * will return {@link NetworkConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectionStatusAsString}.
     * </p>
     * 
     * @return The connection's status.
     * @see NetworkConnectionStatus
     */
    public final NetworkConnectionStatus connectionStatus() {
        return NetworkConnectionStatus.fromValue(connectionStatus);
    }

    /**
     * <p>
     * The connection's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionStatus}
     * will return {@link NetworkConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectionStatusAsString}.
     * </p>
     * 
     * @return The connection's status.
     * @see NetworkConnectionStatus
     */
    public final String connectionStatusAsString() {
        return connectionStatus;
    }

    /**
     * <p>
     * The IP address of the server.
     * </p>
     * 
     * @return The IP address of the server.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The domain name of the server.
     * </p>
     * 
     * @return The domain name of the server.
     */
    public final String ntpServerName() {
        return ntpServerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(ntpServerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NtpStatus)) {
            return false;
        }
        NtpStatus other = (NtpStatus) obj;
        return Objects.equals(connectionStatusAsString(), other.connectionStatusAsString())
                && Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(ntpServerName(), other.ntpServerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NtpStatus").add("ConnectionStatus", connectionStatusAsString()).add("IpAddress", ipAddress())
                .add("NtpServerName", ntpServerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionStatus":
            return Optional.ofNullable(clazz.cast(connectionStatusAsString()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "NtpServerName":
            return Optional.ofNullable(clazz.cast(ntpServerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionStatus", CONNECTION_STATUS_FIELD);
        map.put("IpAddress", IP_ADDRESS_FIELD);
        map.put("NtpServerName", NTP_SERVER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NtpStatus, T> g) {
        return obj -> g.apply((NtpStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NtpStatus> {
        /**
         * <p>
         * The connection's status.
         * </p>
         * 
         * @param connectionStatus
         *        The connection's status.
         * @see NetworkConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkConnectionStatus
         */
        Builder connectionStatus(String connectionStatus);

        /**
         * <p>
         * The connection's status.
         * </p>
         * 
         * @param connectionStatus
         *        The connection's status.
         * @see NetworkConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkConnectionStatus
         */
        Builder connectionStatus(NetworkConnectionStatus connectionStatus);

        /**
         * <p>
         * The IP address of the server.
         * </p>
         * 
         * @param ipAddress
         *        The IP address of the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The domain name of the server.
         * </p>
         * 
         * @param ntpServerName
         *        The domain name of the server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ntpServerName(String ntpServerName);
    }

    static final class BuilderImpl implements Builder {
        private String connectionStatus;

        private String ipAddress;

        private String ntpServerName;

        private BuilderImpl() {
        }

        private BuilderImpl(NtpStatus model) {
            connectionStatus(model.connectionStatus);
            ipAddress(model.ipAddress);
            ntpServerName(model.ntpServerName);
        }

        public final String getConnectionStatus() {
            return connectionStatus;
        }

        public final void setConnectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
        }

        @Override
        public final Builder connectionStatus(String connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        @Override
        public final Builder connectionStatus(NetworkConnectionStatus connectionStatus) {
            this.connectionStatus(connectionStatus == null ? null : connectionStatus.toString());
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getNtpServerName() {
            return ntpServerName;
        }

        public final void setNtpServerName(String ntpServerName) {
            this.ntpServerName = ntpServerName;
        }

        @Override
        public final Builder ntpServerName(String ntpServerName) {
            this.ntpServerName = ntpServerName;
            return this;
        }

        @Override
        public NtpStatus build() {
            return new NtpStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
