/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.NodeInstance;
import software.amazon.awssdk.services.panorama.model.NodeInstancesCopier;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationInstanceNodeInstancesResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, ListApplicationInstanceNodeInstancesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListApplicationInstanceNodeInstancesResponse.getter(ListApplicationInstanceNodeInstancesResponse::nextToken)).setter(ListApplicationInstanceNodeInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<NodeInstance>> NODE_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeInstances").getter(ListApplicationInstanceNodeInstancesResponse.getter(ListApplicationInstanceNodeInstancesResponse::nodeInstances)).setter(ListApplicationInstanceNodeInstancesResponse.setter(Builder::nodeInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NODE_INSTANCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListApplicationInstanceNodeInstancesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<NodeInstance> nodeInstances;

    private ListApplicationInstanceNodeInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.nodeInstances = builder.nodeInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasNodeInstances() {
        return this.nodeInstances != null && !(this.nodeInstances instanceof SdkAutoConstructList);
    }

    public final List<NodeInstance> nodeInstances() {
        return this.nodeInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeInstances() ? this.nodeInstances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationInstanceNodeInstancesResponse)) {
            return false;
        }
        ListApplicationInstanceNodeInstancesResponse other = (ListApplicationInstanceNodeInstancesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasNodeInstances() == other.hasNodeInstances() && Objects.equals(this.nodeInstances(), other.nodeInstances());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationInstanceNodeInstancesResponse").add("NextToken", (Object)this.nextToken()).add("NodeInstances", this.hasNodeInstances() ? this.nodeInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "NodeInstances": {
                return Optional.ofNullable(clazz.cast(this.nodeInstances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("NodeInstances", NODE_INSTANCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationInstanceNodeInstancesResponse, T> g) {
        return obj -> g.apply((ListApplicationInstanceNodeInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<NodeInstance> nodeInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationInstanceNodeInstancesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.nodeInstances(model.nodeInstances);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<NodeInstance.Builder> getNodeInstances() {
            List<NodeInstance.Builder> result = NodeInstancesCopier.copyToBuilder(this.nodeInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeInstances(Collection<NodeInstance.BuilderImpl> nodeInstances) {
            this.nodeInstances = NodeInstancesCopier.copyFromBuilder(nodeInstances);
        }

        @Override
        public final Builder nodeInstances(Collection<NodeInstance> nodeInstances) {
            this.nodeInstances = NodeInstancesCopier.copy(nodeInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInstances(NodeInstance ... nodeInstances) {
            this.nodeInstances(Arrays.asList(nodeInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeInstances(Consumer<NodeInstance.Builder> ... nodeInstances) {
            this.nodeInstances(Stream.of(nodeInstances).map(c -> (NodeInstance)((NodeInstance.Builder)NodeInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListApplicationInstanceNodeInstancesResponse build() {
            return new ListApplicationInstanceNodeInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationInstanceNodeInstancesResponse> {
        public Builder nextToken(String var1);

        public Builder nodeInstances(Collection<NodeInstance> var1);

        public Builder nodeInstances(NodeInstance ... var1);

        public Builder nodeInstances(Consumer<NodeInstance.Builder> ... var1);
    }
}

