/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.panorama.model.EthernetStatus;
import software.amazon.awssdk.services.panorama.model.NtpStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkStatus> {
    private static final SdkField<EthernetStatus> ETHERNET0_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ethernet0Status").getter(NetworkStatus.getter(NetworkStatus::ethernet0Status)).setter(NetworkStatus.setter(Builder::ethernet0Status)).constructor(EthernetStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ethernet0Status").build()}).build();
    private static final SdkField<EthernetStatus> ETHERNET1_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ethernet1Status").getter(NetworkStatus.getter(NetworkStatus::ethernet1Status)).setter(NetworkStatus.setter(Builder::ethernet1Status)).constructor(EthernetStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ethernet1Status").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(NetworkStatus.getter(NetworkStatus::lastUpdatedTime)).setter(NetworkStatus.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<NtpStatus> NTP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NtpStatus").getter(NetworkStatus.getter(NetworkStatus::ntpStatus)).setter(NetworkStatus.setter(Builder::ntpStatus)).constructor(NtpStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NtpStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ETHERNET0_STATUS_FIELD, ETHERNET1_STATUS_FIELD, LAST_UPDATED_TIME_FIELD, NTP_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EthernetStatus ethernet0Status;
    private final EthernetStatus ethernet1Status;
    private final Instant lastUpdatedTime;
    private final NtpStatus ntpStatus;

    private NetworkStatus(BuilderImpl builder) {
        this.ethernet0Status = builder.ethernet0Status;
        this.ethernet1Status = builder.ethernet1Status;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.ntpStatus = builder.ntpStatus;
    }

    public final EthernetStatus ethernet0Status() {
        return this.ethernet0Status;
    }

    public final EthernetStatus ethernet1Status() {
        return this.ethernet1Status;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final NtpStatus ntpStatus() {
        return this.ntpStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ethernet0Status());
        hashCode = 31 * hashCode + Objects.hashCode(this.ethernet1Status());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ntpStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkStatus)) {
            return false;
        }
        NetworkStatus other = (NetworkStatus)obj;
        return Objects.equals(this.ethernet0Status(), other.ethernet0Status()) && Objects.equals(this.ethernet1Status(), other.ethernet1Status()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.ntpStatus(), other.ntpStatus());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkStatus").add("Ethernet0Status", (Object)this.ethernet0Status()).add("Ethernet1Status", (Object)this.ethernet1Status()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("NtpStatus", (Object)this.ntpStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ethernet0Status": {
                return Optional.ofNullable(clazz.cast(this.ethernet0Status()));
            }
            case "Ethernet1Status": {
                return Optional.ofNullable(clazz.cast(this.ethernet1Status()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "NtpStatus": {
                return Optional.ofNullable(clazz.cast(this.ntpStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Ethernet0Status", ETHERNET0_STATUS_FIELD);
        map.put("Ethernet1Status", ETHERNET1_STATUS_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("NtpStatus", NTP_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkStatus, T> g) {
        return obj -> g.apply((NetworkStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EthernetStatus ethernet0Status;
        private EthernetStatus ethernet1Status;
        private Instant lastUpdatedTime;
        private NtpStatus ntpStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkStatus model) {
            this.ethernet0Status(model.ethernet0Status);
            this.ethernet1Status(model.ethernet1Status);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.ntpStatus(model.ntpStatus);
        }

        public final EthernetStatus.Builder getEthernet0Status() {
            return this.ethernet0Status != null ? this.ethernet0Status.toBuilder() : null;
        }

        public final void setEthernet0Status(EthernetStatus.BuilderImpl ethernet0Status) {
            this.ethernet0Status = ethernet0Status != null ? ethernet0Status.build() : null;
        }

        @Override
        public final Builder ethernet0Status(EthernetStatus ethernet0Status) {
            this.ethernet0Status = ethernet0Status;
            return this;
        }

        public final EthernetStatus.Builder getEthernet1Status() {
            return this.ethernet1Status != null ? this.ethernet1Status.toBuilder() : null;
        }

        public final void setEthernet1Status(EthernetStatus.BuilderImpl ethernet1Status) {
            this.ethernet1Status = ethernet1Status != null ? ethernet1Status.build() : null;
        }

        @Override
        public final Builder ethernet1Status(EthernetStatus ethernet1Status) {
            this.ethernet1Status = ethernet1Status;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final NtpStatus.Builder getNtpStatus() {
            return this.ntpStatus != null ? this.ntpStatus.toBuilder() : null;
        }

        public final void setNtpStatus(NtpStatus.BuilderImpl ntpStatus) {
            this.ntpStatus = ntpStatus != null ? ntpStatus.build() : null;
        }

        @Override
        public final Builder ntpStatus(NtpStatus ntpStatus) {
            this.ntpStatus = ntpStatus;
            return this;
        }

        public NetworkStatus build() {
            return new NetworkStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkStatus> {
        public Builder ethernet0Status(EthernetStatus var1);

        default public Builder ethernet0Status(Consumer<EthernetStatus.Builder> ethernet0Status) {
            return this.ethernet0Status((EthernetStatus)((EthernetStatus.Builder)EthernetStatus.builder().applyMutation(ethernet0Status)).build());
        }

        public Builder ethernet1Status(EthernetStatus var1);

        default public Builder ethernet1Status(Consumer<EthernetStatus.Builder> ethernet1Status) {
            return this.ethernet1Status((EthernetStatus)((EthernetStatus.Builder)EthernetStatus.builder().applyMutation(ethernet1Status)).build());
        }

        public Builder lastUpdatedTime(Instant var1);

        public Builder ntpStatus(NtpStatus var1);

        default public Builder ntpStatus(Consumer<NtpStatus.Builder> ntpStatus) {
            return this.ntpStatus((NtpStatus)((NtpStatus.Builder)NtpStatus.builder().applyMutation(ntpStatus)).build());
        }
    }
}

