/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of group access control entries that allow or deny Active Directory groups based on their security
 * identifiers (SIDs) from enrolling and/or autofenrolling with the template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessControlEntrySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessControlEntrySummary.Builder, AccessControlEntrySummary> {
    private static final SdkField<AccessRights> ACCESS_RIGHTS_FIELD = SdkField.<AccessRights> builder(MarshallingType.SDK_POJO)
            .memberName("AccessRights").getter(getter(AccessControlEntrySummary::accessRights))
            .setter(setter(Builder::accessRights)).constructor(AccessRights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRights").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(AccessControlEntrySummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> GROUP_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupDisplayName").getter(getter(AccessControlEntrySummary::groupDisplayName))
            .setter(setter(Builder::groupDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDisplayName").build()).build();

    private static final SdkField<String> GROUP_SECURITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupSecurityIdentifier").getter(getter(AccessControlEntrySummary::groupSecurityIdentifier))
            .setter(setter(Builder::groupSecurityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSecurityIdentifier").build())
            .build();

    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateArn").getter(getter(AccessControlEntrySummary::templateArn))
            .setter(setter(Builder::templateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(AccessControlEntrySummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_RIGHTS_FIELD,
            CREATED_AT_FIELD, GROUP_DISPLAY_NAME_FIELD, GROUP_SECURITY_IDENTIFIER_FIELD, TEMPLATE_ARN_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AccessRights accessRights;

    private final Instant createdAt;

    private final String groupDisplayName;

    private final String groupSecurityIdentifier;

    private final String templateArn;

    private final Instant updatedAt;

    private AccessControlEntrySummary(BuilderImpl builder) {
        this.accessRights = builder.accessRights;
        this.createdAt = builder.createdAt;
        this.groupDisplayName = builder.groupDisplayName;
        this.groupSecurityIdentifier = builder.groupSecurityIdentifier;
        this.templateArn = builder.templateArn;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * Allow or deny an Active Directory group from enrolling and autoenrolling certificates issued against a template.
     * </p>
     * 
     * @return Allow or deny an Active Directory group from enrolling and autoenrolling certificates issued against a
     *         template.
     */
    public final AccessRights accessRights() {
        return accessRights;
    }

    /**
     * <p>
     * The date and time that the Access Control Entry was created.
     * </p>
     * 
     * @return The date and time that the Access Control Entry was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Name of the Active Directory group. This name does not need to match the group name in Active Directory.
     * </p>
     * 
     * @return Name of the Active Directory group. This name does not need to match the group name in Active Directory.
     */
    public final String groupDisplayName() {
        return groupDisplayName;
    }

    /**
     * <p>
     * Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".
     * </p>
     * 
     * @return Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".
     */
    public final String groupSecurityIdentifier() {
        return groupSecurityIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that was returned when you called <a
     * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
     * >CreateTemplate</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that was returned when you called <a
     *         href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
     *         >CreateTemplate</a>.
     */
    public final String templateArn() {
        return templateArn;
    }

    /**
     * <p>
     * The date and time that the Access Control Entry was updated.
     * </p>
     * 
     * @return The date and time that the Access Control Entry was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessRights());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(groupDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(groupSecurityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessControlEntrySummary)) {
            return false;
        }
        AccessControlEntrySummary other = (AccessControlEntrySummary) obj;
        return Objects.equals(accessRights(), other.accessRights()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(groupDisplayName(), other.groupDisplayName())
                && Objects.equals(groupSecurityIdentifier(), other.groupSecurityIdentifier())
                && Objects.equals(templateArn(), other.templateArn()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessControlEntrySummary").add("AccessRights", accessRights()).add("CreatedAt", createdAt())
                .add("GroupDisplayName", groupDisplayName()).add("GroupSecurityIdentifier", groupSecurityIdentifier())
                .add("TemplateArn", templateArn()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessRights":
            return Optional.ofNullable(clazz.cast(accessRights()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "GroupDisplayName":
            return Optional.ofNullable(clazz.cast(groupDisplayName()));
        case "GroupSecurityIdentifier":
            return Optional.ofNullable(clazz.cast(groupSecurityIdentifier()));
        case "TemplateArn":
            return Optional.ofNullable(clazz.cast(templateArn()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessRights", ACCESS_RIGHTS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("GroupDisplayName", GROUP_DISPLAY_NAME_FIELD);
        map.put("GroupSecurityIdentifier", GROUP_SECURITY_IDENTIFIER_FIELD);
        map.put("TemplateArn", TEMPLATE_ARN_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessControlEntrySummary, T> g) {
        return obj -> g.apply((AccessControlEntrySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessControlEntrySummary> {
        /**
         * <p>
         * Allow or deny an Active Directory group from enrolling and autoenrolling certificates issued against a
         * template.
         * </p>
         * 
         * @param accessRights
         *        Allow or deny an Active Directory group from enrolling and autoenrolling certificates issued against a
         *        template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessRights(AccessRights accessRights);

        /**
         * <p>
         * Allow or deny an Active Directory group from enrolling and autoenrolling certificates issued against a
         * template.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessRights.Builder} avoiding the need
         * to create one manually via {@link AccessRights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessRights.Builder#build()} is called immediately and its
         * result is passed to {@link #accessRights(AccessRights)}.
         * 
         * @param accessRights
         *        a consumer that will call methods on {@link AccessRights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessRights(AccessRights)
         */
        default Builder accessRights(Consumer<AccessRights.Builder> accessRights) {
            return accessRights(AccessRights.builder().applyMutation(accessRights).build());
        }

        /**
         * <p>
         * The date and time that the Access Control Entry was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the Access Control Entry was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Name of the Active Directory group. This name does not need to match the group name in Active Directory.
         * </p>
         * 
         * @param groupDisplayName
         *        Name of the Active Directory group. This name does not need to match the group name in Active
         *        Directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupDisplayName(String groupDisplayName);

        /**
         * <p>
         * Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".
         * </p>
         * 
         * @param groupSecurityIdentifier
         *        Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupSecurityIdentifier(String groupSecurityIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that was returned when you called <a
         * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
         * >CreateTemplate</a>.
         * </p>
         * 
         * @param templateArn
         *        The Amazon Resource Name (ARN) that was returned when you called <a
         *        href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html"
         *        >CreateTemplate</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateArn(String templateArn);

        /**
         * <p>
         * The date and time that the Access Control Entry was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time that the Access Control Entry was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private AccessRights accessRights;

        private Instant createdAt;

        private String groupDisplayName;

        private String groupSecurityIdentifier;

        private String templateArn;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessControlEntrySummary model) {
            accessRights(model.accessRights);
            createdAt(model.createdAt);
            groupDisplayName(model.groupDisplayName);
            groupSecurityIdentifier(model.groupSecurityIdentifier);
            templateArn(model.templateArn);
            updatedAt(model.updatedAt);
        }

        public final AccessRights.Builder getAccessRights() {
            return accessRights != null ? accessRights.toBuilder() : null;
        }

        public final void setAccessRights(AccessRights.BuilderImpl accessRights) {
            this.accessRights = accessRights != null ? accessRights.build() : null;
        }

        @Override
        public final Builder accessRights(AccessRights accessRights) {
            this.accessRights = accessRights;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getGroupDisplayName() {
            return groupDisplayName;
        }

        public final void setGroupDisplayName(String groupDisplayName) {
            this.groupDisplayName = groupDisplayName;
        }

        @Override
        public final Builder groupDisplayName(String groupDisplayName) {
            this.groupDisplayName = groupDisplayName;
            return this;
        }

        public final String getGroupSecurityIdentifier() {
            return groupSecurityIdentifier;
        }

        public final void setGroupSecurityIdentifier(String groupSecurityIdentifier) {
            this.groupSecurityIdentifier = groupSecurityIdentifier;
        }

        @Override
        public final Builder groupSecurityIdentifier(String groupSecurityIdentifier) {
            this.groupSecurityIdentifier = groupSecurityIdentifier;
            return this;
        }

        public final String getTemplateArn() {
            return templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public AccessControlEntrySummary build() {
            return new AccessControlEntrySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
