/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Application policies describe what the certificate can be used for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationPolicies implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationPolicies.Builder, ApplicationPolicies> {
    private static final SdkField<Boolean> CRITICAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Critical").getter(getter(ApplicationPolicies::critical)).setter(setter(Builder::critical))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Critical").build()).build();

    private static final SdkField<List<ApplicationPolicy>> POLICIES_FIELD = SdkField
            .<List<ApplicationPolicy>> builder(MarshallingType.LIST)
            .memberName("Policies")
            .getter(getter(ApplicationPolicies::policies))
            .setter(setter(Builder::policies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CRITICAL_FIELD, POLICIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean critical;

    private final List<ApplicationPolicy> policies;

    private ApplicationPolicies(BuilderImpl builder) {
        this.critical = builder.critical;
        this.policies = builder.policies;
    }

    /**
     * <p>
     * Marks the application policy extension as critical.
     * </p>
     * 
     * @return Marks the application policy extension as critical.
     */
    public final Boolean critical() {
        return critical;
    }

    /**
     * For responses, this returns true if the service returned a value for the Policies property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolicies() {
        return policies != null && !(policies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Application policies describe what the certificate can be used for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicies} method.
     * </p>
     * 
     * @return Application policies describe what the certificate can be used for.
     */
    public final List<ApplicationPolicy> policies() {
        return policies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(critical());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicies() ? policies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationPolicies)) {
            return false;
        }
        ApplicationPolicies other = (ApplicationPolicies) obj;
        return Objects.equals(critical(), other.critical()) && hasPolicies() == other.hasPolicies()
                && Objects.equals(policies(), other.policies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationPolicies").add("Critical", critical())
                .add("Policies", hasPolicies() ? policies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Critical":
            return Optional.ofNullable(clazz.cast(critical()));
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Critical", CRITICAL_FIELD);
        map.put("Policies", POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationPolicies, T> g) {
        return obj -> g.apply((ApplicationPolicies) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationPolicies> {
        /**
         * <p>
         * Marks the application policy extension as critical.
         * </p>
         * 
         * @param critical
         *        Marks the application policy extension as critical.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder critical(Boolean critical);

        /**
         * <p>
         * Application policies describe what the certificate can be used for.
         * </p>
         * 
         * @param policies
         *        Application policies describe what the certificate can be used for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Collection<ApplicationPolicy> policies);

        /**
         * <p>
         * Application policies describe what the certificate can be used for.
         * </p>
         * 
         * @param policies
         *        Application policies describe what the certificate can be used for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(ApplicationPolicy... policies);

        /**
         * <p>
         * Application policies describe what the certificate can be used for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pcaconnectorad.model.ApplicationPolicy.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.pcaconnectorad.model.ApplicationPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pcaconnectorad.model.ApplicationPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #policies(List<ApplicationPolicy>)}.
         * 
         * @param policies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pcaconnectorad.model.ApplicationPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(java.util.Collection<ApplicationPolicy>)
         */
        Builder policies(Consumer<ApplicationPolicy.Builder>... policies);
    }

    static final class BuilderImpl implements Builder {
        private Boolean critical;

        private List<ApplicationPolicy> policies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationPolicies model) {
            critical(model.critical);
            policies(model.policies);
        }

        public final Boolean getCritical() {
            return critical;
        }

        public final void setCritical(Boolean critical) {
            this.critical = critical;
        }

        @Override
        public final Builder critical(Boolean critical) {
            this.critical = critical;
            return this;
        }

        public final List<ApplicationPolicy.Builder> getPolicies() {
            List<ApplicationPolicy.Builder> result = ApplicationPolicyListCopier.copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicies(Collection<ApplicationPolicy.BuilderImpl> policies) {
            this.policies = ApplicationPolicyListCopier.copyFromBuilder(policies);
        }

        @Override
        public final Builder policies(Collection<ApplicationPolicy> policies) {
            this.policies = ApplicationPolicyListCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(ApplicationPolicy... policies) {
            policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<ApplicationPolicy.Builder>... policies) {
            policies(Stream.of(policies).map(c -> ApplicationPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ApplicationPolicies build() {
            return new ApplicationPolicies(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
