/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ApplicationPolicyType {
    ALL_APPLICATION_POLICIES("ALL_APPLICATION_POLICIES"),

    ANY_PURPOSE("ANY_PURPOSE"),

    ATTESTATION_IDENTITY_KEY_CERTIFICATE("ATTESTATION_IDENTITY_KEY_CERTIFICATE"),

    CERTIFICATE_REQUEST_AGENT("CERTIFICATE_REQUEST_AGENT"),

    CLIENT_AUTHENTICATION("CLIENT_AUTHENTICATION"),

    CODE_SIGNING("CODE_SIGNING"),

    CTL_USAGE("CTL_USAGE"),

    DIGITAL_RIGHTS("DIGITAL_RIGHTS"),

    DIRECTORY_SERVICE_EMAIL_REPLICATION("DIRECTORY_SERVICE_EMAIL_REPLICATION"),

    DISALLOWED_LIST("DISALLOWED_LIST"),

    DNS_SERVER_TRUST("DNS_SERVER_TRUST"),

    DOCUMENT_ENCRYPTION("DOCUMENT_ENCRYPTION"),

    DOCUMENT_SIGNING("DOCUMENT_SIGNING"),

    DYNAMIC_CODE_GENERATOR("DYNAMIC_CODE_GENERATOR"),

    EARLY_LAUNCH_ANTIMALWARE_DRIVER("EARLY_LAUNCH_ANTIMALWARE_DRIVER"),

    EMBEDDED_WINDOWS_SYSTEM_COMPONENT_VERIFICATION("EMBEDDED_WINDOWS_SYSTEM_COMPONENT_VERIFICATION"),

    ENCLAVE("ENCLAVE"),

    ENCRYPTING_FILE_SYSTEM("ENCRYPTING_FILE_SYSTEM"),

    ENDORSEMENT_KEY_CERTIFICATE("ENDORSEMENT_KEY_CERTIFICATE"),

    FILE_RECOVERY("FILE_RECOVERY"),

    HAL_EXTENSION("HAL_EXTENSION"),

    IP_SECURITY_END_SYSTEM("IP_SECURITY_END_SYSTEM"),

    IP_SECURITY_IKE_INTERMEDIATE("IP_SECURITY_IKE_INTERMEDIATE"),

    IP_SECURITY_TUNNEL_TERMINATION("IP_SECURITY_TUNNEL_TERMINATION"),

    IP_SECURITY_USER("IP_SECURITY_USER"),

    ISOLATED_USER_MODE("ISOLATED_USER_MODE"),

    KDC_AUTHENTICATION("KDC_AUTHENTICATION"),

    KERNEL_MODE_CODE_SIGNING("KERNEL_MODE_CODE_SIGNING"),

    KEY_PACK_LICENSES("KEY_PACK_LICENSES"),

    KEY_RECOVERY("KEY_RECOVERY"),

    KEY_RECOVERY_AGENT("KEY_RECOVERY_AGENT"),

    LICENSE_SERVER_VERIFICATION("LICENSE_SERVER_VERIFICATION"),

    LIFETIME_SIGNING("LIFETIME_SIGNING"),

    MICROSOFT_PUBLISHER("MICROSOFT_PUBLISHER"),

    MICROSOFT_TIME_STAMPING("MICROSOFT_TIME_STAMPING"),

    MICROSOFT_TRUST_LIST_SIGNING("MICROSOFT_TRUST_LIST_SIGNING"),

    OCSP_SIGNING("OCSP_SIGNING"),

    OEM_WINDOWS_SYSTEM_COMPONENT_VERIFICATION("OEM_WINDOWS_SYSTEM_COMPONENT_VERIFICATION"),

    PLATFORM_CERTIFICATE("PLATFORM_CERTIFICATE"),

    PREVIEW_BUILD_SIGNING("PREVIEW_BUILD_SIGNING"),

    PRIVATE_KEY_ARCHIVAL("PRIVATE_KEY_ARCHIVAL"),

    PROTECTED_PROCESS_LIGHT_VERIFICATION("PROTECTED_PROCESS_LIGHT_VERIFICATION"),

    PROTECTED_PROCESS_VERIFICATION("PROTECTED_PROCESS_VERIFICATION"),

    QUALIFIED_SUBORDINATION("QUALIFIED_SUBORDINATION"),

    REVOKED_LIST_SIGNER("REVOKED_LIST_SIGNER"),

    ROOT_PROGRAM_AUTO_UPDATE_CA_REVOCATION("ROOT_PROGRAM_AUTO_UPDATE_CA_REVOCATION"),

    ROOT_PROGRAM_AUTO_UPDATE_END_REVOCATION("ROOT_PROGRAM_AUTO_UPDATE_END_REVOCATION"),

    ROOT_PROGRAM_NO_OSCP_FAILOVER_TO_CRL("ROOT_PROGRAM_NO_OSCP_FAILOVER_TO_CRL"),

    ROOT_LIST_SIGNER("ROOT_LIST_SIGNER"),

    SECURE_EMAIL("SECURE_EMAIL"),

    SERVER_AUTHENTICATION("SERVER_AUTHENTICATION"),

    SMART_CARD_LOGIN("SMART_CARD_LOGIN"),

    SPC_ENCRYPTED_DIGEST_RETRY_COUNT("SPC_ENCRYPTED_DIGEST_RETRY_COUNT"),

    SPC_RELAXED_PE_MARKER_CHECK("SPC_RELAXED_PE_MARKER_CHECK"),

    TIME_STAMPING("TIME_STAMPING"),

    WINDOWS_HARDWARE_DRIVER_ATTESTED_VERIFICATION("WINDOWS_HARDWARE_DRIVER_ATTESTED_VERIFICATION"),

    WINDOWS_HARDWARE_DRIVER_EXTENDED_VERIFICATION("WINDOWS_HARDWARE_DRIVER_EXTENDED_VERIFICATION"),

    WINDOWS_HARDWARE_DRIVER_VERIFICATION("WINDOWS_HARDWARE_DRIVER_VERIFICATION"),

    WINDOWS_HELLO_RECOVERY_KEY_ENCRYPTION("WINDOWS_HELLO_RECOVERY_KEY_ENCRYPTION"),

    WINDOWS_KITS_COMPONENT("WINDOWS_KITS_COMPONENT"),

    WINDOWS_RT_VERIFICATION("WINDOWS_RT_VERIFICATION"),

    WINDOWS_SOFTWARE_EXTENSION_VERIFICATION("WINDOWS_SOFTWARE_EXTENSION_VERIFICATION"),

    WINDOWS_STORE("WINDOWS_STORE"),

    WINDOWS_SYSTEM_COMPONENT_VERIFICATION("WINDOWS_SYSTEM_COMPONENT_VERIFICATION"),

    WINDOWS_TCB_COMPONENT("WINDOWS_TCB_COMPONENT"),

    WINDOWS_THIRD_PARTY_APPLICATION_COMPONENT("WINDOWS_THIRD_PARTY_APPLICATION_COMPONENT"),

    WINDOWS_UPDATE("WINDOWS_UPDATE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationPolicyType> VALUE_MAP = EnumUtils.uniqueIndex(ApplicationPolicyType.class,
            ApplicationPolicyType::toString);

    private final String value;

    private ApplicationPolicyType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ApplicationPolicyType corresponding to the value
     */
    public static ApplicationPolicyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ApplicationPolicyType}s
     */
    public static Set<ApplicationPolicyType> knownValues() {
        Set<ApplicationPolicyType> knownValues = EnumSet.allOf(ApplicationPolicyType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
