/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcaconnectorad.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies key usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyUsagePropertyFlags implements SdkPojo, Serializable,
        ToCopyableBuilder<KeyUsagePropertyFlags.Builder, KeyUsagePropertyFlags> {
    private static final SdkField<Boolean> DECRYPT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Decrypt").getter(getter(KeyUsagePropertyFlags::decrypt)).setter(setter(Builder::decrypt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Decrypt").build()).build();

    private static final SdkField<Boolean> KEY_AGREEMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KeyAgreement").getter(getter(KeyUsagePropertyFlags::keyAgreement)).setter(setter(Builder::keyAgreement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAgreement").build()).build();

    private static final SdkField<Boolean> SIGN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Sign")
            .getter(getter(KeyUsagePropertyFlags::sign)).setter(setter(Builder::sign))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sign").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECRYPT_FIELD,
            KEY_AGREEMENT_FIELD, SIGN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean decrypt;

    private final Boolean keyAgreement;

    private final Boolean sign;

    private KeyUsagePropertyFlags(BuilderImpl builder) {
        this.decrypt = builder.decrypt;
        this.keyAgreement = builder.keyAgreement;
        this.sign = builder.sign;
    }

    /**
     * <p>
     * Allows key for encryption and decryption.
     * </p>
     * 
     * @return Allows key for encryption and decryption.
     */
    public final Boolean decrypt() {
        return decrypt;
    }

    /**
     * <p>
     * Allows key exchange without encryption.
     * </p>
     * 
     * @return Allows key exchange without encryption.
     */
    public final Boolean keyAgreement() {
        return keyAgreement;
    }

    /**
     * <p>
     * Allow key use for digital signature.
     * </p>
     * 
     * @return Allow key use for digital signature.
     */
    public final Boolean sign() {
        return sign;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(decrypt());
        hashCode = 31 * hashCode + Objects.hashCode(keyAgreement());
        hashCode = 31 * hashCode + Objects.hashCode(sign());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyUsagePropertyFlags)) {
            return false;
        }
        KeyUsagePropertyFlags other = (KeyUsagePropertyFlags) obj;
        return Objects.equals(decrypt(), other.decrypt()) && Objects.equals(keyAgreement(), other.keyAgreement())
                && Objects.equals(sign(), other.sign());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyUsagePropertyFlags").add("Decrypt", decrypt()).add("KeyAgreement", keyAgreement())
                .add("Sign", sign()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Decrypt":
            return Optional.ofNullable(clazz.cast(decrypt()));
        case "KeyAgreement":
            return Optional.ofNullable(clazz.cast(keyAgreement()));
        case "Sign":
            return Optional.ofNullable(clazz.cast(sign()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Decrypt", DECRYPT_FIELD);
        map.put("KeyAgreement", KEY_AGREEMENT_FIELD);
        map.put("Sign", SIGN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyUsagePropertyFlags, T> g) {
        return obj -> g.apply((KeyUsagePropertyFlags) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyUsagePropertyFlags> {
        /**
         * <p>
         * Allows key for encryption and decryption.
         * </p>
         * 
         * @param decrypt
         *        Allows key for encryption and decryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decrypt(Boolean decrypt);

        /**
         * <p>
         * Allows key exchange without encryption.
         * </p>
         * 
         * @param keyAgreement
         *        Allows key exchange without encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAgreement(Boolean keyAgreement);

        /**
         * <p>
         * Allow key use for digital signature.
         * </p>
         * 
         * @param sign
         *        Allow key use for digital signature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sign(Boolean sign);
    }

    static final class BuilderImpl implements Builder {
        private Boolean decrypt;

        private Boolean keyAgreement;

        private Boolean sign;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyUsagePropertyFlags model) {
            decrypt(model.decrypt);
            keyAgreement(model.keyAgreement);
            sign(model.sign);
        }

        public final Boolean getDecrypt() {
            return decrypt;
        }

        public final void setDecrypt(Boolean decrypt) {
            this.decrypt = decrypt;
        }

        @Override
        public final Builder decrypt(Boolean decrypt) {
            this.decrypt = decrypt;
            return this;
        }

        public final Boolean getKeyAgreement() {
            return keyAgreement;
        }

        public final void setKeyAgreement(Boolean keyAgreement) {
            this.keyAgreement = keyAgreement;
        }

        @Override
        public final Builder keyAgreement(Boolean keyAgreement) {
            this.keyAgreement = keyAgreement;
            return this;
        }

        public final Boolean getSign() {
            return sign;
        }

        public final void setSign(Boolean sign) {
            this.sign = sign;
        }

        @Override
        public final Builder sign(Boolean sign) {
            this.sign = sign;
            return this;
        }

        @Override
        public KeyUsagePropertyFlags build() {
            return new KeyUsagePropertyFlags(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
