/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pcs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterComputeNodeGroupInstanceResponse extends PcsResponse implements
        ToCopyableBuilder<RegisterComputeNodeGroupInstanceResponse.Builder, RegisterComputeNodeGroupInstanceResponse> {
    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("nodeID")
            .getter(getter(RegisterComputeNodeGroupInstanceResponse::nodeID)).setter(setter(Builder::nodeID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeID").build()).build();

    private static final SdkField<String> SHARED_SECRET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sharedSecret").getter(getter(RegisterComputeNodeGroupInstanceResponse::sharedSecret))
            .setter(setter(Builder::sharedSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedSecret").build()).build();

    private static final SdkField<List<Endpoint>> ENDPOINTS_FIELD = SdkField
            .<List<Endpoint>> builder(MarshallingType.LIST)
            .memberName("endpoints")
            .getter(getter(RegisterComputeNodeGroupInstanceResponse::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Endpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(Endpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ID_FIELD,
            SHARED_SECRET_FIELD, ENDPOINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nodeID;

    private final String sharedSecret;

    private final List<Endpoint> endpoints;

    private RegisterComputeNodeGroupInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.nodeID = builder.nodeID;
        this.sharedSecret = builder.sharedSecret;
        this.endpoints = builder.endpoints;
    }

    /**
     * <p>
     * The scheduler node ID for this instance.
     * </p>
     * 
     * @return The scheduler node ID for this instance.
     */
    public final String nodeID() {
        return nodeID;
    }

    /**
     * <p>
     * For the Slurm scheduler, this is the shared Munge key the scheduler uses to authenticate compute node group
     * instances.
     * </p>
     * 
     * @return For the Slurm scheduler, this is the shared Munge key the scheduler uses to authenticate compute node
     *         group instances.
     */
    public final String sharedSecret() {
        return sharedSecret;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of endpoints available for interaction with the scheduler.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return The list of endpoints available for interaction with the scheduler.
     */
    public final List<Endpoint> endpoints() {
        return endpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nodeID());
        hashCode = 31 * hashCode + Objects.hashCode(sharedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterComputeNodeGroupInstanceResponse)) {
            return false;
        }
        RegisterComputeNodeGroupInstanceResponse other = (RegisterComputeNodeGroupInstanceResponse) obj;
        return Objects.equals(nodeID(), other.nodeID()) && Objects.equals(sharedSecret(), other.sharedSecret())
                && hasEndpoints() == other.hasEndpoints() && Objects.equals(endpoints(), other.endpoints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterComputeNodeGroupInstanceResponse").add("NodeID", nodeID())
                .add("SharedSecret", sharedSecret() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Endpoints", hasEndpoints() ? endpoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nodeID":
            return Optional.ofNullable(clazz.cast(nodeID()));
        case "sharedSecret":
            return Optional.ofNullable(clazz.cast(sharedSecret()));
        case "endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nodeID", NODE_ID_FIELD);
        map.put("sharedSecret", SHARED_SECRET_FIELD);
        map.put("endpoints", ENDPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterComputeNodeGroupInstanceResponse, T> g) {
        return obj -> g.apply((RegisterComputeNodeGroupInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PcsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterComputeNodeGroupInstanceResponse> {
        /**
         * <p>
         * The scheduler node ID for this instance.
         * </p>
         * 
         * @param nodeID
         *        The scheduler node ID for this instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeID(String nodeID);

        /**
         * <p>
         * For the Slurm scheduler, this is the shared Munge key the scheduler uses to authenticate compute node group
         * instances.
         * </p>
         * 
         * @param sharedSecret
         *        For the Slurm scheduler, this is the shared Munge key the scheduler uses to authenticate compute node
         *        group instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedSecret(String sharedSecret);

        /**
         * <p>
         * The list of endpoints available for interaction with the scheduler.
         * </p>
         * 
         * @param endpoints
         *        The list of endpoints available for interaction with the scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Collection<Endpoint> endpoints);

        /**
         * <p>
         * The list of endpoints available for interaction with the scheduler.
         * </p>
         * 
         * @param endpoints
         *        The list of endpoints available for interaction with the scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Endpoint... endpoints);

        /**
         * <p>
         * The list of endpoints available for interaction with the scheduler.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pcs.model.Endpoint.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.pcs.model.Endpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pcs.model.Endpoint.Builder#build()} is called immediately and its
         * result is passed to {@link #endpoints(List<Endpoint>)}.
         * 
         * @param endpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pcs.model.Endpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoints(java.util.Collection<Endpoint>)
         */
        Builder endpoints(Consumer<Endpoint.Builder>... endpoints);
    }

    static final class BuilderImpl extends PcsResponse.BuilderImpl implements Builder {
        private String nodeID;

        private String sharedSecret;

        private List<Endpoint> endpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterComputeNodeGroupInstanceResponse model) {
            super(model);
            nodeID(model.nodeID);
            sharedSecret(model.sharedSecret);
            endpoints(model.endpoints);
        }

        public final String getNodeID() {
            return nodeID;
        }

        public final void setNodeID(String nodeID) {
            this.nodeID = nodeID;
        }

        @Override
        public final Builder nodeID(String nodeID) {
            this.nodeID = nodeID;
            return this;
        }

        public final String getSharedSecret() {
            return sharedSecret;
        }

        public final void setSharedSecret(String sharedSecret) {
            this.sharedSecret = sharedSecret;
        }

        @Override
        public final Builder sharedSecret(String sharedSecret) {
            this.sharedSecret = sharedSecret;
            return this;
        }

        public final List<Endpoint.Builder> getEndpoints() {
            List<Endpoint.Builder> result = EndpointsCopier.copyToBuilder(this.endpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpoints(Collection<Endpoint.BuilderImpl> endpoints) {
            this.endpoints = EndpointsCopier.copyFromBuilder(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<Endpoint> endpoints) {
            this.endpoints = EndpointsCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Endpoint... endpoints) {
            endpoints(Arrays.asList(endpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(Consumer<Endpoint.Builder>... endpoints) {
            endpoints(Stream.of(endpoints).map(c -> Endpoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RegisterComputeNodeGroupInstanceResponse build() {
            return new RegisterComputeNodeGroupInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
