/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPerformanceAnalysisReportResponse extends PiResponse implements
        ToCopyableBuilder<GetPerformanceAnalysisReportResponse.Builder, GetPerformanceAnalysisReportResponse> {
    private static final SdkField<AnalysisReport> ANALYSIS_REPORT_FIELD = SdkField
            .<AnalysisReport> builder(MarshallingType.SDK_POJO).memberName("AnalysisReport")
            .getter(getter(GetPerformanceAnalysisReportResponse::analysisReport)).setter(setter(Builder::analysisReport))
            .constructor(AnalysisReport::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisReport").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_REPORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AnalysisReport analysisReport;

    private GetPerformanceAnalysisReportResponse(BuilderImpl builder) {
        super(builder);
        this.analysisReport = builder.analysisReport;
    }

    /**
     * <p>
     * The summary of the performance analysis report created for a time period.
     * </p>
     * 
     * @return The summary of the performance analysis report created for a time period.
     */
    public final AnalysisReport analysisReport() {
        return analysisReport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analysisReport());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPerformanceAnalysisReportResponse)) {
            return false;
        }
        GetPerformanceAnalysisReportResponse other = (GetPerformanceAnalysisReportResponse) obj;
        return Objects.equals(analysisReport(), other.analysisReport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPerformanceAnalysisReportResponse").add("AnalysisReport", analysisReport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalysisReport":
            return Optional.ofNullable(clazz.cast(analysisReport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AnalysisReport", ANALYSIS_REPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPerformanceAnalysisReportResponse, T> g) {
        return obj -> g.apply((GetPerformanceAnalysisReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PiResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPerformanceAnalysisReportResponse> {
        /**
         * <p>
         * The summary of the performance analysis report created for a time period.
         * </p>
         * 
         * @param analysisReport
         *        The summary of the performance analysis report created for a time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisReport(AnalysisReport analysisReport);

        /**
         * <p>
         * The summary of the performance analysis report created for a time period.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisReport.Builder} avoiding the need
         * to create one manually via {@link AnalysisReport#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisReport.Builder#build()} is called immediately and its
         * result is passed to {@link #analysisReport(AnalysisReport)}.
         * 
         * @param analysisReport
         *        a consumer that will call methods on {@link AnalysisReport.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisReport(AnalysisReport)
         */
        default Builder analysisReport(Consumer<AnalysisReport.Builder> analysisReport) {
            return analysisReport(AnalysisReport.builder().applyMutation(analysisReport).build());
        }
    }

    static final class BuilderImpl extends PiResponse.BuilderImpl implements Builder {
        private AnalysisReport analysisReport;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPerformanceAnalysisReportResponse model) {
            super(model);
            analysisReport(model.analysisReport);
        }

        public final AnalysisReport.Builder getAnalysisReport() {
            return analysisReport != null ? analysisReport.toBuilder() : null;
        }

        public final void setAnalysisReport(AnalysisReport.BuilderImpl analysisReport) {
            this.analysisReport = analysisReport != null ? analysisReport.build() : null;
        }

        @Override
        public final Builder analysisReport(AnalysisReport analysisReport) {
            this.analysisReport = analysisReport;
            return this;
        }

        @Override
        public GetPerformanceAnalysisReportResponse build() {
            return new GetPerformanceAnalysisReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
