/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetJourneyRunExecutionMetricsResponse extends PinpointResponse implements
        ToCopyableBuilder<GetJourneyRunExecutionMetricsResponse.Builder, GetJourneyRunExecutionMetricsResponse> {
    private static final SdkField<JourneyRunExecutionMetricsResponse> JOURNEY_RUN_EXECUTION_METRICS_RESPONSE_FIELD = SdkField
            .<JourneyRunExecutionMetricsResponse> builder(MarshallingType.SDK_POJO)
            .memberName("JourneyRunExecutionMetricsResponse")
            .getter(getter(GetJourneyRunExecutionMetricsResponse::journeyRunExecutionMetricsResponse))
            .setter(setter(Builder::journeyRunExecutionMetricsResponse))
            .constructor(JourneyRunExecutionMetricsResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JourneyRunExecutionMetricsResponse")
                    .build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(JOURNEY_RUN_EXECUTION_METRICS_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final JourneyRunExecutionMetricsResponse journeyRunExecutionMetricsResponse;

    private GetJourneyRunExecutionMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.journeyRunExecutionMetricsResponse = builder.journeyRunExecutionMetricsResponse;
    }

    /**
     * Returns the value of the JourneyRunExecutionMetricsResponse property for this object.
     * 
     * @return The value of the JourneyRunExecutionMetricsResponse property for this object.
     */
    public final JourneyRunExecutionMetricsResponse journeyRunExecutionMetricsResponse() {
        return journeyRunExecutionMetricsResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(journeyRunExecutionMetricsResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJourneyRunExecutionMetricsResponse)) {
            return false;
        }
        GetJourneyRunExecutionMetricsResponse other = (GetJourneyRunExecutionMetricsResponse) obj;
        return Objects.equals(journeyRunExecutionMetricsResponse(), other.journeyRunExecutionMetricsResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetJourneyRunExecutionMetricsResponse")
                .add("JourneyRunExecutionMetricsResponse", journeyRunExecutionMetricsResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JourneyRunExecutionMetricsResponse":
            return Optional.ofNullable(clazz.cast(journeyRunExecutionMetricsResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JourneyRunExecutionMetricsResponse", JOURNEY_RUN_EXECUTION_METRICS_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetJourneyRunExecutionMetricsResponse, T> g) {
        return obj -> g.apply((GetJourneyRunExecutionMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetJourneyRunExecutionMetricsResponse> {
        /**
         * Sets the value of the JourneyRunExecutionMetricsResponse property for this object.
         *
         * @param journeyRunExecutionMetricsResponse
         *        The new value for the JourneyRunExecutionMetricsResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder journeyRunExecutionMetricsResponse(JourneyRunExecutionMetricsResponse journeyRunExecutionMetricsResponse);

        /**
         * Sets the value of the JourneyRunExecutionMetricsResponse property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link JourneyRunExecutionMetricsResponse.Builder} avoiding the need to create one manually via
         * {@link JourneyRunExecutionMetricsResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JourneyRunExecutionMetricsResponse.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #journeyRunExecutionMetricsResponse(JourneyRunExecutionMetricsResponse)}.
         * 
         * @param journeyRunExecutionMetricsResponse
         *        a consumer that will call methods on {@link JourneyRunExecutionMetricsResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #journeyRunExecutionMetricsResponse(JourneyRunExecutionMetricsResponse)
         */
        default Builder journeyRunExecutionMetricsResponse(
                Consumer<JourneyRunExecutionMetricsResponse.Builder> journeyRunExecutionMetricsResponse) {
            return journeyRunExecutionMetricsResponse(JourneyRunExecutionMetricsResponse.builder()
                    .applyMutation(journeyRunExecutionMetricsResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private JourneyRunExecutionMetricsResponse journeyRunExecutionMetricsResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetJourneyRunExecutionMetricsResponse model) {
            super(model);
            journeyRunExecutionMetricsResponse(model.journeyRunExecutionMetricsResponse);
        }

        public final JourneyRunExecutionMetricsResponse.Builder getJourneyRunExecutionMetricsResponse() {
            return journeyRunExecutionMetricsResponse != null ? journeyRunExecutionMetricsResponse.toBuilder() : null;
        }

        public final void setJourneyRunExecutionMetricsResponse(
                JourneyRunExecutionMetricsResponse.BuilderImpl journeyRunExecutionMetricsResponse) {
            this.journeyRunExecutionMetricsResponse = journeyRunExecutionMetricsResponse != null ? journeyRunExecutionMetricsResponse
                    .build() : null;
        }

        @Override
        public final Builder journeyRunExecutionMetricsResponse(
                JourneyRunExecutionMetricsResponse journeyRunExecutionMetricsResponse) {
            this.journeyRunExecutionMetricsResponse = journeyRunExecutionMetricsResponse;
            return this;
        }

        @Override
        public GetJourneyRunExecutionMetricsResponse build() {
            return new GetJourneyRunExecutionMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
