/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Get in-app messages response object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InAppMessagesResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<InAppMessagesResponse.Builder, InAppMessagesResponse> {
    private static final SdkField<List<InAppMessageCampaign>> IN_APP_MESSAGE_CAMPAIGNS_FIELD = SdkField
            .<List<InAppMessageCampaign>> builder(MarshallingType.LIST)
            .memberName("InAppMessageCampaigns")
            .getter(getter(InAppMessagesResponse::inAppMessageCampaigns))
            .setter(setter(Builder::inAppMessageCampaigns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InAppMessageCampaigns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InAppMessageCampaign> builder(MarshallingType.SDK_POJO)
                                            .constructor(InAppMessageCampaign::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IN_APP_MESSAGE_CAMPAIGNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<InAppMessageCampaign> inAppMessageCampaigns;

    private InAppMessagesResponse(BuilderImpl builder) {
        this.inAppMessageCampaigns = builder.inAppMessageCampaigns;
    }

    /**
     * For responses, this returns true if the service returned a value for the InAppMessageCampaigns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInAppMessageCampaigns() {
        return inAppMessageCampaigns != null && !(inAppMessageCampaigns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of targeted in-app message campaigns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInAppMessageCampaigns} method.
     * </p>
     * 
     * @return List of targeted in-app message campaigns.
     */
    public final List<InAppMessageCampaign> inAppMessageCampaigns() {
        return inAppMessageCampaigns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInAppMessageCampaigns() ? inAppMessageCampaigns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppMessagesResponse)) {
            return false;
        }
        InAppMessagesResponse other = (InAppMessagesResponse) obj;
        return hasInAppMessageCampaigns() == other.hasInAppMessageCampaigns()
                && Objects.equals(inAppMessageCampaigns(), other.inAppMessageCampaigns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InAppMessagesResponse")
                .add("InAppMessageCampaigns", hasInAppMessageCampaigns() ? inAppMessageCampaigns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InAppMessageCampaigns":
            return Optional.ofNullable(clazz.cast(inAppMessageCampaigns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InAppMessageCampaigns", IN_APP_MESSAGE_CAMPAIGNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InAppMessagesResponse, T> g) {
        return obj -> g.apply((InAppMessagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InAppMessagesResponse> {
        /**
         * <p>
         * List of targeted in-app message campaigns.
         * </p>
         * 
         * @param inAppMessageCampaigns
         *        List of targeted in-app message campaigns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inAppMessageCampaigns(Collection<InAppMessageCampaign> inAppMessageCampaigns);

        /**
         * <p>
         * List of targeted in-app message campaigns.
         * </p>
         * 
         * @param inAppMessageCampaigns
         *        List of targeted in-app message campaigns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inAppMessageCampaigns(InAppMessageCampaign... inAppMessageCampaigns);

        /**
         * <p>
         * List of targeted in-app message campaigns.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pinpoint.model.InAppMessageCampaign.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.pinpoint.model.InAppMessageCampaign#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pinpoint.model.InAppMessageCampaign.Builder#build()} is called
         * immediately and its result is passed to {@link #inAppMessageCampaigns(List<InAppMessageCampaign>)}.
         * 
         * @param inAppMessageCampaigns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pinpoint.model.InAppMessageCampaign.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inAppMessageCampaigns(java.util.Collection<InAppMessageCampaign>)
         */
        Builder inAppMessageCampaigns(Consumer<InAppMessageCampaign.Builder>... inAppMessageCampaigns);
    }

    static final class BuilderImpl implements Builder {
        private List<InAppMessageCampaign> inAppMessageCampaigns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InAppMessagesResponse model) {
            inAppMessageCampaigns(model.inAppMessageCampaigns);
        }

        public final List<InAppMessageCampaign.Builder> getInAppMessageCampaigns() {
            List<InAppMessageCampaign.Builder> result = ListOfInAppMessageCampaignCopier
                    .copyToBuilder(this.inAppMessageCampaigns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInAppMessageCampaigns(Collection<InAppMessageCampaign.BuilderImpl> inAppMessageCampaigns) {
            this.inAppMessageCampaigns = ListOfInAppMessageCampaignCopier.copyFromBuilder(inAppMessageCampaigns);
        }

        @Override
        public final Builder inAppMessageCampaigns(Collection<InAppMessageCampaign> inAppMessageCampaigns) {
            this.inAppMessageCampaigns = ListOfInAppMessageCampaignCopier.copy(inAppMessageCampaigns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inAppMessageCampaigns(InAppMessageCampaign... inAppMessageCampaigns) {
            inAppMessageCampaigns(Arrays.asList(inAppMessageCampaigns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inAppMessageCampaigns(Consumer<InAppMessageCampaign.Builder>... inAppMessageCampaigns) {
            inAppMessageCampaigns(Stream.of(inAppMessageCampaigns)
                    .map(c -> InAppMessageCampaign.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public InAppMessagesResponse build() {
            return new InAppMessagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
