/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVoiceTemplateRequest extends PinpointRequest implements
        ToCopyableBuilder<UpdateVoiceTemplateRequest.Builder, UpdateVoiceTemplateRequest> {
    private static final SdkField<Boolean> CREATE_NEW_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CreateNewVersion").getter(getter(UpdateVoiceTemplateRequest::createNewVersion))
            .setter(setter(Builder::createNewVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("create-new-version").build())
            .build();

    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(UpdateVoiceTemplateRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("template-name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(UpdateVoiceTemplateRequest::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").build()).build();

    private static final SdkField<VoiceTemplateRequest> VOICE_TEMPLATE_REQUEST_FIELD = SdkField
            .<VoiceTemplateRequest> builder(MarshallingType.SDK_POJO)
            .memberName("VoiceTemplateRequest")
            .getter(getter(UpdateVoiceTemplateRequest::voiceTemplateRequest))
            .setter(setter(Builder::voiceTemplateRequest))
            .constructor(VoiceTemplateRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceTemplateRequest").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_NEW_VERSION_FIELD,
            TEMPLATE_NAME_FIELD, VERSION_FIELD, VOICE_TEMPLATE_REQUEST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean createNewVersion;

    private final String templateName;

    private final String version;

    private final VoiceTemplateRequest voiceTemplateRequest;

    private UpdateVoiceTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.createNewVersion = builder.createNewVersion;
        this.templateName = builder.templateName;
        this.version = builder.version;
        this.voiceTemplateRequest = builder.voiceTemplateRequest;
    }

    /**
     * <p>
     * Specifies whether to save the updates as a new version of the message template. Valid values are: true, save the
     * updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the
     * template.
     * </p>
     * <p>
     * If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest
     * existing version of the template. If you specify a value of true for this parameter, don't specify a value for
     * the version parameter. Otherwise, an error will occur.
     * </p>
     * 
     * @return Specifies whether to save the updates as a new version of the message template. Valid values are: true,
     *         save the updates as a new version; and, false, save the updates to (overwrite) the latest existing
     *         version of the template.</p>
     *         <p>
     *         If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the
     *         latest existing version of the template. If you specify a value of true for this parameter, don't specify
     *         a value for the version parameter. Otherwise, an error will occur.
     */
    public final Boolean createNewVersion() {
        return createNewVersion;
    }

    /**
     * <p>
     * The name of the message template. A template name must start with an alphanumeric character and can contain a
     * maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-).
     * Template names are case sensitive.
     * </p>
     * 
     * @return The name of the message template. A template name must start with an alphanumeric character and can
     *         contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or
     *         hyphens (-). Template names are case sensitive.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The unique identifier for the version of the message template to update, retrieve information about, or delete.
     * To retrieve identifiers and other information for all the versions of a template, use the <link
     * linkend="templates-template-name-template-type-versions">Template Versions</link> resource.
     * </p>
     * <p>
     * If specified, this value must match the identifier for an existing template version. If specified for an update
     * operation, this value must match the identifier for the latest existing version of the template. This restriction
     * helps ensure that race conditions don't occur.
     * </p>
     * <p>
     * If you don't specify a value for this parameter, Amazon Pinpoint does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a get operation, retrieves information about the active version of the template.
     * </p>
     * </li>
     * <li>
     * <p>
     * For an update operation, saves the updates to (overwrites) the latest existing version of the template, if the
     * create-new-version parameter isn't used or is set to false.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a delete operation, deletes the template, including all versions of the template.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The unique identifier for the version of the message template to update, retrieve information about, or
     *         delete. To retrieve identifiers and other information for all the versions of a template, use the <link
     *         linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p>
     *         <p>
     *         If specified, this value must match the identifier for an existing template version. If specified for an
     *         update operation, this value must match the identifier for the latest existing version of the template.
     *         This restriction helps ensure that race conditions don't occur.
     *         </p>
     *         <p>
     *         If you don't specify a value for this parameter, Amazon Pinpoint does the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For a get operation, retrieves information about the active version of the template.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For an update operation, saves the updates to (overwrites) the latest existing version of the template,
     *         if the create-new-version parameter isn't used or is set to false.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For a delete operation, deletes the template, including all versions of the template.
     *         </p>
     *         </li>
     */
    public final String version() {
        return version;
    }

    /**
     * Returns the value of the VoiceTemplateRequest property for this object.
     * 
     * @return The value of the VoiceTemplateRequest property for this object.
     */
    public final VoiceTemplateRequest voiceTemplateRequest() {
        return voiceTemplateRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createNewVersion());
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(voiceTemplateRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVoiceTemplateRequest)) {
            return false;
        }
        UpdateVoiceTemplateRequest other = (UpdateVoiceTemplateRequest) obj;
        return Objects.equals(createNewVersion(), other.createNewVersion())
                && Objects.equals(templateName(), other.templateName()) && Objects.equals(version(), other.version())
                && Objects.equals(voiceTemplateRequest(), other.voiceTemplateRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVoiceTemplateRequest").add("CreateNewVersion", createNewVersion())
                .add("TemplateName", templateName()).add("Version", version())
                .add("VoiceTemplateRequest", voiceTemplateRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateNewVersion":
            return Optional.ofNullable(clazz.cast(createNewVersion()));
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "VoiceTemplateRequest":
            return Optional.ofNullable(clazz.cast(voiceTemplateRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("create-new-version", CREATE_NEW_VERSION_FIELD);
        map.put("template-name", TEMPLATE_NAME_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("VoiceTemplateRequest", VOICE_TEMPLATE_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVoiceTemplateRequest, T> g) {
        return obj -> g.apply((UpdateVoiceTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVoiceTemplateRequest> {
        /**
         * <p>
         * Specifies whether to save the updates as a new version of the message template. Valid values are: true, save
         * the updates as a new version; and, false, save the updates to (overwrite) the latest existing version of the
         * template.
         * </p>
         * <p>
         * If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the latest
         * existing version of the template. If you specify a value of true for this parameter, don't specify a value
         * for the version parameter. Otherwise, an error will occur.
         * </p>
         * 
         * @param createNewVersion
         *        Specifies whether to save the updates as a new version of the message template. Valid values are:
         *        true, save the updates as a new version; and, false, save the updates to (overwrite) the latest
         *        existing version of the template.</p>
         *        <p>
         *        If you don't specify a value for this parameter, Amazon Pinpoint saves the updates to (overwrites) the
         *        latest existing version of the template. If you specify a value of true for this parameter, don't
         *        specify a value for the version parameter. Otherwise, an error will occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createNewVersion(Boolean createNewVersion);

        /**
         * <p>
         * The name of the message template. A template name must start with an alphanumeric character and can contain a
         * maximum of 128 characters. The characters can be alphanumeric characters, underscores (_), or hyphens (-).
         * Template names are case sensitive.
         * </p>
         * 
         * @param templateName
         *        The name of the message template. A template name must start with an alphanumeric character and can
         *        contain a maximum of 128 characters. The characters can be alphanumeric characters, underscores (_),
         *        or hyphens (-). Template names are case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The unique identifier for the version of the message template to update, retrieve information about, or
         * delete. To retrieve identifiers and other information for all the versions of a template, use the <link
         * linkend="templates-template-name-template-type-versions">Template Versions</link> resource.
         * </p>
         * <p>
         * If specified, this value must match the identifier for an existing template version. If specified for an
         * update operation, this value must match the identifier for the latest existing version of the template. This
         * restriction helps ensure that race conditions don't occur.
         * </p>
         * <p>
         * If you don't specify a value for this parameter, Amazon Pinpoint does the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For a get operation, retrieves information about the active version of the template.
         * </p>
         * </li>
         * <li>
         * <p>
         * For an update operation, saves the updates to (overwrites) the latest existing version of the template, if
         * the create-new-version parameter isn't used or is set to false.
         * </p>
         * </li>
         * <li>
         * <p>
         * For a delete operation, deletes the template, including all versions of the template.
         * </p>
         * </li>
         * </ul>
         * 
         * @param version
         *        The unique identifier for the version of the message template to update, retrieve information about,
         *        or delete. To retrieve identifiers and other information for all the versions of a template, use the
         *        <link linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p>
         *        <p>
         *        If specified, this value must match the identifier for an existing template version. If specified for
         *        an update operation, this value must match the identifier for the latest existing version of the
         *        template. This restriction helps ensure that race conditions don't occur.
         *        </p>
         *        <p>
         *        If you don't specify a value for this parameter, Amazon Pinpoint does the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For a get operation, retrieves information about the active version of the template.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For an update operation, saves the updates to (overwrites) the latest existing version of the
         *        template, if the create-new-version parameter isn't used or is set to false.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For a delete operation, deletes the template, including all versions of the template.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * Sets the value of the VoiceTemplateRequest property for this object.
         *
         * @param voiceTemplateRequest
         *        The new value for the VoiceTemplateRequest property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceTemplateRequest(VoiceTemplateRequest voiceTemplateRequest);

        /**
         * Sets the value of the VoiceTemplateRequest property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VoiceTemplateRequest.Builder} avoiding
         * the need to create one manually via {@link VoiceTemplateRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceTemplateRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #voiceTemplateRequest(VoiceTemplateRequest)}.
         * 
         * @param voiceTemplateRequest
         *        a consumer that will call methods on {@link VoiceTemplateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceTemplateRequest(VoiceTemplateRequest)
         */
        default Builder voiceTemplateRequest(Consumer<VoiceTemplateRequest.Builder> voiceTemplateRequest) {
            return voiceTemplateRequest(VoiceTemplateRequest.builder().applyMutation(voiceTemplateRequest).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PinpointRequest.BuilderImpl implements Builder {
        private Boolean createNewVersion;

        private String templateName;

        private String version;

        private VoiceTemplateRequest voiceTemplateRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVoiceTemplateRequest model) {
            super(model);
            createNewVersion(model.createNewVersion);
            templateName(model.templateName);
            version(model.version);
            voiceTemplateRequest(model.voiceTemplateRequest);
        }

        public final Boolean getCreateNewVersion() {
            return createNewVersion;
        }

        public final void setCreateNewVersion(Boolean createNewVersion) {
            this.createNewVersion = createNewVersion;
        }

        @Override
        public final Builder createNewVersion(Boolean createNewVersion) {
            this.createNewVersion = createNewVersion;
            return this;
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final VoiceTemplateRequest.Builder getVoiceTemplateRequest() {
            return voiceTemplateRequest != null ? voiceTemplateRequest.toBuilder() : null;
        }

        public final void setVoiceTemplateRequest(VoiceTemplateRequest.BuilderImpl voiceTemplateRequest) {
            this.voiceTemplateRequest = voiceTemplateRequest != null ? voiceTemplateRequest.build() : null;
        }

        @Override
        public final Builder voiceTemplateRequest(VoiceTemplateRequest voiceTemplateRequest) {
            this.voiceTemplateRequest = voiceTemplateRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVoiceTemplateRequest build() {
            return new UpdateVoiceTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
