/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifyOtpMessageResponse extends PinpointResponse implements
        ToCopyableBuilder<VerifyOtpMessageResponse.Builder, VerifyOtpMessageResponse> {
    private static final SdkField<VerificationResponse> VERIFICATION_RESPONSE_FIELD = SdkField
            .<VerificationResponse> builder(MarshallingType.SDK_POJO)
            .memberName("VerificationResponse")
            .getter(getter(VerifyOtpMessageResponse::verificationResponse))
            .setter(setter(Builder::verificationResponse))
            .constructor(VerificationResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFICATION_RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VerificationResponse verificationResponse;

    private VerifyOtpMessageResponse(BuilderImpl builder) {
        super(builder);
        this.verificationResponse = builder.verificationResponse;
    }

    /**
     * Returns the value of the VerificationResponse property for this object.
     * 
     * @return The value of the VerificationResponse property for this object.
     */
    public final VerificationResponse verificationResponse() {
        return verificationResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verificationResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyOtpMessageResponse)) {
            return false;
        }
        VerifyOtpMessageResponse other = (VerifyOtpMessageResponse) obj;
        return Objects.equals(verificationResponse(), other.verificationResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifyOtpMessageResponse").add("VerificationResponse", verificationResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerificationResponse":
            return Optional.ofNullable(clazz.cast(verificationResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VerificationResponse", VERIFICATION_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifyOtpMessageResponse, T> g) {
        return obj -> g.apply((VerifyOtpMessageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, VerifyOtpMessageResponse> {
        /**
         * Sets the value of the VerificationResponse property for this object.
         *
         * @param verificationResponse
         *        The new value for the VerificationResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationResponse(VerificationResponse verificationResponse);

        /**
         * Sets the value of the VerificationResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VerificationResponse.Builder} avoiding
         * the need to create one manually via {@link VerificationResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerificationResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #verificationResponse(VerificationResponse)}.
         * 
         * @param verificationResponse
         *        a consumer that will call methods on {@link VerificationResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #verificationResponse(VerificationResponse)
         */
        default Builder verificationResponse(Consumer<VerificationResponse.Builder> verificationResponse) {
            return verificationResponse(VerificationResponse.builder().applyMutation(verificationResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private VerificationResponse verificationResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyOtpMessageResponse model) {
            super(model);
            verificationResponse(model.verificationResponse);
        }

        public final VerificationResponse.Builder getVerificationResponse() {
            return verificationResponse != null ? verificationResponse.toBuilder() : null;
        }

        public final void setVerificationResponse(VerificationResponse.BuilderImpl verificationResponse) {
            this.verificationResponse = verificationResponse != null ? verificationResponse.build() : null;
        }

        @Override
        public final Builder verificationResponse(VerificationResponse verificationResponse) {
            this.verificationResponse = verificationResponse;
            return this;
        }

        @Override
        public VerifyOtpMessageResponse build() {
            return new VerifyOtpMessageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
