/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.Alignment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InAppMessageBodyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InAppMessageBodyConfig> {
    private static final SdkField<String> ALIGNMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alignment").getter(InAppMessageBodyConfig.getter(InAppMessageBodyConfig::alignmentAsString)).setter(InAppMessageBodyConfig.setter(Builder::alignment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alignment").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(InAppMessageBodyConfig.getter(InAppMessageBodyConfig::body)).setter(InAppMessageBodyConfig.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> TEXT_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextColor").getter(InAppMessageBodyConfig.getter(InAppMessageBodyConfig::textColor)).setter(InAppMessageBodyConfig.setter(Builder::textColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextColor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIGNMENT_FIELD, BODY_FIELD, TEXT_COLOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InAppMessageBodyConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alignment;
    private final String body;
    private final String textColor;

    private InAppMessageBodyConfig(BuilderImpl builder) {
        this.alignment = builder.alignment;
        this.body = builder.body;
        this.textColor = builder.textColor;
    }

    public final Alignment alignment() {
        return Alignment.fromValue(this.alignment);
    }

    public final String alignmentAsString() {
        return this.alignment;
    }

    public final String body() {
        return this.body;
    }

    public final String textColor() {
        return this.textColor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alignmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.textColor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InAppMessageBodyConfig)) {
            return false;
        }
        InAppMessageBodyConfig other = (InAppMessageBodyConfig)obj;
        return Objects.equals(this.alignmentAsString(), other.alignmentAsString()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.textColor(), other.textColor());
    }

    public final String toString() {
        return ToString.builder((String)"InAppMessageBodyConfig").add("Alignment", (Object)this.alignmentAsString()).add("Body", (Object)this.body()).add("TextColor", (Object)this.textColor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alignment": {
                return Optional.ofNullable(clazz.cast(this.alignmentAsString()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "TextColor": {
                return Optional.ofNullable(clazz.cast(this.textColor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Alignment", ALIGNMENT_FIELD);
        map.put("Body", BODY_FIELD);
        map.put("TextColor", TEXT_COLOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InAppMessageBodyConfig, T> g) {
        return obj -> g.apply((InAppMessageBodyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alignment;
        private String body;
        private String textColor;

        private BuilderImpl() {
        }

        private BuilderImpl(InAppMessageBodyConfig model) {
            this.alignment(model.alignment);
            this.body(model.body);
            this.textColor(model.textColor);
        }

        public final String getAlignment() {
            return this.alignment;
        }

        public final void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        @Override
        public final Builder alignment(String alignment) {
            this.alignment = alignment;
            return this;
        }

        @Override
        public final Builder alignment(Alignment alignment) {
            this.alignment(alignment == null ? null : alignment.toString());
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getTextColor() {
            return this.textColor;
        }

        public final void setTextColor(String textColor) {
            this.textColor = textColor;
        }

        @Override
        public final Builder textColor(String textColor) {
            this.textColor = textColor;
            return this;
        }

        public InAppMessageBodyConfig build() {
            return new InAppMessageBodyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InAppMessageBodyConfig> {
        public Builder alignment(String var1);

        public Builder alignment(Alignment var1);

        public Builder body(String var1);

        public Builder textColor(String var1);
    }
}

